// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetUserGroupsByIDReader is a Reader for the GetUserGroupsByID structure.
type GetUserGroupsByIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetUserGroupsByIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetUserGroupsByIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetUserGroupsByIDMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetUserGroupsByIDBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetUserGroupsByIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetUserGroupsByIDTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /mssp/entities/user-groups/v1] getUserGroupsByID", response, response.Code())
	}
}

// NewGetUserGroupsByIDOK creates a GetUserGroupsByIDOK with default headers values
func NewGetUserGroupsByIDOK() *GetUserGroupsByIDOK {
	return &GetUserGroupsByIDOK{}
}

/*
GetUserGroupsByIDOK describes a response with status code 200, with default header values.

OK
*/
type GetUserGroupsByIDOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainUserGroupsResponseV1
}

// IsSuccess returns true when this get user groups by Id o k response has a 2xx status code
func (o *GetUserGroupsByIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get user groups by Id o k response has a 3xx status code
func (o *GetUserGroupsByIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user groups by Id o k response has a 4xx status code
func (o *GetUserGroupsByIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get user groups by Id o k response has a 5xx status code
func (o *GetUserGroupsByIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get user groups by Id o k response a status code equal to that given
func (o *GetUserGroupsByIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get user groups by Id o k response
func (o *GetUserGroupsByIDOK) Code() int {
	return 200
}

func (o *GetUserGroupsByIDOK) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/user-groups/v1][%d] getUserGroupsByIdOK  %+v", 200, o.Payload)
}

func (o *GetUserGroupsByIDOK) String() string {
	return fmt.Sprintf("[GET /mssp/entities/user-groups/v1][%d] getUserGroupsByIdOK  %+v", 200, o.Payload)
}

func (o *GetUserGroupsByIDOK) GetPayload() *models.DomainUserGroupsResponseV1 {
	return o.Payload
}

func (o *GetUserGroupsByIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainUserGroupsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserGroupsByIDMultiStatus creates a GetUserGroupsByIDMultiStatus with default headers values
func NewGetUserGroupsByIDMultiStatus() *GetUserGroupsByIDMultiStatus {
	return &GetUserGroupsByIDMultiStatus{}
}

/*
GetUserGroupsByIDMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetUserGroupsByIDMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainUserGroupsResponseV1
}

// IsSuccess returns true when this get user groups by Id multi status response has a 2xx status code
func (o *GetUserGroupsByIDMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get user groups by Id multi status response has a 3xx status code
func (o *GetUserGroupsByIDMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user groups by Id multi status response has a 4xx status code
func (o *GetUserGroupsByIDMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get user groups by Id multi status response has a 5xx status code
func (o *GetUserGroupsByIDMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get user groups by Id multi status response a status code equal to that given
func (o *GetUserGroupsByIDMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get user groups by Id multi status response
func (o *GetUserGroupsByIDMultiStatus) Code() int {
	return 207
}

func (o *GetUserGroupsByIDMultiStatus) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/user-groups/v1][%d] getUserGroupsByIdMultiStatus  %+v", 207, o.Payload)
}

func (o *GetUserGroupsByIDMultiStatus) String() string {
	return fmt.Sprintf("[GET /mssp/entities/user-groups/v1][%d] getUserGroupsByIdMultiStatus  %+v", 207, o.Payload)
}

func (o *GetUserGroupsByIDMultiStatus) GetPayload() *models.DomainUserGroupsResponseV1 {
	return o.Payload
}

func (o *GetUserGroupsByIDMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainUserGroupsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserGroupsByIDBadRequest creates a GetUserGroupsByIDBadRequest with default headers values
func NewGetUserGroupsByIDBadRequest() *GetUserGroupsByIDBadRequest {
	return &GetUserGroupsByIDBadRequest{}
}

/*
GetUserGroupsByIDBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetUserGroupsByIDBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get user groups by Id bad request response has a 2xx status code
func (o *GetUserGroupsByIDBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user groups by Id bad request response has a 3xx status code
func (o *GetUserGroupsByIDBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user groups by Id bad request response has a 4xx status code
func (o *GetUserGroupsByIDBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user groups by Id bad request response has a 5xx status code
func (o *GetUserGroupsByIDBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get user groups by Id bad request response a status code equal to that given
func (o *GetUserGroupsByIDBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get user groups by Id bad request response
func (o *GetUserGroupsByIDBadRequest) Code() int {
	return 400
}

func (o *GetUserGroupsByIDBadRequest) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/user-groups/v1][%d] getUserGroupsByIdBadRequest  %+v", 400, o.Payload)
}

func (o *GetUserGroupsByIDBadRequest) String() string {
	return fmt.Sprintf("[GET /mssp/entities/user-groups/v1][%d] getUserGroupsByIdBadRequest  %+v", 400, o.Payload)
}

func (o *GetUserGroupsByIDBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetUserGroupsByIDBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserGroupsByIDForbidden creates a GetUserGroupsByIDForbidden with default headers values
func NewGetUserGroupsByIDForbidden() *GetUserGroupsByIDForbidden {
	return &GetUserGroupsByIDForbidden{}
}

/*
GetUserGroupsByIDForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetUserGroupsByIDForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get user groups by Id forbidden response has a 2xx status code
func (o *GetUserGroupsByIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user groups by Id forbidden response has a 3xx status code
func (o *GetUserGroupsByIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user groups by Id forbidden response has a 4xx status code
func (o *GetUserGroupsByIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user groups by Id forbidden response has a 5xx status code
func (o *GetUserGroupsByIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get user groups by Id forbidden response a status code equal to that given
func (o *GetUserGroupsByIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get user groups by Id forbidden response
func (o *GetUserGroupsByIDForbidden) Code() int {
	return 403
}

func (o *GetUserGroupsByIDForbidden) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/user-groups/v1][%d] getUserGroupsByIdForbidden  %+v", 403, o.Payload)
}

func (o *GetUserGroupsByIDForbidden) String() string {
	return fmt.Sprintf("[GET /mssp/entities/user-groups/v1][%d] getUserGroupsByIdForbidden  %+v", 403, o.Payload)
}

func (o *GetUserGroupsByIDForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetUserGroupsByIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserGroupsByIDTooManyRequests creates a GetUserGroupsByIDTooManyRequests with default headers values
func NewGetUserGroupsByIDTooManyRequests() *GetUserGroupsByIDTooManyRequests {
	return &GetUserGroupsByIDTooManyRequests{}
}

/*
GetUserGroupsByIDTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetUserGroupsByIDTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get user groups by Id too many requests response has a 2xx status code
func (o *GetUserGroupsByIDTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user groups by Id too many requests response has a 3xx status code
func (o *GetUserGroupsByIDTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user groups by Id too many requests response has a 4xx status code
func (o *GetUserGroupsByIDTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user groups by Id too many requests response has a 5xx status code
func (o *GetUserGroupsByIDTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get user groups by Id too many requests response a status code equal to that given
func (o *GetUserGroupsByIDTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get user groups by Id too many requests response
func (o *GetUserGroupsByIDTooManyRequests) Code() int {
	return 429
}

func (o *GetUserGroupsByIDTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /mssp/entities/user-groups/v1][%d] getUserGroupsByIdTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetUserGroupsByIDTooManyRequests) String() string {
	return fmt.Sprintf("[GET /mssp/entities/user-groups/v1][%d] getUserGroupsByIdTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetUserGroupsByIDTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetUserGroupsByIDTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
