// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new mssp API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for mssp API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AddCIDGroupMembers(params *AddCIDGroupMembersParams, opts ...ClientOption) (*AddCIDGroupMembersOK, *AddCIDGroupMembersMultiStatus, error)

	AddRole(params *AddRoleParams, opts ...ClientOption) (*AddRoleOK, *AddRoleMultiStatus, error)

	AddUserGroupMembers(params *AddUserGroupMembersParams, opts ...ClientOption) (*AddUserGroupMembersOK, *AddUserGroupMembersMultiStatus, error)

	CreateCIDGroups(params *CreateCIDGroupsParams, opts ...ClientOption) (*CreateCIDGroupsOK, *CreateCIDGroupsMultiStatus, error)

	CreateUserGroups(params *CreateUserGroupsParams, opts ...ClientOption) (*CreateUserGroupsOK, *CreateUserGroupsMultiStatus, error)

	DeleteCIDGroupMembers(params *DeleteCIDGroupMembersParams, opts ...ClientOption) (*DeleteCIDGroupMembersOK, *DeleteCIDGroupMembersMultiStatus, error)

	DeleteCIDGroupMembersV2(params *DeleteCIDGroupMembersV2Params, opts ...ClientOption) (*DeleteCIDGroupMembersV2OK, *DeleteCIDGroupMembersV2MultiStatus, error)

	DeleteCIDGroups(params *DeleteCIDGroupsParams, opts ...ClientOption) (*DeleteCIDGroupsOK, *DeleteCIDGroupsMultiStatus, error)

	DeleteUserGroupMembers(params *DeleteUserGroupMembersParams, opts ...ClientOption) (*DeleteUserGroupMembersOK, *DeleteUserGroupMembersMultiStatus, error)

	DeleteUserGroups(params *DeleteUserGroupsParams, opts ...ClientOption) (*DeleteUserGroupsOK, *DeleteUserGroupsMultiStatus, error)

	DeletedRoles(params *DeletedRolesParams, opts ...ClientOption) (*DeletedRolesOK, *DeletedRolesMultiStatus, error)

	GetCIDGroupByID(params *GetCIDGroupByIDParams, opts ...ClientOption) (*GetCIDGroupByIDOK, *GetCIDGroupByIDMultiStatus, error)

	GetCIDGroupByIDV2(params *GetCIDGroupByIDV2Params, opts ...ClientOption) (*GetCIDGroupByIDV2OK, *GetCIDGroupByIDV2MultiStatus, error)

	GetCIDGroupMembersBy(params *GetCIDGroupMembersByParams, opts ...ClientOption) (*GetCIDGroupMembersByOK, *GetCIDGroupMembersByMultiStatus, error)

	GetCIDGroupMembersByV2(params *GetCIDGroupMembersByV2Params, opts ...ClientOption) (*GetCIDGroupMembersByV2OK, *GetCIDGroupMembersByV2MultiStatus, error)

	GetChildren(params *GetChildrenParams, opts ...ClientOption) (*GetChildrenOK, *GetChildrenMultiStatus, error)

	GetChildrenV2(params *GetChildrenV2Params, opts ...ClientOption) (*GetChildrenV2OK, *GetChildrenV2MultiStatus, error)

	GetRolesByID(params *GetRolesByIDParams, opts ...ClientOption) (*GetRolesByIDOK, *GetRolesByIDMultiStatus, error)

	GetUserGroupMembersByID(params *GetUserGroupMembersByIDParams, opts ...ClientOption) (*GetUserGroupMembersByIDOK, *GetUserGroupMembersByIDMultiStatus, error)

	GetUserGroupMembersByIDV2(params *GetUserGroupMembersByIDV2Params, opts ...ClientOption) (*GetUserGroupMembersByIDV2OK, *GetUserGroupMembersByIDV2MultiStatus, error)

	GetUserGroupsByID(params *GetUserGroupsByIDParams, opts ...ClientOption) (*GetUserGroupsByIDOK, *GetUserGroupsByIDMultiStatus, error)

	GetUserGroupsByIDV2(params *GetUserGroupsByIDV2Params, opts ...ClientOption) (*GetUserGroupsByIDV2OK, *GetUserGroupsByIDV2MultiStatus, error)

	QueryCIDGroupMembers(params *QueryCIDGroupMembersParams, opts ...ClientOption) (*QueryCIDGroupMembersOK, error)

	QueryCIDGroups(params *QueryCIDGroupsParams, opts ...ClientOption) (*QueryCIDGroupsOK, error)

	QueryChildren(params *QueryChildrenParams, opts ...ClientOption) (*QueryChildrenOK, error)

	QueryRoles(params *QueryRolesParams, opts ...ClientOption) (*QueryRolesOK, error)

	QueryUserGroupMembers(params *QueryUserGroupMembersParams, opts ...ClientOption) (*QueryUserGroupMembersOK, error)

	QueryUserGroups(params *QueryUserGroupsParams, opts ...ClientOption) (*QueryUserGroupsOK, error)

	UpdateCIDGroups(params *UpdateCIDGroupsParams, opts ...ClientOption) (*UpdateCIDGroupsOK, *UpdateCIDGroupsMultiStatus, error)

	UpdateUserGroups(params *UpdateUserGroupsParams, opts ...ClientOption) (*UpdateUserGroupsOK, *UpdateUserGroupsMultiStatus, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AddCIDGroupMembers adds new c ID group member
*/
func (a *Client) AddCIDGroupMembers(params *AddCIDGroupMembersParams, opts ...ClientOption) (*AddCIDGroupMembersOK, *AddCIDGroupMembersMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAddCIDGroupMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "addCIDGroupMembers",
		Method:             "POST",
		PathPattern:        "/mssp/entities/cid-group-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AddCIDGroupMembersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AddCIDGroupMembersOK:
		return value, nil, nil
	case *AddCIDGroupMembersMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AddRole creates a link between user group and c ID group with zero or more additional roles the call does not replace any existing link between them user group ID and c ID group ID have to be specified in request
*/
func (a *Client) AddRole(params *AddRoleParams, opts ...ClientOption) (*AddRoleOK, *AddRoleMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAddRoleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "addRole",
		Method:             "POST",
		PathPattern:        "/mssp/entities/mssp-roles/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AddRoleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AddRoleOK:
		return value, nil, nil
	case *AddRoleMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AddUserGroupMembers adds new user group member maximum 500 members allowed per user group
*/
func (a *Client) AddUserGroupMembers(params *AddUserGroupMembersParams, opts ...ClientOption) (*AddUserGroupMembersOK, *AddUserGroupMembersMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAddUserGroupMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "addUserGroupMembers",
		Method:             "POST",
		PathPattern:        "/mssp/entities/user-group-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AddUserGroupMembersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AddUserGroupMembersOK:
		return value, nil, nil
	case *AddUserGroupMembersMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateCIDGroups creates new c ID groups name is a required field but description is an optional field maximum 500 c ID groups allowed
*/
func (a *Client) CreateCIDGroups(params *CreateCIDGroupsParams, opts ...ClientOption) (*CreateCIDGroupsOK, *CreateCIDGroupsMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateCIDGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createCIDGroups",
		Method:             "POST",
		PathPattern:        "/mssp/entities/cid-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateCIDGroupsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *CreateCIDGroupsOK:
		return value, nil, nil
	case *CreateCIDGroupsMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateUserGroups creates new user groups name is a required field but description is an optional field maximum 500 user groups allowed per customer
*/
func (a *Client) CreateUserGroups(params *CreateUserGroupsParams, opts ...ClientOption) (*CreateUserGroupsOK, *CreateUserGroupsMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateUserGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createUserGroups",
		Method:             "POST",
		PathPattern:        "/mssp/entities/user-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateUserGroupsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *CreateUserGroupsOK:
		return value, nil, nil
	case *CreateUserGroupsMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteCIDGroupMembers deprecateds please use d e l e t e entities cid group members v2 delete c ID group members
*/
func (a *Client) DeleteCIDGroupMembers(params *DeleteCIDGroupMembersParams, opts ...ClientOption) (*DeleteCIDGroupMembersOK, *DeleteCIDGroupMembersMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteCIDGroupMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteCIDGroupMembers",
		Method:             "DELETE",
		PathPattern:        "/mssp/entities/cid-group-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteCIDGroupMembersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DeleteCIDGroupMembersOK:
		return value, nil, nil
	case *DeleteCIDGroupMembersMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteCIDGroupMembersV2 deletes c ID group members prevents removal of a cid group a cid group if it is only part of one cid group
*/
func (a *Client) DeleteCIDGroupMembersV2(params *DeleteCIDGroupMembersV2Params, opts ...ClientOption) (*DeleteCIDGroupMembersV2OK, *DeleteCIDGroupMembersV2MultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteCIDGroupMembersV2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteCIDGroupMembersV2",
		Method:             "DELETE",
		PathPattern:        "/mssp/entities/cid-group-members/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteCIDGroupMembersV2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DeleteCIDGroupMembersV2OK:
		return value, nil, nil
	case *DeleteCIDGroupMembersV2MultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteCIDGroups deletes c ID groups by ID
*/
func (a *Client) DeleteCIDGroups(params *DeleteCIDGroupsParams, opts ...ClientOption) (*DeleteCIDGroupsOK, *DeleteCIDGroupsMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteCIDGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteCIDGroups",
		Method:             "DELETE",
		PathPattern:        "/mssp/entities/cid-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteCIDGroupsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DeleteCIDGroupsOK:
		return value, nil, nil
	case *DeleteCIDGroupsMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteUserGroupMembers deletes user group members entry
*/
func (a *Client) DeleteUserGroupMembers(params *DeleteUserGroupMembersParams, opts ...ClientOption) (*DeleteUserGroupMembersOK, *DeleteUserGroupMembersMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteUserGroupMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteUserGroupMembers",
		Method:             "DELETE",
		PathPattern:        "/mssp/entities/user-group-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteUserGroupMembersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DeleteUserGroupMembersOK:
		return value, nil, nil
	case *DeleteUserGroupMembersMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteUserGroups deletes user groups by ID
*/
func (a *Client) DeleteUserGroups(params *DeleteUserGroupsParams, opts ...ClientOption) (*DeleteUserGroupsOK, *DeleteUserGroupsMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteUserGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteUserGroups",
		Method:             "DELETE",
		PathPattern:        "/mssp/entities/user-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteUserGroupsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DeleteUserGroupsOK:
		return value, nil, nil
	case *DeleteUserGroupsMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeletedRoles deletes links or additional roles between user groups and c ID groups user group ID and c ID group ID have to be specified in request only specified roles are removed if specified in request payload else association between user group and c ID group is dissolved completely if no roles specified
*/
func (a *Client) DeletedRoles(params *DeletedRolesParams, opts ...ClientOption) (*DeletedRolesOK, *DeletedRolesMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeletedRolesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deletedRoles",
		Method:             "DELETE",
		PathPattern:        "/mssp/entities/mssp-roles/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeletedRolesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DeletedRolesOK:
		return value, nil, nil
	case *DeletedRolesMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetCIDGroupByID deprecateds please use g e t mssp entities cid groups v2 get c ID groups by ID
*/
func (a *Client) GetCIDGroupByID(params *GetCIDGroupByIDParams, opts ...ClientOption) (*GetCIDGroupByIDOK, *GetCIDGroupByIDMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetCIDGroupByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getCIDGroupById",
		Method:             "GET",
		PathPattern:        "/mssp/entities/cid-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetCIDGroupByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GetCIDGroupByIDOK:
		return value, nil, nil
	case *GetCIDGroupByIDMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetCIDGroupByIDV2 gets c ID groups by ID
*/
func (a *Client) GetCIDGroupByIDV2(params *GetCIDGroupByIDV2Params, opts ...ClientOption) (*GetCIDGroupByIDV2OK, *GetCIDGroupByIDV2MultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetCIDGroupByIDV2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "getCIDGroupByIdV2",
		Method:             "GET",
		PathPattern:        "/mssp/entities/cid-groups/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetCIDGroupByIDV2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GetCIDGroupByIDV2OK:
		return value, nil, nil
	case *GetCIDGroupByIDV2MultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetCIDGroupMembersBy deprecateds please use g e t mssp entities cid group members v2 get c ID group members by c ID group ID
*/
func (a *Client) GetCIDGroupMembersBy(params *GetCIDGroupMembersByParams, opts ...ClientOption) (*GetCIDGroupMembersByOK, *GetCIDGroupMembersByMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetCIDGroupMembersByParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getCIDGroupMembersBy",
		Method:             "GET",
		PathPattern:        "/mssp/entities/cid-group-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetCIDGroupMembersByReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GetCIDGroupMembersByOK:
		return value, nil, nil
	case *GetCIDGroupMembersByMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetCIDGroupMembersByV2 gets c ID group members by c ID group ID
*/
func (a *Client) GetCIDGroupMembersByV2(params *GetCIDGroupMembersByV2Params, opts ...ClientOption) (*GetCIDGroupMembersByV2OK, *GetCIDGroupMembersByV2MultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetCIDGroupMembersByV2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "getCIDGroupMembersByV2",
		Method:             "GET",
		PathPattern:        "/mssp/entities/cid-group-members/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetCIDGroupMembersByV2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GetCIDGroupMembersByV2OK:
		return value, nil, nil
	case *GetCIDGroupMembersByV2MultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetChildren gets link to child customer by child c ID s
*/
func (a *Client) GetChildren(params *GetChildrenParams, opts ...ClientOption) (*GetChildrenOK, *GetChildrenMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetChildrenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getChildren",
		Method:             "GET",
		PathPattern:        "/mssp/entities/children/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetChildrenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GetChildrenOK:
		return value, nil, nil
	case *GetChildrenMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetChildrenV2 gets link to child customer by child c ID s
*/
func (a *Client) GetChildrenV2(params *GetChildrenV2Params, opts ...ClientOption) (*GetChildrenV2OK, *GetChildrenV2MultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetChildrenV2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "getChildrenV2",
		Method:             "POST",
		PathPattern:        "/mssp/entities/children/GET/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetChildrenV2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GetChildrenV2OK:
		return value, nil, nil
	case *GetChildrenV2MultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetRolesByID gets link between user group and c ID group by ID link ID is a string consisting of multiple components but should be treated as opaque
*/
func (a *Client) GetRolesByID(params *GetRolesByIDParams, opts ...ClientOption) (*GetRolesByIDOK, *GetRolesByIDMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRolesByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getRolesByID",
		Method:             "GET",
		PathPattern:        "/mssp/entities/mssp-roles/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetRolesByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GetRolesByIDOK:
		return value, nil, nil
	case *GetRolesByIDMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetUserGroupMembersByID deprecateds please use g e t mssp entities user group members v2 get user group members by user group ID
*/
func (a *Client) GetUserGroupMembersByID(params *GetUserGroupMembersByIDParams, opts ...ClientOption) (*GetUserGroupMembersByIDOK, *GetUserGroupMembersByIDMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetUserGroupMembersByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getUserGroupMembersByID",
		Method:             "GET",
		PathPattern:        "/mssp/entities/user-group-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetUserGroupMembersByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GetUserGroupMembersByIDOK:
		return value, nil, nil
	case *GetUserGroupMembersByIDMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetUserGroupMembersByIDV2 gets user group members by user group ID
*/
func (a *Client) GetUserGroupMembersByIDV2(params *GetUserGroupMembersByIDV2Params, opts ...ClientOption) (*GetUserGroupMembersByIDV2OK, *GetUserGroupMembersByIDV2MultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetUserGroupMembersByIDV2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "getUserGroupMembersByIDV2",
		Method:             "GET",
		PathPattern:        "/mssp/entities/user-group-members/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetUserGroupMembersByIDV2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GetUserGroupMembersByIDV2OK:
		return value, nil, nil
	case *GetUserGroupMembersByIDV2MultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetUserGroupsByID deprecateds please use g e t entities user groups v2 get user groups by ID
*/
func (a *Client) GetUserGroupsByID(params *GetUserGroupsByIDParams, opts ...ClientOption) (*GetUserGroupsByIDOK, *GetUserGroupsByIDMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetUserGroupsByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getUserGroupsByID",
		Method:             "GET",
		PathPattern:        "/mssp/entities/user-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetUserGroupsByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GetUserGroupsByIDOK:
		return value, nil, nil
	case *GetUserGroupsByIDMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetUserGroupsByIDV2 gets user groups by ID
*/
func (a *Client) GetUserGroupsByIDV2(params *GetUserGroupsByIDV2Params, opts ...ClientOption) (*GetUserGroupsByIDV2OK, *GetUserGroupsByIDV2MultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetUserGroupsByIDV2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "getUserGroupsByIDV2",
		Method:             "GET",
		PathPattern:        "/mssp/entities/user-groups/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetUserGroupsByIDV2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GetUserGroupsByIDV2OK:
		return value, nil, nil
	case *GetUserGroupsByIDV2MultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryCIDGroupMembers queries a c ID groups members by associated c ID
*/
func (a *Client) QueryCIDGroupMembers(params *QueryCIDGroupMembersParams, opts ...ClientOption) (*QueryCIDGroupMembersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryCIDGroupMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryCIDGroupMembers",
		Method:             "GET",
		PathPattern:        "/mssp/queries/cid-group-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryCIDGroupMembersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryCIDGroupMembersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryCIDGroupMembers: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryCIDGroups queries c ID groups
*/
func (a *Client) QueryCIDGroups(params *QueryCIDGroupsParams, opts ...ClientOption) (*QueryCIDGroupsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryCIDGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryCIDGroups",
		Method:             "GET",
		PathPattern:        "/mssp/queries/cid-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryCIDGroupsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryCIDGroupsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryCIDGroups: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryChildren queries for customers linked as children
*/
func (a *Client) QueryChildren(params *QueryChildrenParams, opts ...ClientOption) (*QueryChildrenOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryChildrenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryChildren",
		Method:             "GET",
		PathPattern:        "/mssp/queries/children/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryChildrenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryChildrenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryChildren: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryRoles queries links between user groups and c ID groups at least one of c ID group ID or user group ID should also be provided role ID is optional
*/
func (a *Client) QueryRoles(params *QueryRolesParams, opts ...ClientOption) (*QueryRolesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryRolesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryRoles",
		Method:             "GET",
		PathPattern:        "/mssp/queries/mssp-roles/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryRolesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryRolesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryRoles: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryUserGroupMembers queries user group member by user UUID
*/
func (a *Client) QueryUserGroupMembers(params *QueryUserGroupMembersParams, opts ...ClientOption) (*QueryUserGroupMembersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryUserGroupMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryUserGroupMembers",
		Method:             "GET",
		PathPattern:        "/mssp/queries/user-group-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryUserGroupMembersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryUserGroupMembersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryUserGroupMembers: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryUserGroups queries user groups
*/
func (a *Client) QueryUserGroups(params *QueryUserGroupsParams, opts ...ClientOption) (*QueryUserGroupsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryUserGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryUserGroups",
		Method:             "GET",
		PathPattern:        "/mssp/queries/user-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryUserGroupsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryUserGroupsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryUserGroups: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateCIDGroups updates existing c ID groups c ID group ID is expected for each c ID group definition provided in request body name is a required field but description is an optional field empty description will override existing value c ID group member s remain unaffected
*/
func (a *Client) UpdateCIDGroups(params *UpdateCIDGroupsParams, opts ...ClientOption) (*UpdateCIDGroupsOK, *UpdateCIDGroupsMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateCIDGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateCIDGroups",
		Method:             "PATCH",
		PathPattern:        "/mssp/entities/cid-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateCIDGroupsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *UpdateCIDGroupsOK:
		return value, nil, nil
	case *UpdateCIDGroupsMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateUserGroups updates existing user group s user group ID is expected for each user group definition provided in request body name is a required field but description is an optional field empty description will override existing value user group member s remain unaffected
*/
func (a *Client) UpdateUserGroups(params *UpdateUserGroupsParams, opts ...ClientOption) (*UpdateUserGroupsOK, *UpdateUserGroupsMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateUserGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateUserGroups",
		Method:             "PATCH",
		PathPattern:        "/mssp/entities/user-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateUserGroupsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *UpdateUserGroupsOK:
		return value, nil, nil
	case *UpdateUserGroupsMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for mssp: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
