// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryCIDGroupMembersParams creates a new QueryCIDGroupMembersParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryCIDGroupMembersParams() *QueryCIDGroupMembersParams {
	return &QueryCIDGroupMembersParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryCIDGroupMembersParamsWithTimeout creates a new QueryCIDGroupMembersParams object
// with the ability to set a timeout on a request.
func NewQueryCIDGroupMembersParamsWithTimeout(timeout time.Duration) *QueryCIDGroupMembersParams {
	return &QueryCIDGroupMembersParams{
		timeout: timeout,
	}
}

// NewQueryCIDGroupMembersParamsWithContext creates a new QueryCIDGroupMembersParams object
// with the ability to set a context for a request.
func NewQueryCIDGroupMembersParamsWithContext(ctx context.Context) *QueryCIDGroupMembersParams {
	return &QueryCIDGroupMembersParams{
		Context: ctx,
	}
}

// NewQueryCIDGroupMembersParamsWithHTTPClient creates a new QueryCIDGroupMembersParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryCIDGroupMembersParamsWithHTTPClient(client *http.Client) *QueryCIDGroupMembersParams {
	return &QueryCIDGroupMembersParams{
		HTTPClient: client,
	}
}

/*
QueryCIDGroupMembersParams contains all the parameters to send to the API endpoint

	for the query c ID group members operation.

	Typically these are written to a http.Request.
*/
type QueryCIDGroupMembersParams struct {

	/* Cid.

	   CID to lookup associated CID group ID
	*/
	Cid string

	/* Limit.

	   Maximum number of results to return

	   Default: 10
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return id
	*/
	Offset *int64

	/* Sort.

	   The sort expression used to sort the results

	   Default: "last_modified_timestamp|desc"
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query c ID group members params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryCIDGroupMembersParams) WithDefaults() *QueryCIDGroupMembersParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query c ID group members params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryCIDGroupMembersParams) SetDefaults() {
	var (
		limitDefault = int64(10)

		offsetDefault = int64(0)

		sortDefault = string("last_modified_timestamp|desc")
	)

	val := QueryCIDGroupMembersParams{
		Limit:  &limitDefault,
		Offset: &offsetDefault,
		Sort:   &sortDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the query c ID group members params
func (o *QueryCIDGroupMembersParams) WithTimeout(timeout time.Duration) *QueryCIDGroupMembersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query c ID group members params
func (o *QueryCIDGroupMembersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query c ID group members params
func (o *QueryCIDGroupMembersParams) WithContext(ctx context.Context) *QueryCIDGroupMembersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query c ID group members params
func (o *QueryCIDGroupMembersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query c ID group members params
func (o *QueryCIDGroupMembersParams) WithHTTPClient(client *http.Client) *QueryCIDGroupMembersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query c ID group members params
func (o *QueryCIDGroupMembersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCid adds the cid to the query c ID group members params
func (o *QueryCIDGroupMembersParams) WithCid(cid string) *QueryCIDGroupMembersParams {
	o.SetCid(cid)
	return o
}

// SetCid adds the cid to the query c ID group members params
func (o *QueryCIDGroupMembersParams) SetCid(cid string) {
	o.Cid = cid
}

// WithLimit adds the limit to the query c ID group members params
func (o *QueryCIDGroupMembersParams) WithLimit(limit *int64) *QueryCIDGroupMembersParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query c ID group members params
func (o *QueryCIDGroupMembersParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query c ID group members params
func (o *QueryCIDGroupMembersParams) WithOffset(offset *int64) *QueryCIDGroupMembersParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query c ID group members params
func (o *QueryCIDGroupMembersParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the query c ID group members params
func (o *QueryCIDGroupMembersParams) WithSort(sort *string) *QueryCIDGroupMembersParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query c ID group members params
func (o *QueryCIDGroupMembersParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryCIDGroupMembersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param cid
	qrCid := o.Cid
	qCid := qrCid
	if qCid != "" {

		if err := r.SetQueryParam("cid", qCid); err != nil {
			return err
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
