// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryCIDGroupMembersReader is a Reader for the QueryCIDGroupMembers structure.
type QueryCIDGroupMembersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryCIDGroupMembersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryCIDGroupMembersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewQueryCIDGroupMembersForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryCIDGroupMembersTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /mssp/queries/cid-group-members/v1] queryCIDGroupMembers", response, response.Code())
	}
}

// NewQueryCIDGroupMembersOK creates a QueryCIDGroupMembersOK with default headers values
func NewQueryCIDGroupMembersOK() *QueryCIDGroupMembersOK {
	return &QueryCIDGroupMembersOK{}
}

/*
QueryCIDGroupMembersOK describes a response with status code 200, with default header values.

OK
*/
type QueryCIDGroupMembersOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query c Id group members o k response has a 2xx status code
func (o *QueryCIDGroupMembersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query c Id group members o k response has a 3xx status code
func (o *QueryCIDGroupMembersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query c Id group members o k response has a 4xx status code
func (o *QueryCIDGroupMembersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query c Id group members o k response has a 5xx status code
func (o *QueryCIDGroupMembersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query c Id group members o k response a status code equal to that given
func (o *QueryCIDGroupMembersOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query c Id group members o k response
func (o *QueryCIDGroupMembersOK) Code() int {
	return 200
}

func (o *QueryCIDGroupMembersOK) Error() string {
	return fmt.Sprintf("[GET /mssp/queries/cid-group-members/v1][%d] queryCIdGroupMembersOK  %+v", 200, o.Payload)
}

func (o *QueryCIDGroupMembersOK) String() string {
	return fmt.Sprintf("[GET /mssp/queries/cid-group-members/v1][%d] queryCIdGroupMembersOK  %+v", 200, o.Payload)
}

func (o *QueryCIDGroupMembersOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryCIDGroupMembersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCIDGroupMembersForbidden creates a QueryCIDGroupMembersForbidden with default headers values
func NewQueryCIDGroupMembersForbidden() *QueryCIDGroupMembersForbidden {
	return &QueryCIDGroupMembersForbidden{}
}

/*
QueryCIDGroupMembersForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryCIDGroupMembersForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query c Id group members forbidden response has a 2xx status code
func (o *QueryCIDGroupMembersForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query c Id group members forbidden response has a 3xx status code
func (o *QueryCIDGroupMembersForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query c Id group members forbidden response has a 4xx status code
func (o *QueryCIDGroupMembersForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query c Id group members forbidden response has a 5xx status code
func (o *QueryCIDGroupMembersForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query c Id group members forbidden response a status code equal to that given
func (o *QueryCIDGroupMembersForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query c Id group members forbidden response
func (o *QueryCIDGroupMembersForbidden) Code() int {
	return 403
}

func (o *QueryCIDGroupMembersForbidden) Error() string {
	return fmt.Sprintf("[GET /mssp/queries/cid-group-members/v1][%d] queryCIdGroupMembersForbidden  %+v", 403, o.Payload)
}

func (o *QueryCIDGroupMembersForbidden) String() string {
	return fmt.Sprintf("[GET /mssp/queries/cid-group-members/v1][%d] queryCIdGroupMembersForbidden  %+v", 403, o.Payload)
}

func (o *QueryCIDGroupMembersForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryCIDGroupMembersForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCIDGroupMembersTooManyRequests creates a QueryCIDGroupMembersTooManyRequests with default headers values
func NewQueryCIDGroupMembersTooManyRequests() *QueryCIDGroupMembersTooManyRequests {
	return &QueryCIDGroupMembersTooManyRequests{}
}

/*
QueryCIDGroupMembersTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryCIDGroupMembersTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query c Id group members too many requests response has a 2xx status code
func (o *QueryCIDGroupMembersTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query c Id group members too many requests response has a 3xx status code
func (o *QueryCIDGroupMembersTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query c Id group members too many requests response has a 4xx status code
func (o *QueryCIDGroupMembersTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query c Id group members too many requests response has a 5xx status code
func (o *QueryCIDGroupMembersTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query c Id group members too many requests response a status code equal to that given
func (o *QueryCIDGroupMembersTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query c Id group members too many requests response
func (o *QueryCIDGroupMembersTooManyRequests) Code() int {
	return 429
}

func (o *QueryCIDGroupMembersTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /mssp/queries/cid-group-members/v1][%d] queryCIdGroupMembersTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCIDGroupMembersTooManyRequests) String() string {
	return fmt.Sprintf("[GET /mssp/queries/cid-group-members/v1][%d] queryCIdGroupMembersTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCIDGroupMembersTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryCIDGroupMembersTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
