// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryCIDGroupsParams creates a new QueryCIDGroupsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryCIDGroupsParams() *QueryCIDGroupsParams {
	return &QueryCIDGroupsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryCIDGroupsParamsWithTimeout creates a new QueryCIDGroupsParams object
// with the ability to set a timeout on a request.
func NewQueryCIDGroupsParamsWithTimeout(timeout time.Duration) *QueryCIDGroupsParams {
	return &QueryCIDGroupsParams{
		timeout: timeout,
	}
}

// NewQueryCIDGroupsParamsWithContext creates a new QueryCIDGroupsParams object
// with the ability to set a context for a request.
func NewQueryCIDGroupsParamsWithContext(ctx context.Context) *QueryCIDGroupsParams {
	return &QueryCIDGroupsParams{
		Context: ctx,
	}
}

// NewQueryCIDGroupsParamsWithHTTPClient creates a new QueryCIDGroupsParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryCIDGroupsParamsWithHTTPClient(client *http.Client) *QueryCIDGroupsParams {
	return &QueryCIDGroupsParams{
		HTTPClient: client,
	}
}

/*
QueryCIDGroupsParams contains all the parameters to send to the API endpoint

	for the query c ID groups operation.

	Typically these are written to a http.Request.
*/
type QueryCIDGroupsParams struct {

	/* Limit.

	   Maximum number of results to return

	   Default: 10
	*/
	Limit *int64

	/* Name.

	   Name to lookup groups for
	*/
	Name *string

	/* Offset.

	   Starting index of overall result set from which to return ids
	*/
	Offset *int64

	/* Sort.

	   The sort expression used to sort the results

	   Default: "name|asc"
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query c ID groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryCIDGroupsParams) WithDefaults() *QueryCIDGroupsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query c ID groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryCIDGroupsParams) SetDefaults() {
	var (
		limitDefault = int64(10)

		offsetDefault = int64(0)

		sortDefault = string("name|asc")
	)

	val := QueryCIDGroupsParams{
		Limit:  &limitDefault,
		Offset: &offsetDefault,
		Sort:   &sortDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the query c ID groups params
func (o *QueryCIDGroupsParams) WithTimeout(timeout time.Duration) *QueryCIDGroupsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query c ID groups params
func (o *QueryCIDGroupsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query c ID groups params
func (o *QueryCIDGroupsParams) WithContext(ctx context.Context) *QueryCIDGroupsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query c ID groups params
func (o *QueryCIDGroupsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query c ID groups params
func (o *QueryCIDGroupsParams) WithHTTPClient(client *http.Client) *QueryCIDGroupsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query c ID groups params
func (o *QueryCIDGroupsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLimit adds the limit to the query c ID groups params
func (o *QueryCIDGroupsParams) WithLimit(limit *int64) *QueryCIDGroupsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query c ID groups params
func (o *QueryCIDGroupsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithName adds the name to the query c ID groups params
func (o *QueryCIDGroupsParams) WithName(name *string) *QueryCIDGroupsParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the query c ID groups params
func (o *QueryCIDGroupsParams) SetName(name *string) {
	o.Name = name
}

// WithOffset adds the offset to the query c ID groups params
func (o *QueryCIDGroupsParams) WithOffset(offset *int64) *QueryCIDGroupsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query c ID groups params
func (o *QueryCIDGroupsParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the query c ID groups params
func (o *QueryCIDGroupsParams) WithSort(sort *string) *QueryCIDGroupsParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query c ID groups params
func (o *QueryCIDGroupsParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryCIDGroupsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
