// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryChildrenParams creates a new QueryChildrenParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryChildrenParams() *QueryChildrenParams {
	return &QueryChildrenParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryChildrenParamsWithTimeout creates a new QueryChildrenParams object
// with the ability to set a timeout on a request.
func NewQueryChildrenParamsWithTimeout(timeout time.Duration) *QueryChildrenParams {
	return &QueryChildrenParams{
		timeout: timeout,
	}
}

// NewQueryChildrenParamsWithContext creates a new QueryChildrenParams object
// with the ability to set a context for a request.
func NewQueryChildrenParamsWithContext(ctx context.Context) *QueryChildrenParams {
	return &QueryChildrenParams{
		Context: ctx,
	}
}

// NewQueryChildrenParamsWithHTTPClient creates a new QueryChildrenParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryChildrenParamsWithHTTPClient(client *http.Client) *QueryChildrenParams {
	return &QueryChildrenParams{
		HTTPClient: client,
	}
}

/*
QueryChildrenParams contains all the parameters to send to the API endpoint

	for the query children operation.

	Typically these are written to a http.Request.
*/
type QueryChildrenParams struct {

	/* Filter.

	   Filter using a query in Falcon Query Language (FQL). Supported filters: cid
	*/
	Filter *string

	/* Limit.

	   Number of ids to return

	   Default: 10
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return ids
	*/
	Offset *int64

	/* Sort.

	   The sort expression used to sort the results

	   Default: "last_modified_timestamp|desc"
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query children params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryChildrenParams) WithDefaults() *QueryChildrenParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query children params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryChildrenParams) SetDefaults() {
	var (
		limitDefault = int64(10)

		offsetDefault = int64(0)

		sortDefault = string("last_modified_timestamp|desc")
	)

	val := QueryChildrenParams{
		Limit:  &limitDefault,
		Offset: &offsetDefault,
		Sort:   &sortDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the query children params
func (o *QueryChildrenParams) WithTimeout(timeout time.Duration) *QueryChildrenParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query children params
func (o *QueryChildrenParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query children params
func (o *QueryChildrenParams) WithContext(ctx context.Context) *QueryChildrenParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query children params
func (o *QueryChildrenParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query children params
func (o *QueryChildrenParams) WithHTTPClient(client *http.Client) *QueryChildrenParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query children params
func (o *QueryChildrenParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query children params
func (o *QueryChildrenParams) WithFilter(filter *string) *QueryChildrenParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query children params
func (o *QueryChildrenParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query children params
func (o *QueryChildrenParams) WithLimit(limit *int64) *QueryChildrenParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query children params
func (o *QueryChildrenParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query children params
func (o *QueryChildrenParams) WithOffset(offset *int64) *QueryChildrenParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query children params
func (o *QueryChildrenParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the query children params
func (o *QueryChildrenParams) WithSort(sort *string) *QueryChildrenParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query children params
func (o *QueryChildrenParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryChildrenParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
