// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryRolesParams creates a new QueryRolesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryRolesParams() *QueryRolesParams {
	return &QueryRolesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryRolesParamsWithTimeout creates a new QueryRolesParams object
// with the ability to set a timeout on a request.
func NewQueryRolesParamsWithTimeout(timeout time.Duration) *QueryRolesParams {
	return &QueryRolesParams{
		timeout: timeout,
	}
}

// NewQueryRolesParamsWithContext creates a new QueryRolesParams object
// with the ability to set a context for a request.
func NewQueryRolesParamsWithContext(ctx context.Context) *QueryRolesParams {
	return &QueryRolesParams{
		Context: ctx,
	}
}

// NewQueryRolesParamsWithHTTPClient creates a new QueryRolesParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryRolesParamsWithHTTPClient(client *http.Client) *QueryRolesParams {
	return &QueryRolesParams{
		HTTPClient: client,
	}
}

/*
QueryRolesParams contains all the parameters to send to the API endpoint

	for the query roles operation.

	Typically these are written to a http.Request.
*/
type QueryRolesParams struct {

	/* CidGroupID.

	   CID group ID to fetch MSSP role for
	*/
	CidGroupID *string

	/* Limit.

	   Maximum number of results to return

	   Default: 10
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return ids
	*/
	Offset *int64

	/* RoleID.

	   Role ID to fetch MSSP role for
	*/
	RoleID *string

	/* Sort.

	   The sort expression used to sort the results

	   Default: "last_modified_timestamp|desc"
	*/
	Sort *string

	/* UserGroupID.

	   User group ID to fetch MSSP role for
	*/
	UserGroupID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query roles params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryRolesParams) WithDefaults() *QueryRolesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query roles params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryRolesParams) SetDefaults() {
	var (
		limitDefault = int64(10)

		offsetDefault = int64(0)

		sortDefault = string("last_modified_timestamp|desc")
	)

	val := QueryRolesParams{
		Limit:  &limitDefault,
		Offset: &offsetDefault,
		Sort:   &sortDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the query roles params
func (o *QueryRolesParams) WithTimeout(timeout time.Duration) *QueryRolesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query roles params
func (o *QueryRolesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query roles params
func (o *QueryRolesParams) WithContext(ctx context.Context) *QueryRolesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query roles params
func (o *QueryRolesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query roles params
func (o *QueryRolesParams) WithHTTPClient(client *http.Client) *QueryRolesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query roles params
func (o *QueryRolesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCidGroupID adds the cidGroupID to the query roles params
func (o *QueryRolesParams) WithCidGroupID(cidGroupID *string) *QueryRolesParams {
	o.SetCidGroupID(cidGroupID)
	return o
}

// SetCidGroupID adds the cidGroupId to the query roles params
func (o *QueryRolesParams) SetCidGroupID(cidGroupID *string) {
	o.CidGroupID = cidGroupID
}

// WithLimit adds the limit to the query roles params
func (o *QueryRolesParams) WithLimit(limit *int64) *QueryRolesParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query roles params
func (o *QueryRolesParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query roles params
func (o *QueryRolesParams) WithOffset(offset *int64) *QueryRolesParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query roles params
func (o *QueryRolesParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithRoleID adds the roleID to the query roles params
func (o *QueryRolesParams) WithRoleID(roleID *string) *QueryRolesParams {
	o.SetRoleID(roleID)
	return o
}

// SetRoleID adds the roleId to the query roles params
func (o *QueryRolesParams) SetRoleID(roleID *string) {
	o.RoleID = roleID
}

// WithSort adds the sort to the query roles params
func (o *QueryRolesParams) WithSort(sort *string) *QueryRolesParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query roles params
func (o *QueryRolesParams) SetSort(sort *string) {
	o.Sort = sort
}

// WithUserGroupID adds the userGroupID to the query roles params
func (o *QueryRolesParams) WithUserGroupID(userGroupID *string) *QueryRolesParams {
	o.SetUserGroupID(userGroupID)
	return o
}

// SetUserGroupID adds the userGroupId to the query roles params
func (o *QueryRolesParams) SetUserGroupID(userGroupID *string) {
	o.UserGroupID = userGroupID
}

// WriteToRequest writes these params to a swagger request
func (o *QueryRolesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CidGroupID != nil {

		// query param cid_group_id
		var qrCidGroupID string

		if o.CidGroupID != nil {
			qrCidGroupID = *o.CidGroupID
		}
		qCidGroupID := qrCidGroupID
		if qCidGroupID != "" {

			if err := r.SetQueryParam("cid_group_id", qCidGroupID); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.RoleID != nil {

		// query param role_id
		var qrRoleID string

		if o.RoleID != nil {
			qrRoleID = *o.RoleID
		}
		qRoleID := qrRoleID
		if qRoleID != "" {

			if err := r.SetQueryParam("role_id", qRoleID); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if o.UserGroupID != nil {

		// query param user_group_id
		var qrUserGroupID string

		if o.UserGroupID != nil {
			qrUserGroupID = *o.UserGroupID
		}
		qUserGroupID := qrUserGroupID
		if qUserGroupID != "" {

			if err := r.SetQueryParam("user_group_id", qUserGroupID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
