// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryRolesReader is a Reader for the QueryRoles structure.
type QueryRolesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryRolesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryRolesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewQueryRolesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryRolesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /mssp/queries/mssp-roles/v1] queryRoles", response, response.Code())
	}
}

// NewQueryRolesOK creates a QueryRolesOK with default headers values
func NewQueryRolesOK() *QueryRolesOK {
	return &QueryRolesOK{}
}

/*
QueryRolesOK describes a response with status code 200, with default header values.

OK
*/
type QueryRolesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query roles o k response has a 2xx status code
func (o *QueryRolesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query roles o k response has a 3xx status code
func (o *QueryRolesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query roles o k response has a 4xx status code
func (o *QueryRolesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query roles o k response has a 5xx status code
func (o *QueryRolesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query roles o k response a status code equal to that given
func (o *QueryRolesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query roles o k response
func (o *QueryRolesOK) Code() int {
	return 200
}

func (o *QueryRolesOK) Error() string {
	return fmt.Sprintf("[GET /mssp/queries/mssp-roles/v1][%d] queryRolesOK  %+v", 200, o.Payload)
}

func (o *QueryRolesOK) String() string {
	return fmt.Sprintf("[GET /mssp/queries/mssp-roles/v1][%d] queryRolesOK  %+v", 200, o.Payload)
}

func (o *QueryRolesOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryRolesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRolesForbidden creates a QueryRolesForbidden with default headers values
func NewQueryRolesForbidden() *QueryRolesForbidden {
	return &QueryRolesForbidden{}
}

/*
QueryRolesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryRolesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query roles forbidden response has a 2xx status code
func (o *QueryRolesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query roles forbidden response has a 3xx status code
func (o *QueryRolesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query roles forbidden response has a 4xx status code
func (o *QueryRolesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query roles forbidden response has a 5xx status code
func (o *QueryRolesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query roles forbidden response a status code equal to that given
func (o *QueryRolesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query roles forbidden response
func (o *QueryRolesForbidden) Code() int {
	return 403
}

func (o *QueryRolesForbidden) Error() string {
	return fmt.Sprintf("[GET /mssp/queries/mssp-roles/v1][%d] queryRolesForbidden  %+v", 403, o.Payload)
}

func (o *QueryRolesForbidden) String() string {
	return fmt.Sprintf("[GET /mssp/queries/mssp-roles/v1][%d] queryRolesForbidden  %+v", 403, o.Payload)
}

func (o *QueryRolesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryRolesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRolesTooManyRequests creates a QueryRolesTooManyRequests with default headers values
func NewQueryRolesTooManyRequests() *QueryRolesTooManyRequests {
	return &QueryRolesTooManyRequests{}
}

/*
QueryRolesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryRolesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query roles too many requests response has a 2xx status code
func (o *QueryRolesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query roles too many requests response has a 3xx status code
func (o *QueryRolesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query roles too many requests response has a 4xx status code
func (o *QueryRolesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query roles too many requests response has a 5xx status code
func (o *QueryRolesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query roles too many requests response a status code equal to that given
func (o *QueryRolesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query roles too many requests response
func (o *QueryRolesTooManyRequests) Code() int {
	return 429
}

func (o *QueryRolesTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /mssp/queries/mssp-roles/v1][%d] queryRolesTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryRolesTooManyRequests) String() string {
	return fmt.Sprintf("[GET /mssp/queries/mssp-roles/v1][%d] queryRolesTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryRolesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryRolesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
