// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryUserGroupsReader is a Reader for the QueryUserGroups structure.
type QueryUserGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryUserGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryUserGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryUserGroupsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryUserGroupsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryUserGroupsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /mssp/queries/user-groups/v1] queryUserGroups", response, response.Code())
	}
}

// NewQueryUserGroupsOK creates a QueryUserGroupsOK with default headers values
func NewQueryUserGroupsOK() *QueryUserGroupsOK {
	return &QueryUserGroupsOK{}
}

/*
QueryUserGroupsOK describes a response with status code 200, with default header values.

OK
*/
type QueryUserGroupsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query user groups o k response has a 2xx status code
func (o *QueryUserGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query user groups o k response has a 3xx status code
func (o *QueryUserGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query user groups o k response has a 4xx status code
func (o *QueryUserGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query user groups o k response has a 5xx status code
func (o *QueryUserGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query user groups o k response a status code equal to that given
func (o *QueryUserGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query user groups o k response
func (o *QueryUserGroupsOK) Code() int {
	return 200
}

func (o *QueryUserGroupsOK) Error() string {
	return fmt.Sprintf("[GET /mssp/queries/user-groups/v1][%d] queryUserGroupsOK  %+v", 200, o.Payload)
}

func (o *QueryUserGroupsOK) String() string {
	return fmt.Sprintf("[GET /mssp/queries/user-groups/v1][%d] queryUserGroupsOK  %+v", 200, o.Payload)
}

func (o *QueryUserGroupsOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryUserGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryUserGroupsBadRequest creates a QueryUserGroupsBadRequest with default headers values
func NewQueryUserGroupsBadRequest() *QueryUserGroupsBadRequest {
	return &QueryUserGroupsBadRequest{}
}

/*
QueryUserGroupsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryUserGroupsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query user groups bad request response has a 2xx status code
func (o *QueryUserGroupsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query user groups bad request response has a 3xx status code
func (o *QueryUserGroupsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query user groups bad request response has a 4xx status code
func (o *QueryUserGroupsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query user groups bad request response has a 5xx status code
func (o *QueryUserGroupsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query user groups bad request response a status code equal to that given
func (o *QueryUserGroupsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query user groups bad request response
func (o *QueryUserGroupsBadRequest) Code() int {
	return 400
}

func (o *QueryUserGroupsBadRequest) Error() string {
	return fmt.Sprintf("[GET /mssp/queries/user-groups/v1][%d] queryUserGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryUserGroupsBadRequest) String() string {
	return fmt.Sprintf("[GET /mssp/queries/user-groups/v1][%d] queryUserGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryUserGroupsBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryUserGroupsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryUserGroupsForbidden creates a QueryUserGroupsForbidden with default headers values
func NewQueryUserGroupsForbidden() *QueryUserGroupsForbidden {
	return &QueryUserGroupsForbidden{}
}

/*
QueryUserGroupsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryUserGroupsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query user groups forbidden response has a 2xx status code
func (o *QueryUserGroupsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query user groups forbidden response has a 3xx status code
func (o *QueryUserGroupsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query user groups forbidden response has a 4xx status code
func (o *QueryUserGroupsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query user groups forbidden response has a 5xx status code
func (o *QueryUserGroupsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query user groups forbidden response a status code equal to that given
func (o *QueryUserGroupsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query user groups forbidden response
func (o *QueryUserGroupsForbidden) Code() int {
	return 403
}

func (o *QueryUserGroupsForbidden) Error() string {
	return fmt.Sprintf("[GET /mssp/queries/user-groups/v1][%d] queryUserGroupsForbidden  %+v", 403, o.Payload)
}

func (o *QueryUserGroupsForbidden) String() string {
	return fmt.Sprintf("[GET /mssp/queries/user-groups/v1][%d] queryUserGroupsForbidden  %+v", 403, o.Payload)
}

func (o *QueryUserGroupsForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryUserGroupsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryUserGroupsTooManyRequests creates a QueryUserGroupsTooManyRequests with default headers values
func NewQueryUserGroupsTooManyRequests() *QueryUserGroupsTooManyRequests {
	return &QueryUserGroupsTooManyRequests{}
}

/*
QueryUserGroupsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryUserGroupsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query user groups too many requests response has a 2xx status code
func (o *QueryUserGroupsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query user groups too many requests response has a 3xx status code
func (o *QueryUserGroupsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query user groups too many requests response has a 4xx status code
func (o *QueryUserGroupsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query user groups too many requests response has a 5xx status code
func (o *QueryUserGroupsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query user groups too many requests response a status code equal to that given
func (o *QueryUserGroupsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query user groups too many requests response
func (o *QueryUserGroupsTooManyRequests) Code() int {
	return 429
}

func (o *QueryUserGroupsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /mssp/queries/user-groups/v1][%d] queryUserGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryUserGroupsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /mssp/queries/user-groups/v1][%d] queryUserGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryUserGroupsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryUserGroupsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
