// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateCIDGroupsReader is a Reader for the UpdateCIDGroups structure.
type UpdateCIDGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateCIDGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateCIDGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewUpdateCIDGroupsMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateCIDGroupsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateCIDGroupsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateCIDGroupsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /mssp/entities/cid-groups/v1] updateCIDGroups", response, response.Code())
	}
}

// NewUpdateCIDGroupsOK creates a UpdateCIDGroupsOK with default headers values
func NewUpdateCIDGroupsOK() *UpdateCIDGroupsOK {
	return &UpdateCIDGroupsOK{}
}

/*
UpdateCIDGroupsOK describes a response with status code 200, with default header values.

OK
*/
type UpdateCIDGroupsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainCIDGroupsResponseV1
}

// IsSuccess returns true when this update c Id groups o k response has a 2xx status code
func (o *UpdateCIDGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update c Id groups o k response has a 3xx status code
func (o *UpdateCIDGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update c Id groups o k response has a 4xx status code
func (o *UpdateCIDGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update c Id groups o k response has a 5xx status code
func (o *UpdateCIDGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update c Id groups o k response a status code equal to that given
func (o *UpdateCIDGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update c Id groups o k response
func (o *UpdateCIDGroupsOK) Code() int {
	return 200
}

func (o *UpdateCIDGroupsOK) Error() string {
	return fmt.Sprintf("[PATCH /mssp/entities/cid-groups/v1][%d] updateCIdGroupsOK  %+v", 200, o.Payload)
}

func (o *UpdateCIDGroupsOK) String() string {
	return fmt.Sprintf("[PATCH /mssp/entities/cid-groups/v1][%d] updateCIdGroupsOK  %+v", 200, o.Payload)
}

func (o *UpdateCIDGroupsOK) GetPayload() *models.DomainCIDGroupsResponseV1 {
	return o.Payload
}

func (o *UpdateCIDGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainCIDGroupsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCIDGroupsMultiStatus creates a UpdateCIDGroupsMultiStatus with default headers values
func NewUpdateCIDGroupsMultiStatus() *UpdateCIDGroupsMultiStatus {
	return &UpdateCIDGroupsMultiStatus{}
}

/*
UpdateCIDGroupsMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type UpdateCIDGroupsMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainCIDGroupsResponseV1
}

// IsSuccess returns true when this update c Id groups multi status response has a 2xx status code
func (o *UpdateCIDGroupsMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update c Id groups multi status response has a 3xx status code
func (o *UpdateCIDGroupsMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update c Id groups multi status response has a 4xx status code
func (o *UpdateCIDGroupsMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this update c Id groups multi status response has a 5xx status code
func (o *UpdateCIDGroupsMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this update c Id groups multi status response a status code equal to that given
func (o *UpdateCIDGroupsMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the update c Id groups multi status response
func (o *UpdateCIDGroupsMultiStatus) Code() int {
	return 207
}

func (o *UpdateCIDGroupsMultiStatus) Error() string {
	return fmt.Sprintf("[PATCH /mssp/entities/cid-groups/v1][%d] updateCIdGroupsMultiStatus  %+v", 207, o.Payload)
}

func (o *UpdateCIDGroupsMultiStatus) String() string {
	return fmt.Sprintf("[PATCH /mssp/entities/cid-groups/v1][%d] updateCIdGroupsMultiStatus  %+v", 207, o.Payload)
}

func (o *UpdateCIDGroupsMultiStatus) GetPayload() *models.DomainCIDGroupsResponseV1 {
	return o.Payload
}

func (o *UpdateCIDGroupsMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainCIDGroupsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCIDGroupsBadRequest creates a UpdateCIDGroupsBadRequest with default headers values
func NewUpdateCIDGroupsBadRequest() *UpdateCIDGroupsBadRequest {
	return &UpdateCIDGroupsBadRequest{}
}

/*
UpdateCIDGroupsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateCIDGroupsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this update c Id groups bad request response has a 2xx status code
func (o *UpdateCIDGroupsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update c Id groups bad request response has a 3xx status code
func (o *UpdateCIDGroupsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update c Id groups bad request response has a 4xx status code
func (o *UpdateCIDGroupsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update c Id groups bad request response has a 5xx status code
func (o *UpdateCIDGroupsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update c Id groups bad request response a status code equal to that given
func (o *UpdateCIDGroupsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update c Id groups bad request response
func (o *UpdateCIDGroupsBadRequest) Code() int {
	return 400
}

func (o *UpdateCIDGroupsBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /mssp/entities/cid-groups/v1][%d] updateCIdGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateCIDGroupsBadRequest) String() string {
	return fmt.Sprintf("[PATCH /mssp/entities/cid-groups/v1][%d] updateCIdGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateCIDGroupsBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *UpdateCIDGroupsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCIDGroupsForbidden creates a UpdateCIDGroupsForbidden with default headers values
func NewUpdateCIDGroupsForbidden() *UpdateCIDGroupsForbidden {
	return &UpdateCIDGroupsForbidden{}
}

/*
UpdateCIDGroupsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateCIDGroupsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this update c Id groups forbidden response has a 2xx status code
func (o *UpdateCIDGroupsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update c Id groups forbidden response has a 3xx status code
func (o *UpdateCIDGroupsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update c Id groups forbidden response has a 4xx status code
func (o *UpdateCIDGroupsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update c Id groups forbidden response has a 5xx status code
func (o *UpdateCIDGroupsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update c Id groups forbidden response a status code equal to that given
func (o *UpdateCIDGroupsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update c Id groups forbidden response
func (o *UpdateCIDGroupsForbidden) Code() int {
	return 403
}

func (o *UpdateCIDGroupsForbidden) Error() string {
	return fmt.Sprintf("[PATCH /mssp/entities/cid-groups/v1][%d] updateCIdGroupsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateCIDGroupsForbidden) String() string {
	return fmt.Sprintf("[PATCH /mssp/entities/cid-groups/v1][%d] updateCIdGroupsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateCIDGroupsForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *UpdateCIDGroupsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCIDGroupsTooManyRequests creates a UpdateCIDGroupsTooManyRequests with default headers values
func NewUpdateCIDGroupsTooManyRequests() *UpdateCIDGroupsTooManyRequests {
	return &UpdateCIDGroupsTooManyRequests{}
}

/*
UpdateCIDGroupsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateCIDGroupsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update c Id groups too many requests response has a 2xx status code
func (o *UpdateCIDGroupsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update c Id groups too many requests response has a 3xx status code
func (o *UpdateCIDGroupsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update c Id groups too many requests response has a 4xx status code
func (o *UpdateCIDGroupsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update c Id groups too many requests response has a 5xx status code
func (o *UpdateCIDGroupsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update c Id groups too many requests response a status code equal to that given
func (o *UpdateCIDGroupsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update c Id groups too many requests response
func (o *UpdateCIDGroupsTooManyRequests) Code() int {
	return 429
}

func (o *UpdateCIDGroupsTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /mssp/entities/cid-groups/v1][%d] updateCIdGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateCIDGroupsTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /mssp/entities/cid-groups/v1][%d] updateCIdGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateCIDGroupsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateCIDGroupsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
