// Code generated by go-swagger; DO NOT EDIT.

package mssp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateUserGroupsReader is a Reader for the UpdateUserGroups structure.
type UpdateUserGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateUserGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateUserGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewUpdateUserGroupsMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateUserGroupsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateUserGroupsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateUserGroupsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /mssp/entities/user-groups/v1] updateUserGroups", response, response.Code())
	}
}

// NewUpdateUserGroupsOK creates a UpdateUserGroupsOK with default headers values
func NewUpdateUserGroupsOK() *UpdateUserGroupsOK {
	return &UpdateUserGroupsOK{}
}

/*
UpdateUserGroupsOK describes a response with status code 200, with default header values.

OK
*/
type UpdateUserGroupsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainUserGroupsResponseV1
}

// IsSuccess returns true when this update user groups o k response has a 2xx status code
func (o *UpdateUserGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update user groups o k response has a 3xx status code
func (o *UpdateUserGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user groups o k response has a 4xx status code
func (o *UpdateUserGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update user groups o k response has a 5xx status code
func (o *UpdateUserGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update user groups o k response a status code equal to that given
func (o *UpdateUserGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update user groups o k response
func (o *UpdateUserGroupsOK) Code() int {
	return 200
}

func (o *UpdateUserGroupsOK) Error() string {
	return fmt.Sprintf("[PATCH /mssp/entities/user-groups/v1][%d] updateUserGroupsOK  %+v", 200, o.Payload)
}

func (o *UpdateUserGroupsOK) String() string {
	return fmt.Sprintf("[PATCH /mssp/entities/user-groups/v1][%d] updateUserGroupsOK  %+v", 200, o.Payload)
}

func (o *UpdateUserGroupsOK) GetPayload() *models.DomainUserGroupsResponseV1 {
	return o.Payload
}

func (o *UpdateUserGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainUserGroupsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserGroupsMultiStatus creates a UpdateUserGroupsMultiStatus with default headers values
func NewUpdateUserGroupsMultiStatus() *UpdateUserGroupsMultiStatus {
	return &UpdateUserGroupsMultiStatus{}
}

/*
UpdateUserGroupsMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type UpdateUserGroupsMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainUserGroupsResponseV1
}

// IsSuccess returns true when this update user groups multi status response has a 2xx status code
func (o *UpdateUserGroupsMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update user groups multi status response has a 3xx status code
func (o *UpdateUserGroupsMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user groups multi status response has a 4xx status code
func (o *UpdateUserGroupsMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this update user groups multi status response has a 5xx status code
func (o *UpdateUserGroupsMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this update user groups multi status response a status code equal to that given
func (o *UpdateUserGroupsMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the update user groups multi status response
func (o *UpdateUserGroupsMultiStatus) Code() int {
	return 207
}

func (o *UpdateUserGroupsMultiStatus) Error() string {
	return fmt.Sprintf("[PATCH /mssp/entities/user-groups/v1][%d] updateUserGroupsMultiStatus  %+v", 207, o.Payload)
}

func (o *UpdateUserGroupsMultiStatus) String() string {
	return fmt.Sprintf("[PATCH /mssp/entities/user-groups/v1][%d] updateUserGroupsMultiStatus  %+v", 207, o.Payload)
}

func (o *UpdateUserGroupsMultiStatus) GetPayload() *models.DomainUserGroupsResponseV1 {
	return o.Payload
}

func (o *UpdateUserGroupsMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainUserGroupsResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserGroupsBadRequest creates a UpdateUserGroupsBadRequest with default headers values
func NewUpdateUserGroupsBadRequest() *UpdateUserGroupsBadRequest {
	return &UpdateUserGroupsBadRequest{}
}

/*
UpdateUserGroupsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateUserGroupsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this update user groups bad request response has a 2xx status code
func (o *UpdateUserGroupsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user groups bad request response has a 3xx status code
func (o *UpdateUserGroupsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user groups bad request response has a 4xx status code
func (o *UpdateUserGroupsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update user groups bad request response has a 5xx status code
func (o *UpdateUserGroupsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update user groups bad request response a status code equal to that given
func (o *UpdateUserGroupsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update user groups bad request response
func (o *UpdateUserGroupsBadRequest) Code() int {
	return 400
}

func (o *UpdateUserGroupsBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /mssp/entities/user-groups/v1][%d] updateUserGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateUserGroupsBadRequest) String() string {
	return fmt.Sprintf("[PATCH /mssp/entities/user-groups/v1][%d] updateUserGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateUserGroupsBadRequest) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *UpdateUserGroupsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserGroupsForbidden creates a UpdateUserGroupsForbidden with default headers values
func NewUpdateUserGroupsForbidden() *UpdateUserGroupsForbidden {
	return &UpdateUserGroupsForbidden{}
}

/*
UpdateUserGroupsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateUserGroupsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this update user groups forbidden response has a 2xx status code
func (o *UpdateUserGroupsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user groups forbidden response has a 3xx status code
func (o *UpdateUserGroupsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user groups forbidden response has a 4xx status code
func (o *UpdateUserGroupsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update user groups forbidden response has a 5xx status code
func (o *UpdateUserGroupsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update user groups forbidden response a status code equal to that given
func (o *UpdateUserGroupsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update user groups forbidden response
func (o *UpdateUserGroupsForbidden) Code() int {
	return 403
}

func (o *UpdateUserGroupsForbidden) Error() string {
	return fmt.Sprintf("[PATCH /mssp/entities/user-groups/v1][%d] updateUserGroupsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateUserGroupsForbidden) String() string {
	return fmt.Sprintf("[PATCH /mssp/entities/user-groups/v1][%d] updateUserGroupsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateUserGroupsForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *UpdateUserGroupsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserGroupsTooManyRequests creates a UpdateUserGroupsTooManyRequests with default headers values
func NewUpdateUserGroupsTooManyRequests() *UpdateUserGroupsTooManyRequests {
	return &UpdateUserGroupsTooManyRequests{}
}

/*
UpdateUserGroupsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateUserGroupsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update user groups too many requests response has a 2xx status code
func (o *UpdateUserGroupsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user groups too many requests response has a 3xx status code
func (o *UpdateUserGroupsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user groups too many requests response has a 4xx status code
func (o *UpdateUserGroupsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update user groups too many requests response has a 5xx status code
func (o *UpdateUserGroupsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update user groups too many requests response a status code equal to that given
func (o *UpdateUserGroupsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update user groups too many requests response
func (o *UpdateUserGroupsTooManyRequests) Code() int {
	return 429
}

func (o *UpdateUserGroupsTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /mssp/entities/user-groups/v1][%d] updateUserGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateUserGroupsTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /mssp/entities/user-groups/v1][%d] updateUserGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateUserGroupsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateUserGroupsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
