// Code generated by go-swagger; DO NOT EDIT.

package oauth2

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new oauth2 API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for oauth2 API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	Oauth2AccessToken(params *Oauth2AccessTokenParams, opts ...ClientOption) (*Oauth2AccessTokenCreated, error)

	Oauth2RevokeToken(params *Oauth2RevokeTokenParams, opts ...ClientOption) (*Oauth2RevokeTokenOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
Oauth2AccessToken generates an o auth2 access token
*/
func (a *Client) Oauth2AccessToken(params *Oauth2AccessTokenParams, opts ...ClientOption) (*Oauth2AccessTokenCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOauth2AccessTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "oauth2AccessToken",
		Method:             "POST",
		PathPattern:        "/oauth2/token",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/x-www-form-urlencoded", "text/html"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &Oauth2AccessTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*Oauth2AccessTokenCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for oauth2AccessToken: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
Oauth2RevokeToken revokes a previously issued o auth2 access token before the end of its standard 30 minute lifespan
*/
func (a *Client) Oauth2RevokeToken(params *Oauth2RevokeTokenParams, opts ...ClientOption) (*Oauth2RevokeTokenOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOauth2RevokeTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "oauth2RevokeToken",
		Method:             "POST",
		PathPattern:        "/oauth2/revoke",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/x-www-form-urlencoded"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &Oauth2RevokeTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*Oauth2RevokeTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for oauth2RevokeToken: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
