// Code generated by go-swagger; DO NOT EDIT.

package ods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// AggregateScheduledScansReader is a Reader for the AggregateScheduledScans structure.
type AggregateScheduledScansReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AggregateScheduledScansReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAggregateScheduledScansOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewAggregateScheduledScansForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewAggregateScheduledScansNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewAggregateScheduledScansTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /ods/aggregates/scheduled-scans/v1] aggregate-scheduled-scans", response, response.Code())
	}
}

// NewAggregateScheduledScansOK creates a AggregateScheduledScansOK with default headers values
func NewAggregateScheduledScansOK() *AggregateScheduledScansOK {
	return &AggregateScheduledScansOK{}
}

/*
AggregateScheduledScansOK describes a response with status code 200, with default header values.

OK
*/
type AggregateScheduledScansOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaAggregatesResponse
}

// IsSuccess returns true when this aggregate scheduled scans o k response has a 2xx status code
func (o *AggregateScheduledScansOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aggregate scheduled scans o k response has a 3xx status code
func (o *AggregateScheduledScansOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate scheduled scans o k response has a 4xx status code
func (o *AggregateScheduledScansOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aggregate scheduled scans o k response has a 5xx status code
func (o *AggregateScheduledScansOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate scheduled scans o k response a status code equal to that given
func (o *AggregateScheduledScansOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aggregate scheduled scans o k response
func (o *AggregateScheduledScansOK) Code() int {
	return 200
}

func (o *AggregateScheduledScansOK) Error() string {
	return fmt.Sprintf("[POST /ods/aggregates/scheduled-scans/v1][%d] aggregateScheduledScansOK  %+v", 200, o.Payload)
}

func (o *AggregateScheduledScansOK) String() string {
	return fmt.Sprintf("[POST /ods/aggregates/scheduled-scans/v1][%d] aggregateScheduledScansOK  %+v", 200, o.Payload)
}

func (o *AggregateScheduledScansOK) GetPayload() *models.MsaAggregatesResponse {
	return o.Payload
}

func (o *AggregateScheduledScansOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaAggregatesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateScheduledScansForbidden creates a AggregateScheduledScansForbidden with default headers values
func NewAggregateScheduledScansForbidden() *AggregateScheduledScansForbidden {
	return &AggregateScheduledScansForbidden{}
}

/*
AggregateScheduledScansForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AggregateScheduledScansForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this aggregate scheduled scans forbidden response has a 2xx status code
func (o *AggregateScheduledScansForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregate scheduled scans forbidden response has a 3xx status code
func (o *AggregateScheduledScansForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate scheduled scans forbidden response has a 4xx status code
func (o *AggregateScheduledScansForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregate scheduled scans forbidden response has a 5xx status code
func (o *AggregateScheduledScansForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate scheduled scans forbidden response a status code equal to that given
func (o *AggregateScheduledScansForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the aggregate scheduled scans forbidden response
func (o *AggregateScheduledScansForbidden) Code() int {
	return 403
}

func (o *AggregateScheduledScansForbidden) Error() string {
	return fmt.Sprintf("[POST /ods/aggregates/scheduled-scans/v1][%d] aggregateScheduledScansForbidden  %+v", 403, o.Payload)
}

func (o *AggregateScheduledScansForbidden) String() string {
	return fmt.Sprintf("[POST /ods/aggregates/scheduled-scans/v1][%d] aggregateScheduledScansForbidden  %+v", 403, o.Payload)
}

func (o *AggregateScheduledScansForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AggregateScheduledScansForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateScheduledScansNotFound creates a AggregateScheduledScansNotFound with default headers values
func NewAggregateScheduledScansNotFound() *AggregateScheduledScansNotFound {
	return &AggregateScheduledScansNotFound{}
}

/*
AggregateScheduledScansNotFound describes a response with status code 404, with default header values.

Not Found
*/
type AggregateScheduledScansNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this aggregate scheduled scans not found response has a 2xx status code
func (o *AggregateScheduledScansNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregate scheduled scans not found response has a 3xx status code
func (o *AggregateScheduledScansNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate scheduled scans not found response has a 4xx status code
func (o *AggregateScheduledScansNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregate scheduled scans not found response has a 5xx status code
func (o *AggregateScheduledScansNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate scheduled scans not found response a status code equal to that given
func (o *AggregateScheduledScansNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the aggregate scheduled scans not found response
func (o *AggregateScheduledScansNotFound) Code() int {
	return 404
}

func (o *AggregateScheduledScansNotFound) Error() string {
	return fmt.Sprintf("[POST /ods/aggregates/scheduled-scans/v1][%d] aggregateScheduledScansNotFound  %+v", 404, o.Payload)
}

func (o *AggregateScheduledScansNotFound) String() string {
	return fmt.Sprintf("[POST /ods/aggregates/scheduled-scans/v1][%d] aggregateScheduledScansNotFound  %+v", 404, o.Payload)
}

func (o *AggregateScheduledScansNotFound) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *AggregateScheduledScansNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateScheduledScansTooManyRequests creates a AggregateScheduledScansTooManyRequests with default headers values
func NewAggregateScheduledScansTooManyRequests() *AggregateScheduledScansTooManyRequests {
	return &AggregateScheduledScansTooManyRequests{}
}

/*
AggregateScheduledScansTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type AggregateScheduledScansTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this aggregate scheduled scans too many requests response has a 2xx status code
func (o *AggregateScheduledScansTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregate scheduled scans too many requests response has a 3xx status code
func (o *AggregateScheduledScansTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate scheduled scans too many requests response has a 4xx status code
func (o *AggregateScheduledScansTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregate scheduled scans too many requests response has a 5xx status code
func (o *AggregateScheduledScansTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate scheduled scans too many requests response a status code equal to that given
func (o *AggregateScheduledScansTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the aggregate scheduled scans too many requests response
func (o *AggregateScheduledScansTooManyRequests) Code() int {
	return 429
}

func (o *AggregateScheduledScansTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /ods/aggregates/scheduled-scans/v1][%d] aggregateScheduledScansTooManyRequests  %+v", 429, o.Payload)
}

func (o *AggregateScheduledScansTooManyRequests) String() string {
	return fmt.Sprintf("[POST /ods/aggregates/scheduled-scans/v1][%d] aggregateScheduledScansTooManyRequests  %+v", 429, o.Payload)
}

func (o *AggregateScheduledScansTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AggregateScheduledScansTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
