// Code generated by go-swagger; DO NOT EDIT.

package ods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteScheduledScansParams creates a new DeleteScheduledScansParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteScheduledScansParams() *DeleteScheduledScansParams {
	return &DeleteScheduledScansParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteScheduledScansParamsWithTimeout creates a new DeleteScheduledScansParams object
// with the ability to set a timeout on a request.
func NewDeleteScheduledScansParamsWithTimeout(timeout time.Duration) *DeleteScheduledScansParams {
	return &DeleteScheduledScansParams{
		timeout: timeout,
	}
}

// NewDeleteScheduledScansParamsWithContext creates a new DeleteScheduledScansParams object
// with the ability to set a context for a request.
func NewDeleteScheduledScansParamsWithContext(ctx context.Context) *DeleteScheduledScansParams {
	return &DeleteScheduledScansParams{
		Context: ctx,
	}
}

// NewDeleteScheduledScansParamsWithHTTPClient creates a new DeleteScheduledScansParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteScheduledScansParamsWithHTTPClient(client *http.Client) *DeleteScheduledScansParams {
	return &DeleteScheduledScansParams{
		HTTPClient: client,
	}
}

/*
DeleteScheduledScansParams contains all the parameters to send to the API endpoint

	for the delete scheduled scans operation.

	Typically these are written to a http.Request.
*/
type DeleteScheduledScansParams struct {

	/* Filter.

	   A FQL compatible query string.
	*/
	Filter *string

	/* Ids.

	   The scan IDs to retrieve the scan entities
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete scheduled scans params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteScheduledScansParams) WithDefaults() *DeleteScheduledScansParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete scheduled scans params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteScheduledScansParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete scheduled scans params
func (o *DeleteScheduledScansParams) WithTimeout(timeout time.Duration) *DeleteScheduledScansParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete scheduled scans params
func (o *DeleteScheduledScansParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete scheduled scans params
func (o *DeleteScheduledScansParams) WithContext(ctx context.Context) *DeleteScheduledScansParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete scheduled scans params
func (o *DeleteScheduledScansParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete scheduled scans params
func (o *DeleteScheduledScansParams) WithHTTPClient(client *http.Client) *DeleteScheduledScansParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete scheduled scans params
func (o *DeleteScheduledScansParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the delete scheduled scans params
func (o *DeleteScheduledScansParams) WithFilter(filter *string) *DeleteScheduledScansParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the delete scheduled scans params
func (o *DeleteScheduledScansParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithIds adds the ids to the delete scheduled scans params
func (o *DeleteScheduledScansParams) WithIds(ids []string) *DeleteScheduledScansParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the delete scheduled scans params
func (o *DeleteScheduledScansParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteScheduledScansParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDeleteScheduledScans binds the parameter ids
func (o *DeleteScheduledScansParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
