// Code generated by go-swagger; DO NOT EDIT.

package ods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetMaliciousFilesByIdsReader is a Reader for the GetMaliciousFilesByIds structure.
type GetMaliciousFilesByIdsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetMaliciousFilesByIdsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetMaliciousFilesByIdsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetMaliciousFilesByIdsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetMaliciousFilesByIdsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetMaliciousFilesByIdsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /ods/entities/malicious-files/v1] get-malicious-files-by-ids", response, response.Code())
	}
}

// NewGetMaliciousFilesByIdsOK creates a GetMaliciousFilesByIdsOK with default headers values
func NewGetMaliciousFilesByIdsOK() *GetMaliciousFilesByIdsOK {
	return &GetMaliciousFilesByIdsOK{}
}

/*
GetMaliciousFilesByIdsOK describes a response with status code 200, with default header values.

OK
*/
type GetMaliciousFilesByIdsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.EntitiesODSScanMaliciousFileResponse
}

// IsSuccess returns true when this get malicious files by ids o k response has a 2xx status code
func (o *GetMaliciousFilesByIdsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get malicious files by ids o k response has a 3xx status code
func (o *GetMaliciousFilesByIdsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get malicious files by ids o k response has a 4xx status code
func (o *GetMaliciousFilesByIdsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get malicious files by ids o k response has a 5xx status code
func (o *GetMaliciousFilesByIdsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get malicious files by ids o k response a status code equal to that given
func (o *GetMaliciousFilesByIdsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get malicious files by ids o k response
func (o *GetMaliciousFilesByIdsOK) Code() int {
	return 200
}

func (o *GetMaliciousFilesByIdsOK) Error() string {
	return fmt.Sprintf("[GET /ods/entities/malicious-files/v1][%d] getMaliciousFilesByIdsOK  %+v", 200, o.Payload)
}

func (o *GetMaliciousFilesByIdsOK) String() string {
	return fmt.Sprintf("[GET /ods/entities/malicious-files/v1][%d] getMaliciousFilesByIdsOK  %+v", 200, o.Payload)
}

func (o *GetMaliciousFilesByIdsOK) GetPayload() *models.EntitiesODSScanMaliciousFileResponse {
	return o.Payload
}

func (o *GetMaliciousFilesByIdsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.EntitiesODSScanMaliciousFileResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMaliciousFilesByIdsForbidden creates a GetMaliciousFilesByIdsForbidden with default headers values
func NewGetMaliciousFilesByIdsForbidden() *GetMaliciousFilesByIdsForbidden {
	return &GetMaliciousFilesByIdsForbidden{}
}

/*
GetMaliciousFilesByIdsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetMaliciousFilesByIdsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get malicious files by ids forbidden response has a 2xx status code
func (o *GetMaliciousFilesByIdsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get malicious files by ids forbidden response has a 3xx status code
func (o *GetMaliciousFilesByIdsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get malicious files by ids forbidden response has a 4xx status code
func (o *GetMaliciousFilesByIdsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get malicious files by ids forbidden response has a 5xx status code
func (o *GetMaliciousFilesByIdsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get malicious files by ids forbidden response a status code equal to that given
func (o *GetMaliciousFilesByIdsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get malicious files by ids forbidden response
func (o *GetMaliciousFilesByIdsForbidden) Code() int {
	return 403
}

func (o *GetMaliciousFilesByIdsForbidden) Error() string {
	return fmt.Sprintf("[GET /ods/entities/malicious-files/v1][%d] getMaliciousFilesByIdsForbidden  %+v", 403, o.Payload)
}

func (o *GetMaliciousFilesByIdsForbidden) String() string {
	return fmt.Sprintf("[GET /ods/entities/malicious-files/v1][%d] getMaliciousFilesByIdsForbidden  %+v", 403, o.Payload)
}

func (o *GetMaliciousFilesByIdsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetMaliciousFilesByIdsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMaliciousFilesByIdsNotFound creates a GetMaliciousFilesByIdsNotFound with default headers values
func NewGetMaliciousFilesByIdsNotFound() *GetMaliciousFilesByIdsNotFound {
	return &GetMaliciousFilesByIdsNotFound{}
}

/*
GetMaliciousFilesByIdsNotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetMaliciousFilesByIdsNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get malicious files by ids not found response has a 2xx status code
func (o *GetMaliciousFilesByIdsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get malicious files by ids not found response has a 3xx status code
func (o *GetMaliciousFilesByIdsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get malicious files by ids not found response has a 4xx status code
func (o *GetMaliciousFilesByIdsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get malicious files by ids not found response has a 5xx status code
func (o *GetMaliciousFilesByIdsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get malicious files by ids not found response a status code equal to that given
func (o *GetMaliciousFilesByIdsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get malicious files by ids not found response
func (o *GetMaliciousFilesByIdsNotFound) Code() int {
	return 404
}

func (o *GetMaliciousFilesByIdsNotFound) Error() string {
	return fmt.Sprintf("[GET /ods/entities/malicious-files/v1][%d] getMaliciousFilesByIdsNotFound  %+v", 404, o.Payload)
}

func (o *GetMaliciousFilesByIdsNotFound) String() string {
	return fmt.Sprintf("[GET /ods/entities/malicious-files/v1][%d] getMaliciousFilesByIdsNotFound  %+v", 404, o.Payload)
}

func (o *GetMaliciousFilesByIdsNotFound) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetMaliciousFilesByIdsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMaliciousFilesByIdsTooManyRequests creates a GetMaliciousFilesByIdsTooManyRequests with default headers values
func NewGetMaliciousFilesByIdsTooManyRequests() *GetMaliciousFilesByIdsTooManyRequests {
	return &GetMaliciousFilesByIdsTooManyRequests{}
}

/*
GetMaliciousFilesByIdsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetMaliciousFilesByIdsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get malicious files by ids too many requests response has a 2xx status code
func (o *GetMaliciousFilesByIdsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get malicious files by ids too many requests response has a 3xx status code
func (o *GetMaliciousFilesByIdsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get malicious files by ids too many requests response has a 4xx status code
func (o *GetMaliciousFilesByIdsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get malicious files by ids too many requests response has a 5xx status code
func (o *GetMaliciousFilesByIdsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get malicious files by ids too many requests response a status code equal to that given
func (o *GetMaliciousFilesByIdsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get malicious files by ids too many requests response
func (o *GetMaliciousFilesByIdsTooManyRequests) Code() int {
	return 429
}

func (o *GetMaliciousFilesByIdsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /ods/entities/malicious-files/v1][%d] getMaliciousFilesByIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetMaliciousFilesByIdsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /ods/entities/malicious-files/v1][%d] getMaliciousFilesByIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetMaliciousFilesByIdsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetMaliciousFilesByIdsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
