// Code generated by go-swagger; DO NOT EDIT.

package ods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetScanHostMetadataByIdsReader is a Reader for the GetScanHostMetadataByIds structure.
type GetScanHostMetadataByIdsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetScanHostMetadataByIdsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetScanHostMetadataByIdsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetScanHostMetadataByIdsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetScanHostMetadataByIdsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetScanHostMetadataByIdsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /ods/entities/scan-hosts/v1] get-scan-host-metadata-by-ids", response, response.Code())
	}
}

// NewGetScanHostMetadataByIdsOK creates a GetScanHostMetadataByIdsOK with default headers values
func NewGetScanHostMetadataByIdsOK() *GetScanHostMetadataByIdsOK {
	return &GetScanHostMetadataByIdsOK{}
}

/*
GetScanHostMetadataByIdsOK describes a response with status code 200, with default header values.

OK
*/
type GetScanHostMetadataByIdsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.EntitiesODSScanHostResponse
}

// IsSuccess returns true when this get scan host metadata by ids o k response has a 2xx status code
func (o *GetScanHostMetadataByIdsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get scan host metadata by ids o k response has a 3xx status code
func (o *GetScanHostMetadataByIdsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get scan host metadata by ids o k response has a 4xx status code
func (o *GetScanHostMetadataByIdsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get scan host metadata by ids o k response has a 5xx status code
func (o *GetScanHostMetadataByIdsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get scan host metadata by ids o k response a status code equal to that given
func (o *GetScanHostMetadataByIdsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get scan host metadata by ids o k response
func (o *GetScanHostMetadataByIdsOK) Code() int {
	return 200
}

func (o *GetScanHostMetadataByIdsOK) Error() string {
	return fmt.Sprintf("[GET /ods/entities/scan-hosts/v1][%d] getScanHostMetadataByIdsOK  %+v", 200, o.Payload)
}

func (o *GetScanHostMetadataByIdsOK) String() string {
	return fmt.Sprintf("[GET /ods/entities/scan-hosts/v1][%d] getScanHostMetadataByIdsOK  %+v", 200, o.Payload)
}

func (o *GetScanHostMetadataByIdsOK) GetPayload() *models.EntitiesODSScanHostResponse {
	return o.Payload
}

func (o *GetScanHostMetadataByIdsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.EntitiesODSScanHostResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetScanHostMetadataByIdsForbidden creates a GetScanHostMetadataByIdsForbidden with default headers values
func NewGetScanHostMetadataByIdsForbidden() *GetScanHostMetadataByIdsForbidden {
	return &GetScanHostMetadataByIdsForbidden{}
}

/*
GetScanHostMetadataByIdsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetScanHostMetadataByIdsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get scan host metadata by ids forbidden response has a 2xx status code
func (o *GetScanHostMetadataByIdsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get scan host metadata by ids forbidden response has a 3xx status code
func (o *GetScanHostMetadataByIdsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get scan host metadata by ids forbidden response has a 4xx status code
func (o *GetScanHostMetadataByIdsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get scan host metadata by ids forbidden response has a 5xx status code
func (o *GetScanHostMetadataByIdsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get scan host metadata by ids forbidden response a status code equal to that given
func (o *GetScanHostMetadataByIdsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get scan host metadata by ids forbidden response
func (o *GetScanHostMetadataByIdsForbidden) Code() int {
	return 403
}

func (o *GetScanHostMetadataByIdsForbidden) Error() string {
	return fmt.Sprintf("[GET /ods/entities/scan-hosts/v1][%d] getScanHostMetadataByIdsForbidden  %+v", 403, o.Payload)
}

func (o *GetScanHostMetadataByIdsForbidden) String() string {
	return fmt.Sprintf("[GET /ods/entities/scan-hosts/v1][%d] getScanHostMetadataByIdsForbidden  %+v", 403, o.Payload)
}

func (o *GetScanHostMetadataByIdsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetScanHostMetadataByIdsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetScanHostMetadataByIdsNotFound creates a GetScanHostMetadataByIdsNotFound with default headers values
func NewGetScanHostMetadataByIdsNotFound() *GetScanHostMetadataByIdsNotFound {
	return &GetScanHostMetadataByIdsNotFound{}
}

/*
GetScanHostMetadataByIdsNotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetScanHostMetadataByIdsNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get scan host metadata by ids not found response has a 2xx status code
func (o *GetScanHostMetadataByIdsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get scan host metadata by ids not found response has a 3xx status code
func (o *GetScanHostMetadataByIdsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get scan host metadata by ids not found response has a 4xx status code
func (o *GetScanHostMetadataByIdsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get scan host metadata by ids not found response has a 5xx status code
func (o *GetScanHostMetadataByIdsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get scan host metadata by ids not found response a status code equal to that given
func (o *GetScanHostMetadataByIdsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get scan host metadata by ids not found response
func (o *GetScanHostMetadataByIdsNotFound) Code() int {
	return 404
}

func (o *GetScanHostMetadataByIdsNotFound) Error() string {
	return fmt.Sprintf("[GET /ods/entities/scan-hosts/v1][%d] getScanHostMetadataByIdsNotFound  %+v", 404, o.Payload)
}

func (o *GetScanHostMetadataByIdsNotFound) String() string {
	return fmt.Sprintf("[GET /ods/entities/scan-hosts/v1][%d] getScanHostMetadataByIdsNotFound  %+v", 404, o.Payload)
}

func (o *GetScanHostMetadataByIdsNotFound) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetScanHostMetadataByIdsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetScanHostMetadataByIdsTooManyRequests creates a GetScanHostMetadataByIdsTooManyRequests with default headers values
func NewGetScanHostMetadataByIdsTooManyRequests() *GetScanHostMetadataByIdsTooManyRequests {
	return &GetScanHostMetadataByIdsTooManyRequests{}
}

/*
GetScanHostMetadataByIdsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetScanHostMetadataByIdsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get scan host metadata by ids too many requests response has a 2xx status code
func (o *GetScanHostMetadataByIdsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get scan host metadata by ids too many requests response has a 3xx status code
func (o *GetScanHostMetadataByIdsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get scan host metadata by ids too many requests response has a 4xx status code
func (o *GetScanHostMetadataByIdsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get scan host metadata by ids too many requests response has a 5xx status code
func (o *GetScanHostMetadataByIdsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get scan host metadata by ids too many requests response a status code equal to that given
func (o *GetScanHostMetadataByIdsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get scan host metadata by ids too many requests response
func (o *GetScanHostMetadataByIdsTooManyRequests) Code() int {
	return 429
}

func (o *GetScanHostMetadataByIdsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /ods/entities/scan-hosts/v1][%d] getScanHostMetadataByIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetScanHostMetadataByIdsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /ods/entities/scan-hosts/v1][%d] getScanHostMetadataByIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetScanHostMetadataByIdsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetScanHostMetadataByIdsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
