// Code generated by go-swagger; DO NOT EDIT.

package ods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetScansByScanIdsParams creates a new GetScansByScanIdsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetScansByScanIdsParams() *GetScansByScanIdsParams {
	return &GetScansByScanIdsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetScansByScanIdsParamsWithTimeout creates a new GetScansByScanIdsParams object
// with the ability to set a timeout on a request.
func NewGetScansByScanIdsParamsWithTimeout(timeout time.Duration) *GetScansByScanIdsParams {
	return &GetScansByScanIdsParams{
		timeout: timeout,
	}
}

// NewGetScansByScanIdsParamsWithContext creates a new GetScansByScanIdsParams object
// with the ability to set a context for a request.
func NewGetScansByScanIdsParamsWithContext(ctx context.Context) *GetScansByScanIdsParams {
	return &GetScansByScanIdsParams{
		Context: ctx,
	}
}

// NewGetScansByScanIdsParamsWithHTTPClient creates a new GetScansByScanIdsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetScansByScanIdsParamsWithHTTPClient(client *http.Client) *GetScansByScanIdsParams {
	return &GetScansByScanIdsParams{
		HTTPClient: client,
	}
}

/*
GetScansByScanIdsParams contains all the parameters to send to the API endpoint

	for the get scans by scan ids operation.

	Typically these are written to a http.Request.
*/
type GetScansByScanIdsParams struct {

	/* Ids.

	   The scan IDs to retrieve the scan entities
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get scans by scan ids params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetScansByScanIdsParams) WithDefaults() *GetScansByScanIdsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get scans by scan ids params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetScansByScanIdsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get scans by scan ids params
func (o *GetScansByScanIdsParams) WithTimeout(timeout time.Duration) *GetScansByScanIdsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get scans by scan ids params
func (o *GetScansByScanIdsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get scans by scan ids params
func (o *GetScansByScanIdsParams) WithContext(ctx context.Context) *GetScansByScanIdsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get scans by scan ids params
func (o *GetScansByScanIdsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get scans by scan ids params
func (o *GetScansByScanIdsParams) WithHTTPClient(client *http.Client) *GetScansByScanIdsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get scans by scan ids params
func (o *GetScansByScanIdsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get scans by scan ids params
func (o *GetScansByScanIdsParams) WithIds(ids []string) *GetScansByScanIdsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get scans by scan ids params
func (o *GetScansByScanIdsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetScansByScanIdsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetScansByScanIds binds the parameter ids
func (o *GetScansByScanIdsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
