// Code generated by go-swagger; DO NOT EDIT.

package ods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryScansReader is a Reader for the QueryScans structure.
type QueryScansReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryScansReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryScansOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewQueryScansForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewQueryScansNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryScansTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /ods/queries/scans/v1] query-scans", response, response.Code())
	}
}

// NewQueryScansOK creates a QueryScansOK with default headers values
func NewQueryScansOK() *QueryScansOK {
	return &QueryScansOK{}
}

/*
QueryScansOK describes a response with status code 200, with default header values.

OK
*/
type QueryScansOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecQueryResponse
}

// IsSuccess returns true when this query scans o k response has a 2xx status code
func (o *QueryScansOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query scans o k response has a 3xx status code
func (o *QueryScansOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query scans o k response has a 4xx status code
func (o *QueryScansOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query scans o k response has a 5xx status code
func (o *QueryScansOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query scans o k response a status code equal to that given
func (o *QueryScansOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query scans o k response
func (o *QueryScansOK) Code() int {
	return 200
}

func (o *QueryScansOK) Error() string {
	return fmt.Sprintf("[GET /ods/queries/scans/v1][%d] queryScansOK  %+v", 200, o.Payload)
}

func (o *QueryScansOK) String() string {
	return fmt.Sprintf("[GET /ods/queries/scans/v1][%d] queryScansOK  %+v", 200, o.Payload)
}

func (o *QueryScansOK) GetPayload() *models.MsaspecQueryResponse {
	return o.Payload
}

func (o *QueryScansOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryScansForbidden creates a QueryScansForbidden with default headers values
func NewQueryScansForbidden() *QueryScansForbidden {
	return &QueryScansForbidden{}
}

/*
QueryScansForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryScansForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query scans forbidden response has a 2xx status code
func (o *QueryScansForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query scans forbidden response has a 3xx status code
func (o *QueryScansForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query scans forbidden response has a 4xx status code
func (o *QueryScansForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query scans forbidden response has a 5xx status code
func (o *QueryScansForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query scans forbidden response a status code equal to that given
func (o *QueryScansForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query scans forbidden response
func (o *QueryScansForbidden) Code() int {
	return 403
}

func (o *QueryScansForbidden) Error() string {
	return fmt.Sprintf("[GET /ods/queries/scans/v1][%d] queryScansForbidden  %+v", 403, o.Payload)
}

func (o *QueryScansForbidden) String() string {
	return fmt.Sprintf("[GET /ods/queries/scans/v1][%d] queryScansForbidden  %+v", 403, o.Payload)
}

func (o *QueryScansForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryScansForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryScansNotFound creates a QueryScansNotFound with default headers values
func NewQueryScansNotFound() *QueryScansNotFound {
	return &QueryScansNotFound{}
}

/*
QueryScansNotFound describes a response with status code 404, with default header values.

Not Found
*/
type QueryScansNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this query scans not found response has a 2xx status code
func (o *QueryScansNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query scans not found response has a 3xx status code
func (o *QueryScansNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query scans not found response has a 4xx status code
func (o *QueryScansNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this query scans not found response has a 5xx status code
func (o *QueryScansNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this query scans not found response a status code equal to that given
func (o *QueryScansNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the query scans not found response
func (o *QueryScansNotFound) Code() int {
	return 404
}

func (o *QueryScansNotFound) Error() string {
	return fmt.Sprintf("[GET /ods/queries/scans/v1][%d] queryScansNotFound  %+v", 404, o.Payload)
}

func (o *QueryScansNotFound) String() string {
	return fmt.Sprintf("[GET /ods/queries/scans/v1][%d] queryScansNotFound  %+v", 404, o.Payload)
}

func (o *QueryScansNotFound) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *QueryScansNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryScansTooManyRequests creates a QueryScansTooManyRequests with default headers values
func NewQueryScansTooManyRequests() *QueryScansTooManyRequests {
	return &QueryScansTooManyRequests{}
}

/*
QueryScansTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryScansTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query scans too many requests response has a 2xx status code
func (o *QueryScansTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query scans too many requests response has a 3xx status code
func (o *QueryScansTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query scans too many requests response has a 4xx status code
func (o *QueryScansTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query scans too many requests response has a 5xx status code
func (o *QueryScansTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query scans too many requests response a status code equal to that given
func (o *QueryScansTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query scans too many requests response
func (o *QueryScansTooManyRequests) Code() int {
	return 429
}

func (o *QueryScansTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /ods/queries/scans/v1][%d] queryScansTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryScansTooManyRequests) String() string {
	return fmt.Sprintf("[GET /ods/queries/scans/v1][%d] queryScansTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryScansTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryScansTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
