// Code generated by go-swagger; DO NOT EDIT.

package ods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewScheduleScanParams creates a new ScheduleScanParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewScheduleScanParams() *ScheduleScanParams {
	return &ScheduleScanParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewScheduleScanParamsWithTimeout creates a new ScheduleScanParams object
// with the ability to set a timeout on a request.
func NewScheduleScanParamsWithTimeout(timeout time.Duration) *ScheduleScanParams {
	return &ScheduleScanParams{
		timeout: timeout,
	}
}

// NewScheduleScanParamsWithContext creates a new ScheduleScanParams object
// with the ability to set a context for a request.
func NewScheduleScanParamsWithContext(ctx context.Context) *ScheduleScanParams {
	return &ScheduleScanParams{
		Context: ctx,
	}
}

// NewScheduleScanParamsWithHTTPClient creates a new ScheduleScanParams object
// with the ability to set a custom HTTPClient for a request.
func NewScheduleScanParamsWithHTTPClient(client *http.Client) *ScheduleScanParams {
	return &ScheduleScanParams{
		HTTPClient: client,
	}
}

/*
ScheduleScanParams contains all the parameters to send to the API endpoint

	for the schedule scan operation.

	Typically these are written to a http.Request.
*/
type ScheduleScanParams struct {

	// Body.
	Body *models.EntitiesODSScheduleScanRequest

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the schedule scan params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ScheduleScanParams) WithDefaults() *ScheduleScanParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the schedule scan params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ScheduleScanParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the schedule scan params
func (o *ScheduleScanParams) WithTimeout(timeout time.Duration) *ScheduleScanParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the schedule scan params
func (o *ScheduleScanParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the schedule scan params
func (o *ScheduleScanParams) WithContext(ctx context.Context) *ScheduleScanParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the schedule scan params
func (o *ScheduleScanParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the schedule scan params
func (o *ScheduleScanParams) WithHTTPClient(client *http.Client) *ScheduleScanParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the schedule scan params
func (o *ScheduleScanParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the schedule scan params
func (o *ScheduleScanParams) WithBody(body *models.EntitiesODSScheduleScanRequest) *ScheduleScanParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the schedule scan params
func (o *ScheduleScanParams) SetBody(body *models.EntitiesODSScheduleScanRequest) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *ScheduleScanParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
