// Code generated by go-swagger; DO NOT EDIT.

package overwatch_dashboard

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// AggregatesDetectionsGlobalCountsReader is a Reader for the AggregatesDetectionsGlobalCounts structure.
type AggregatesDetectionsGlobalCountsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AggregatesDetectionsGlobalCountsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAggregatesDetectionsGlobalCountsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewAggregatesDetectionsGlobalCountsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewAggregatesDetectionsGlobalCountsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /overwatch-dashboards/aggregates/detections-global-counts/v1] AggregatesDetectionsGlobalCounts", response, response.Code())
	}
}

// NewAggregatesDetectionsGlobalCountsOK creates a AggregatesDetectionsGlobalCountsOK with default headers values
func NewAggregatesDetectionsGlobalCountsOK() *AggregatesDetectionsGlobalCountsOK {
	return &AggregatesDetectionsGlobalCountsOK{}
}

/*
AggregatesDetectionsGlobalCountsOK describes a response with status code 200, with default header values.

OK
*/
type AggregatesDetectionsGlobalCountsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaFacetsResponse
}

// IsSuccess returns true when this aggregates detections global counts o k response has a 2xx status code
func (o *AggregatesDetectionsGlobalCountsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aggregates detections global counts o k response has a 3xx status code
func (o *AggregatesDetectionsGlobalCountsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregates detections global counts o k response has a 4xx status code
func (o *AggregatesDetectionsGlobalCountsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aggregates detections global counts o k response has a 5xx status code
func (o *AggregatesDetectionsGlobalCountsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregates detections global counts o k response a status code equal to that given
func (o *AggregatesDetectionsGlobalCountsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aggregates detections global counts o k response
func (o *AggregatesDetectionsGlobalCountsOK) Code() int {
	return 200
}

func (o *AggregatesDetectionsGlobalCountsOK) Error() string {
	return fmt.Sprintf("[GET /overwatch-dashboards/aggregates/detections-global-counts/v1][%d] aggregatesDetectionsGlobalCountsOK  %+v", 200, o.Payload)
}

func (o *AggregatesDetectionsGlobalCountsOK) String() string {
	return fmt.Sprintf("[GET /overwatch-dashboards/aggregates/detections-global-counts/v1][%d] aggregatesDetectionsGlobalCountsOK  %+v", 200, o.Payload)
}

func (o *AggregatesDetectionsGlobalCountsOK) GetPayload() *models.MsaFacetsResponse {
	return o.Payload
}

func (o *AggregatesDetectionsGlobalCountsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaFacetsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregatesDetectionsGlobalCountsForbidden creates a AggregatesDetectionsGlobalCountsForbidden with default headers values
func NewAggregatesDetectionsGlobalCountsForbidden() *AggregatesDetectionsGlobalCountsForbidden {
	return &AggregatesDetectionsGlobalCountsForbidden{}
}

/*
AggregatesDetectionsGlobalCountsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AggregatesDetectionsGlobalCountsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this aggregates detections global counts forbidden response has a 2xx status code
func (o *AggregatesDetectionsGlobalCountsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregates detections global counts forbidden response has a 3xx status code
func (o *AggregatesDetectionsGlobalCountsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregates detections global counts forbidden response has a 4xx status code
func (o *AggregatesDetectionsGlobalCountsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregates detections global counts forbidden response has a 5xx status code
func (o *AggregatesDetectionsGlobalCountsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregates detections global counts forbidden response a status code equal to that given
func (o *AggregatesDetectionsGlobalCountsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the aggregates detections global counts forbidden response
func (o *AggregatesDetectionsGlobalCountsForbidden) Code() int {
	return 403
}

func (o *AggregatesDetectionsGlobalCountsForbidden) Error() string {
	return fmt.Sprintf("[GET /overwatch-dashboards/aggregates/detections-global-counts/v1][%d] aggregatesDetectionsGlobalCountsForbidden  %+v", 403, o.Payload)
}

func (o *AggregatesDetectionsGlobalCountsForbidden) String() string {
	return fmt.Sprintf("[GET /overwatch-dashboards/aggregates/detections-global-counts/v1][%d] aggregatesDetectionsGlobalCountsForbidden  %+v", 403, o.Payload)
}

func (o *AggregatesDetectionsGlobalCountsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AggregatesDetectionsGlobalCountsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregatesDetectionsGlobalCountsTooManyRequests creates a AggregatesDetectionsGlobalCountsTooManyRequests with default headers values
func NewAggregatesDetectionsGlobalCountsTooManyRequests() *AggregatesDetectionsGlobalCountsTooManyRequests {
	return &AggregatesDetectionsGlobalCountsTooManyRequests{}
}

/*
AggregatesDetectionsGlobalCountsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type AggregatesDetectionsGlobalCountsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this aggregates detections global counts too many requests response has a 2xx status code
func (o *AggregatesDetectionsGlobalCountsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregates detections global counts too many requests response has a 3xx status code
func (o *AggregatesDetectionsGlobalCountsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregates detections global counts too many requests response has a 4xx status code
func (o *AggregatesDetectionsGlobalCountsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregates detections global counts too many requests response has a 5xx status code
func (o *AggregatesDetectionsGlobalCountsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregates detections global counts too many requests response a status code equal to that given
func (o *AggregatesDetectionsGlobalCountsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the aggregates detections global counts too many requests response
func (o *AggregatesDetectionsGlobalCountsTooManyRequests) Code() int {
	return 429
}

func (o *AggregatesDetectionsGlobalCountsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /overwatch-dashboards/aggregates/detections-global-counts/v1][%d] aggregatesDetectionsGlobalCountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *AggregatesDetectionsGlobalCountsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /overwatch-dashboards/aggregates/detections-global-counts/v1][%d] aggregatesDetectionsGlobalCountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *AggregatesDetectionsGlobalCountsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AggregatesDetectionsGlobalCountsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
