// Code generated by go-swagger; DO NOT EDIT.

package overwatch_dashboard

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// AggregatesIncidentsGlobalCountsReader is a Reader for the AggregatesIncidentsGlobalCounts structure.
type AggregatesIncidentsGlobalCountsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AggregatesIncidentsGlobalCountsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAggregatesIncidentsGlobalCountsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewAggregatesIncidentsGlobalCountsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewAggregatesIncidentsGlobalCountsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /overwatch-dashboards/aggregates/incidents-global-counts/v1] AggregatesIncidentsGlobalCounts", response, response.Code())
	}
}

// NewAggregatesIncidentsGlobalCountsOK creates a AggregatesIncidentsGlobalCountsOK with default headers values
func NewAggregatesIncidentsGlobalCountsOK() *AggregatesIncidentsGlobalCountsOK {
	return &AggregatesIncidentsGlobalCountsOK{}
}

/*
AggregatesIncidentsGlobalCountsOK describes a response with status code 200, with default header values.

OK
*/
type AggregatesIncidentsGlobalCountsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaFacetsResponse
}

// IsSuccess returns true when this aggregates incidents global counts o k response has a 2xx status code
func (o *AggregatesIncidentsGlobalCountsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aggregates incidents global counts o k response has a 3xx status code
func (o *AggregatesIncidentsGlobalCountsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregates incidents global counts o k response has a 4xx status code
func (o *AggregatesIncidentsGlobalCountsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aggregates incidents global counts o k response has a 5xx status code
func (o *AggregatesIncidentsGlobalCountsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregates incidents global counts o k response a status code equal to that given
func (o *AggregatesIncidentsGlobalCountsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aggregates incidents global counts o k response
func (o *AggregatesIncidentsGlobalCountsOK) Code() int {
	return 200
}

func (o *AggregatesIncidentsGlobalCountsOK) Error() string {
	return fmt.Sprintf("[GET /overwatch-dashboards/aggregates/incidents-global-counts/v1][%d] aggregatesIncidentsGlobalCountsOK  %+v", 200, o.Payload)
}

func (o *AggregatesIncidentsGlobalCountsOK) String() string {
	return fmt.Sprintf("[GET /overwatch-dashboards/aggregates/incidents-global-counts/v1][%d] aggregatesIncidentsGlobalCountsOK  %+v", 200, o.Payload)
}

func (o *AggregatesIncidentsGlobalCountsOK) GetPayload() *models.MsaFacetsResponse {
	return o.Payload
}

func (o *AggregatesIncidentsGlobalCountsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaFacetsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregatesIncidentsGlobalCountsForbidden creates a AggregatesIncidentsGlobalCountsForbidden with default headers values
func NewAggregatesIncidentsGlobalCountsForbidden() *AggregatesIncidentsGlobalCountsForbidden {
	return &AggregatesIncidentsGlobalCountsForbidden{}
}

/*
AggregatesIncidentsGlobalCountsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AggregatesIncidentsGlobalCountsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this aggregates incidents global counts forbidden response has a 2xx status code
func (o *AggregatesIncidentsGlobalCountsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregates incidents global counts forbidden response has a 3xx status code
func (o *AggregatesIncidentsGlobalCountsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregates incidents global counts forbidden response has a 4xx status code
func (o *AggregatesIncidentsGlobalCountsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregates incidents global counts forbidden response has a 5xx status code
func (o *AggregatesIncidentsGlobalCountsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregates incidents global counts forbidden response a status code equal to that given
func (o *AggregatesIncidentsGlobalCountsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the aggregates incidents global counts forbidden response
func (o *AggregatesIncidentsGlobalCountsForbidden) Code() int {
	return 403
}

func (o *AggregatesIncidentsGlobalCountsForbidden) Error() string {
	return fmt.Sprintf("[GET /overwatch-dashboards/aggregates/incidents-global-counts/v1][%d] aggregatesIncidentsGlobalCountsForbidden  %+v", 403, o.Payload)
}

func (o *AggregatesIncidentsGlobalCountsForbidden) String() string {
	return fmt.Sprintf("[GET /overwatch-dashboards/aggregates/incidents-global-counts/v1][%d] aggregatesIncidentsGlobalCountsForbidden  %+v", 403, o.Payload)
}

func (o *AggregatesIncidentsGlobalCountsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AggregatesIncidentsGlobalCountsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregatesIncidentsGlobalCountsTooManyRequests creates a AggregatesIncidentsGlobalCountsTooManyRequests with default headers values
func NewAggregatesIncidentsGlobalCountsTooManyRequests() *AggregatesIncidentsGlobalCountsTooManyRequests {
	return &AggregatesIncidentsGlobalCountsTooManyRequests{}
}

/*
AggregatesIncidentsGlobalCountsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type AggregatesIncidentsGlobalCountsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this aggregates incidents global counts too many requests response has a 2xx status code
func (o *AggregatesIncidentsGlobalCountsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregates incidents global counts too many requests response has a 3xx status code
func (o *AggregatesIncidentsGlobalCountsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregates incidents global counts too many requests response has a 4xx status code
func (o *AggregatesIncidentsGlobalCountsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregates incidents global counts too many requests response has a 5xx status code
func (o *AggregatesIncidentsGlobalCountsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregates incidents global counts too many requests response a status code equal to that given
func (o *AggregatesIncidentsGlobalCountsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the aggregates incidents global counts too many requests response
func (o *AggregatesIncidentsGlobalCountsTooManyRequests) Code() int {
	return 429
}

func (o *AggregatesIncidentsGlobalCountsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /overwatch-dashboards/aggregates/incidents-global-counts/v1][%d] aggregatesIncidentsGlobalCountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *AggregatesIncidentsGlobalCountsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /overwatch-dashboards/aggregates/incidents-global-counts/v1][%d] aggregatesIncidentsGlobalCountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *AggregatesIncidentsGlobalCountsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AggregatesIncidentsGlobalCountsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
