// Code generated by go-swagger; DO NOT EDIT.

package overwatch_dashboard

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new overwatch dashboard API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for overwatch dashboard API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AggregatesDetectionsGlobalCounts(params *AggregatesDetectionsGlobalCountsParams, opts ...ClientOption) (*AggregatesDetectionsGlobalCountsOK, error)

	AggregatesEvents(params *AggregatesEventsParams, opts ...ClientOption) (*AggregatesEventsOK, error)

	AggregatesEventsCollections(params *AggregatesEventsCollectionsParams, opts ...ClientOption) (*AggregatesEventsCollectionsOK, error)

	AggregatesIncidentsGlobalCounts(params *AggregatesIncidentsGlobalCountsParams, opts ...ClientOption) (*AggregatesIncidentsGlobalCountsOK, error)

	AggregatesOWEventsGlobalCounts(params *AggregatesOWEventsGlobalCountsParams, opts ...ClientOption) (*AggregatesOWEventsGlobalCountsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AggregatesDetectionsGlobalCounts gets the total number of detections pushed across all customers
*/
func (a *Client) AggregatesDetectionsGlobalCounts(params *AggregatesDetectionsGlobalCountsParams, opts ...ClientOption) (*AggregatesDetectionsGlobalCountsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregatesDetectionsGlobalCountsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregatesDetectionsGlobalCounts",
		Method:             "GET",
		PathPattern:        "/overwatch-dashboards/aggregates/detections-global-counts/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregatesDetectionsGlobalCountsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregatesDetectionsGlobalCountsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregatesDetectionsGlobalCounts: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregatesEvents gets aggregate over watch detection event info by providing an aggregate query
*/
func (a *Client) AggregatesEvents(params *AggregatesEventsParams, opts ...ClientOption) (*AggregatesEventsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregatesEventsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregatesEvents",
		Method:             "POST",
		PathPattern:        "/overwatch-dashboards/aggregates/events/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregatesEventsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregatesEventsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregatesEvents: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregatesEventsCollections gets over watch detection event collection info by providing an aggregate query
*/
func (a *Client) AggregatesEventsCollections(params *AggregatesEventsCollectionsParams, opts ...ClientOption) (*AggregatesEventsCollectionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregatesEventsCollectionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregatesEventsCollections",
		Method:             "POST",
		PathPattern:        "/overwatch-dashboards/aggregates/events-collections/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregatesEventsCollectionsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregatesEventsCollectionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregatesEventsCollections: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregatesIncidentsGlobalCounts gets the total number of incidents pushed across all customers
*/
func (a *Client) AggregatesIncidentsGlobalCounts(params *AggregatesIncidentsGlobalCountsParams, opts ...ClientOption) (*AggregatesIncidentsGlobalCountsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregatesIncidentsGlobalCountsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregatesIncidentsGlobalCounts",
		Method:             "GET",
		PathPattern:        "/overwatch-dashboards/aggregates/incidents-global-counts/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregatesIncidentsGlobalCountsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregatesIncidentsGlobalCountsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregatesIncidentsGlobalCounts: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregatesOWEventsGlobalCounts gets the total number of over watch events across all customers
*/
func (a *Client) AggregatesOWEventsGlobalCounts(params *AggregatesOWEventsGlobalCountsParams, opts ...ClientOption) (*AggregatesOWEventsGlobalCountsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregatesOWEventsGlobalCountsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregatesOWEventsGlobalCounts",
		Method:             "GET",
		PathPattern:        "/overwatch-dashboards/aggregates/ow-events-global-counts/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregatesOWEventsGlobalCountsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregatesOWEventsGlobalCountsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregatesOWEventsGlobalCounts: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
