// Code generated by go-swagger; DO NOT EDIT.

package prevention_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreatePreventionPoliciesReader is a Reader for the CreatePreventionPolicies structure.
type CreatePreventionPoliciesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreatePreventionPoliciesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreatePreventionPoliciesCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreatePreventionPoliciesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreatePreventionPoliciesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewCreatePreventionPoliciesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreatePreventionPoliciesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreatePreventionPoliciesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /policy/entities/prevention/v1] createPreventionPolicies", response, response.Code())
	}
}

// NewCreatePreventionPoliciesCreated creates a CreatePreventionPoliciesCreated with default headers values
func NewCreatePreventionPoliciesCreated() *CreatePreventionPoliciesCreated {
	return &CreatePreventionPoliciesCreated{}
}

/*
CreatePreventionPoliciesCreated describes a response with status code 201, with default header values.

Created
*/
type CreatePreventionPoliciesCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.PreventionRespV1
}

// IsSuccess returns true when this create prevention policies created response has a 2xx status code
func (o *CreatePreventionPoliciesCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create prevention policies created response has a 3xx status code
func (o *CreatePreventionPoliciesCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create prevention policies created response has a 4xx status code
func (o *CreatePreventionPoliciesCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create prevention policies created response has a 5xx status code
func (o *CreatePreventionPoliciesCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create prevention policies created response a status code equal to that given
func (o *CreatePreventionPoliciesCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create prevention policies created response
func (o *CreatePreventionPoliciesCreated) Code() int {
	return 201
}

func (o *CreatePreventionPoliciesCreated) Error() string {
	return fmt.Sprintf("[POST /policy/entities/prevention/v1][%d] createPreventionPoliciesCreated  %+v", 201, o.Payload)
}

func (o *CreatePreventionPoliciesCreated) String() string {
	return fmt.Sprintf("[POST /policy/entities/prevention/v1][%d] createPreventionPoliciesCreated  %+v", 201, o.Payload)
}

func (o *CreatePreventionPoliciesCreated) GetPayload() *models.PreventionRespV1 {
	return o.Payload
}

func (o *CreatePreventionPoliciesCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.PreventionRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePreventionPoliciesBadRequest creates a CreatePreventionPoliciesBadRequest with default headers values
func NewCreatePreventionPoliciesBadRequest() *CreatePreventionPoliciesBadRequest {
	return &CreatePreventionPoliciesBadRequest{}
}

/*
CreatePreventionPoliciesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreatePreventionPoliciesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.PreventionRespV1
}

// IsSuccess returns true when this create prevention policies bad request response has a 2xx status code
func (o *CreatePreventionPoliciesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create prevention policies bad request response has a 3xx status code
func (o *CreatePreventionPoliciesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create prevention policies bad request response has a 4xx status code
func (o *CreatePreventionPoliciesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create prevention policies bad request response has a 5xx status code
func (o *CreatePreventionPoliciesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create prevention policies bad request response a status code equal to that given
func (o *CreatePreventionPoliciesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create prevention policies bad request response
func (o *CreatePreventionPoliciesBadRequest) Code() int {
	return 400
}

func (o *CreatePreventionPoliciesBadRequest) Error() string {
	return fmt.Sprintf("[POST /policy/entities/prevention/v1][%d] createPreventionPoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *CreatePreventionPoliciesBadRequest) String() string {
	return fmt.Sprintf("[POST /policy/entities/prevention/v1][%d] createPreventionPoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *CreatePreventionPoliciesBadRequest) GetPayload() *models.PreventionRespV1 {
	return o.Payload
}

func (o *CreatePreventionPoliciesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.PreventionRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePreventionPoliciesForbidden creates a CreatePreventionPoliciesForbidden with default headers values
func NewCreatePreventionPoliciesForbidden() *CreatePreventionPoliciesForbidden {
	return &CreatePreventionPoliciesForbidden{}
}

/*
CreatePreventionPoliciesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreatePreventionPoliciesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this create prevention policies forbidden response has a 2xx status code
func (o *CreatePreventionPoliciesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create prevention policies forbidden response has a 3xx status code
func (o *CreatePreventionPoliciesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create prevention policies forbidden response has a 4xx status code
func (o *CreatePreventionPoliciesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create prevention policies forbidden response has a 5xx status code
func (o *CreatePreventionPoliciesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create prevention policies forbidden response a status code equal to that given
func (o *CreatePreventionPoliciesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create prevention policies forbidden response
func (o *CreatePreventionPoliciesForbidden) Code() int {
	return 403
}

func (o *CreatePreventionPoliciesForbidden) Error() string {
	return fmt.Sprintf("[POST /policy/entities/prevention/v1][%d] createPreventionPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *CreatePreventionPoliciesForbidden) String() string {
	return fmt.Sprintf("[POST /policy/entities/prevention/v1][%d] createPreventionPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *CreatePreventionPoliciesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *CreatePreventionPoliciesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePreventionPoliciesNotFound creates a CreatePreventionPoliciesNotFound with default headers values
func NewCreatePreventionPoliciesNotFound() *CreatePreventionPoliciesNotFound {
	return &CreatePreventionPoliciesNotFound{}
}

/*
CreatePreventionPoliciesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type CreatePreventionPoliciesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.PreventionRespV1
}

// IsSuccess returns true when this create prevention policies not found response has a 2xx status code
func (o *CreatePreventionPoliciesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create prevention policies not found response has a 3xx status code
func (o *CreatePreventionPoliciesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create prevention policies not found response has a 4xx status code
func (o *CreatePreventionPoliciesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this create prevention policies not found response has a 5xx status code
func (o *CreatePreventionPoliciesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this create prevention policies not found response a status code equal to that given
func (o *CreatePreventionPoliciesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the create prevention policies not found response
func (o *CreatePreventionPoliciesNotFound) Code() int {
	return 404
}

func (o *CreatePreventionPoliciesNotFound) Error() string {
	return fmt.Sprintf("[POST /policy/entities/prevention/v1][%d] createPreventionPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *CreatePreventionPoliciesNotFound) String() string {
	return fmt.Sprintf("[POST /policy/entities/prevention/v1][%d] createPreventionPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *CreatePreventionPoliciesNotFound) GetPayload() *models.PreventionRespV1 {
	return o.Payload
}

func (o *CreatePreventionPoliciesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.PreventionRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePreventionPoliciesTooManyRequests creates a CreatePreventionPoliciesTooManyRequests with default headers values
func NewCreatePreventionPoliciesTooManyRequests() *CreatePreventionPoliciesTooManyRequests {
	return &CreatePreventionPoliciesTooManyRequests{}
}

/*
CreatePreventionPoliciesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreatePreventionPoliciesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create prevention policies too many requests response has a 2xx status code
func (o *CreatePreventionPoliciesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create prevention policies too many requests response has a 3xx status code
func (o *CreatePreventionPoliciesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create prevention policies too many requests response has a 4xx status code
func (o *CreatePreventionPoliciesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create prevention policies too many requests response has a 5xx status code
func (o *CreatePreventionPoliciesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create prevention policies too many requests response a status code equal to that given
func (o *CreatePreventionPoliciesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create prevention policies too many requests response
func (o *CreatePreventionPoliciesTooManyRequests) Code() int {
	return 429
}

func (o *CreatePreventionPoliciesTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /policy/entities/prevention/v1][%d] createPreventionPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreatePreventionPoliciesTooManyRequests) String() string {
	return fmt.Sprintf("[POST /policy/entities/prevention/v1][%d] createPreventionPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreatePreventionPoliciesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreatePreventionPoliciesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePreventionPoliciesInternalServerError creates a CreatePreventionPoliciesInternalServerError with default headers values
func NewCreatePreventionPoliciesInternalServerError() *CreatePreventionPoliciesInternalServerError {
	return &CreatePreventionPoliciesInternalServerError{}
}

/*
CreatePreventionPoliciesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CreatePreventionPoliciesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.PreventionRespV1
}

// IsSuccess returns true when this create prevention policies internal server error response has a 2xx status code
func (o *CreatePreventionPoliciesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create prevention policies internal server error response has a 3xx status code
func (o *CreatePreventionPoliciesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create prevention policies internal server error response has a 4xx status code
func (o *CreatePreventionPoliciesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create prevention policies internal server error response has a 5xx status code
func (o *CreatePreventionPoliciesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create prevention policies internal server error response a status code equal to that given
func (o *CreatePreventionPoliciesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create prevention policies internal server error response
func (o *CreatePreventionPoliciesInternalServerError) Code() int {
	return 500
}

func (o *CreatePreventionPoliciesInternalServerError) Error() string {
	return fmt.Sprintf("[POST /policy/entities/prevention/v1][%d] createPreventionPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *CreatePreventionPoliciesInternalServerError) String() string {
	return fmt.Sprintf("[POST /policy/entities/prevention/v1][%d] createPreventionPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *CreatePreventionPoliciesInternalServerError) GetPayload() *models.PreventionRespV1 {
	return o.Payload
}

func (o *CreatePreventionPoliciesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.PreventionRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
