// Code generated by go-swagger; DO NOT EDIT.

package prevention_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeletePreventionPoliciesParams creates a new DeletePreventionPoliciesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeletePreventionPoliciesParams() *DeletePreventionPoliciesParams {
	return &DeletePreventionPoliciesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeletePreventionPoliciesParamsWithTimeout creates a new DeletePreventionPoliciesParams object
// with the ability to set a timeout on a request.
func NewDeletePreventionPoliciesParamsWithTimeout(timeout time.Duration) *DeletePreventionPoliciesParams {
	return &DeletePreventionPoliciesParams{
		timeout: timeout,
	}
}

// NewDeletePreventionPoliciesParamsWithContext creates a new DeletePreventionPoliciesParams object
// with the ability to set a context for a request.
func NewDeletePreventionPoliciesParamsWithContext(ctx context.Context) *DeletePreventionPoliciesParams {
	return &DeletePreventionPoliciesParams{
		Context: ctx,
	}
}

// NewDeletePreventionPoliciesParamsWithHTTPClient creates a new DeletePreventionPoliciesParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeletePreventionPoliciesParamsWithHTTPClient(client *http.Client) *DeletePreventionPoliciesParams {
	return &DeletePreventionPoliciesParams{
		HTTPClient: client,
	}
}

/*
DeletePreventionPoliciesParams contains all the parameters to send to the API endpoint

	for the delete prevention policies operation.

	Typically these are written to a http.Request.
*/
type DeletePreventionPoliciesParams struct {

	/* Ids.

	   The IDs of the Prevention Policies to delete
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete prevention policies params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeletePreventionPoliciesParams) WithDefaults() *DeletePreventionPoliciesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete prevention policies params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeletePreventionPoliciesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete prevention policies params
func (o *DeletePreventionPoliciesParams) WithTimeout(timeout time.Duration) *DeletePreventionPoliciesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete prevention policies params
func (o *DeletePreventionPoliciesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete prevention policies params
func (o *DeletePreventionPoliciesParams) WithContext(ctx context.Context) *DeletePreventionPoliciesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete prevention policies params
func (o *DeletePreventionPoliciesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete prevention policies params
func (o *DeletePreventionPoliciesParams) WithHTTPClient(client *http.Client) *DeletePreventionPoliciesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete prevention policies params
func (o *DeletePreventionPoliciesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the delete prevention policies params
func (o *DeletePreventionPoliciesParams) WithIds(ids []string) *DeletePreventionPoliciesParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the delete prevention policies params
func (o *DeletePreventionPoliciesParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *DeletePreventionPoliciesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDeletePreventionPolicies binds the parameter ids
func (o *DeletePreventionPoliciesParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
