// Code generated by go-swagger; DO NOT EDIT.

package prevention_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// DeletePreventionPoliciesReader is a Reader for the DeletePreventionPolicies structure.
type DeletePreventionPoliciesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeletePreventionPoliciesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeletePreventionPoliciesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewDeletePreventionPoliciesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeletePreventionPoliciesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewDeletePreventionPoliciesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeletePreventionPoliciesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /policy/entities/prevention/v1] deletePreventionPolicies", response, response.Code())
	}
}

// NewDeletePreventionPoliciesOK creates a DeletePreventionPoliciesOK with default headers values
func NewDeletePreventionPoliciesOK() *DeletePreventionPoliciesOK {
	return &DeletePreventionPoliciesOK{}
}

/*
DeletePreventionPoliciesOK describes a response with status code 200, with default header values.

OK
*/
type DeletePreventionPoliciesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete prevention policies o k response has a 2xx status code
func (o *DeletePreventionPoliciesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete prevention policies o k response has a 3xx status code
func (o *DeletePreventionPoliciesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete prevention policies o k response has a 4xx status code
func (o *DeletePreventionPoliciesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete prevention policies o k response has a 5xx status code
func (o *DeletePreventionPoliciesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete prevention policies o k response a status code equal to that given
func (o *DeletePreventionPoliciesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete prevention policies o k response
func (o *DeletePreventionPoliciesOK) Code() int {
	return 200
}

func (o *DeletePreventionPoliciesOK) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/prevention/v1][%d] deletePreventionPoliciesOK  %+v", 200, o.Payload)
}

func (o *DeletePreventionPoliciesOK) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/prevention/v1][%d] deletePreventionPoliciesOK  %+v", 200, o.Payload)
}

func (o *DeletePreventionPoliciesOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeletePreventionPoliciesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePreventionPoliciesForbidden creates a DeletePreventionPoliciesForbidden with default headers values
func NewDeletePreventionPoliciesForbidden() *DeletePreventionPoliciesForbidden {
	return &DeletePreventionPoliciesForbidden{}
}

/*
DeletePreventionPoliciesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeletePreventionPoliciesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this delete prevention policies forbidden response has a 2xx status code
func (o *DeletePreventionPoliciesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete prevention policies forbidden response has a 3xx status code
func (o *DeletePreventionPoliciesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete prevention policies forbidden response has a 4xx status code
func (o *DeletePreventionPoliciesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete prevention policies forbidden response has a 5xx status code
func (o *DeletePreventionPoliciesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete prevention policies forbidden response a status code equal to that given
func (o *DeletePreventionPoliciesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete prevention policies forbidden response
func (o *DeletePreventionPoliciesForbidden) Code() int {
	return 403
}

func (o *DeletePreventionPoliciesForbidden) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/prevention/v1][%d] deletePreventionPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *DeletePreventionPoliciesForbidden) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/prevention/v1][%d] deletePreventionPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *DeletePreventionPoliciesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *DeletePreventionPoliciesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePreventionPoliciesNotFound creates a DeletePreventionPoliciesNotFound with default headers values
func NewDeletePreventionPoliciesNotFound() *DeletePreventionPoliciesNotFound {
	return &DeletePreventionPoliciesNotFound{}
}

/*
DeletePreventionPoliciesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type DeletePreventionPoliciesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete prevention policies not found response has a 2xx status code
func (o *DeletePreventionPoliciesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete prevention policies not found response has a 3xx status code
func (o *DeletePreventionPoliciesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete prevention policies not found response has a 4xx status code
func (o *DeletePreventionPoliciesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete prevention policies not found response has a 5xx status code
func (o *DeletePreventionPoliciesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete prevention policies not found response a status code equal to that given
func (o *DeletePreventionPoliciesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete prevention policies not found response
func (o *DeletePreventionPoliciesNotFound) Code() int {
	return 404
}

func (o *DeletePreventionPoliciesNotFound) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/prevention/v1][%d] deletePreventionPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *DeletePreventionPoliciesNotFound) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/prevention/v1][%d] deletePreventionPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *DeletePreventionPoliciesNotFound) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeletePreventionPoliciesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePreventionPoliciesTooManyRequests creates a DeletePreventionPoliciesTooManyRequests with default headers values
func NewDeletePreventionPoliciesTooManyRequests() *DeletePreventionPoliciesTooManyRequests {
	return &DeletePreventionPoliciesTooManyRequests{}
}

/*
DeletePreventionPoliciesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type DeletePreventionPoliciesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete prevention policies too many requests response has a 2xx status code
func (o *DeletePreventionPoliciesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete prevention policies too many requests response has a 3xx status code
func (o *DeletePreventionPoliciesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete prevention policies too many requests response has a 4xx status code
func (o *DeletePreventionPoliciesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete prevention policies too many requests response has a 5xx status code
func (o *DeletePreventionPoliciesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this delete prevention policies too many requests response a status code equal to that given
func (o *DeletePreventionPoliciesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the delete prevention policies too many requests response
func (o *DeletePreventionPoliciesTooManyRequests) Code() int {
	return 429
}

func (o *DeletePreventionPoliciesTooManyRequests) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/prevention/v1][%d] deletePreventionPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeletePreventionPoliciesTooManyRequests) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/prevention/v1][%d] deletePreventionPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeletePreventionPoliciesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeletePreventionPoliciesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePreventionPoliciesInternalServerError creates a DeletePreventionPoliciesInternalServerError with default headers values
func NewDeletePreventionPoliciesInternalServerError() *DeletePreventionPoliciesInternalServerError {
	return &DeletePreventionPoliciesInternalServerError{}
}

/*
DeletePreventionPoliciesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type DeletePreventionPoliciesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete prevention policies internal server error response has a 2xx status code
func (o *DeletePreventionPoliciesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete prevention policies internal server error response has a 3xx status code
func (o *DeletePreventionPoliciesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete prevention policies internal server error response has a 4xx status code
func (o *DeletePreventionPoliciesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete prevention policies internal server error response has a 5xx status code
func (o *DeletePreventionPoliciesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete prevention policies internal server error response a status code equal to that given
func (o *DeletePreventionPoliciesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete prevention policies internal server error response
func (o *DeletePreventionPoliciesInternalServerError) Code() int {
	return 500
}

func (o *DeletePreventionPoliciesInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/prevention/v1][%d] deletePreventionPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *DeletePreventionPoliciesInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/prevention/v1][%d] deletePreventionPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *DeletePreventionPoliciesInternalServerError) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeletePreventionPoliciesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
