// Code generated by go-swagger; DO NOT EDIT.

package prevention_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewPerformPreventionPoliciesActionParams creates a new PerformPreventionPoliciesActionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPerformPreventionPoliciesActionParams() *PerformPreventionPoliciesActionParams {
	return &PerformPreventionPoliciesActionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPerformPreventionPoliciesActionParamsWithTimeout creates a new PerformPreventionPoliciesActionParams object
// with the ability to set a timeout on a request.
func NewPerformPreventionPoliciesActionParamsWithTimeout(timeout time.Duration) *PerformPreventionPoliciesActionParams {
	return &PerformPreventionPoliciesActionParams{
		timeout: timeout,
	}
}

// NewPerformPreventionPoliciesActionParamsWithContext creates a new PerformPreventionPoliciesActionParams object
// with the ability to set a context for a request.
func NewPerformPreventionPoliciesActionParamsWithContext(ctx context.Context) *PerformPreventionPoliciesActionParams {
	return &PerformPreventionPoliciesActionParams{
		Context: ctx,
	}
}

// NewPerformPreventionPoliciesActionParamsWithHTTPClient creates a new PerformPreventionPoliciesActionParams object
// with the ability to set a custom HTTPClient for a request.
func NewPerformPreventionPoliciesActionParamsWithHTTPClient(client *http.Client) *PerformPreventionPoliciesActionParams {
	return &PerformPreventionPoliciesActionParams{
		HTTPClient: client,
	}
}

/*
PerformPreventionPoliciesActionParams contains all the parameters to send to the API endpoint

	for the perform prevention policies action operation.

	Typically these are written to a http.Request.
*/
type PerformPreventionPoliciesActionParams struct {

	/* ActionName.

	   The action to perform
	*/
	ActionName string

	// Body.
	Body *models.MsaEntityActionRequestV2

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the perform prevention policies action params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformPreventionPoliciesActionParams) WithDefaults() *PerformPreventionPoliciesActionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the perform prevention policies action params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformPreventionPoliciesActionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the perform prevention policies action params
func (o *PerformPreventionPoliciesActionParams) WithTimeout(timeout time.Duration) *PerformPreventionPoliciesActionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the perform prevention policies action params
func (o *PerformPreventionPoliciesActionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the perform prevention policies action params
func (o *PerformPreventionPoliciesActionParams) WithContext(ctx context.Context) *PerformPreventionPoliciesActionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the perform prevention policies action params
func (o *PerformPreventionPoliciesActionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the perform prevention policies action params
func (o *PerformPreventionPoliciesActionParams) WithHTTPClient(client *http.Client) *PerformPreventionPoliciesActionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the perform prevention policies action params
func (o *PerformPreventionPoliciesActionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActionName adds the actionName to the perform prevention policies action params
func (o *PerformPreventionPoliciesActionParams) WithActionName(actionName string) *PerformPreventionPoliciesActionParams {
	o.SetActionName(actionName)
	return o
}

// SetActionName adds the actionName to the perform prevention policies action params
func (o *PerformPreventionPoliciesActionParams) SetActionName(actionName string) {
	o.ActionName = actionName
}

// WithBody adds the body to the perform prevention policies action params
func (o *PerformPreventionPoliciesActionParams) WithBody(body *models.MsaEntityActionRequestV2) *PerformPreventionPoliciesActionParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the perform prevention policies action params
func (o *PerformPreventionPoliciesActionParams) SetBody(body *models.MsaEntityActionRequestV2) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *PerformPreventionPoliciesActionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param action_name
	qrActionName := o.ActionName
	qActionName := qrActionName
	if qActionName != "" {

		if err := r.SetQueryParam("action_name", qActionName); err != nil {
			return err
		}
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
