// Code generated by go-swagger; DO NOT EDIT.

package prevention_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new prevention policies API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for prevention policies API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CreatePreventionPolicies(params *CreatePreventionPoliciesParams, opts ...ClientOption) (*CreatePreventionPoliciesCreated, error)

	DeletePreventionPolicies(params *DeletePreventionPoliciesParams, opts ...ClientOption) (*DeletePreventionPoliciesOK, error)

	GetPreventionPolicies(params *GetPreventionPoliciesParams, opts ...ClientOption) (*GetPreventionPoliciesOK, error)

	PerformPreventionPoliciesAction(params *PerformPreventionPoliciesActionParams, opts ...ClientOption) (*PerformPreventionPoliciesActionOK, error)

	QueryCombinedPreventionPolicies(params *QueryCombinedPreventionPoliciesParams, opts ...ClientOption) (*QueryCombinedPreventionPoliciesOK, error)

	QueryCombinedPreventionPolicyMembers(params *QueryCombinedPreventionPolicyMembersParams, opts ...ClientOption) (*QueryCombinedPreventionPolicyMembersOK, error)

	QueryPreventionPolicies(params *QueryPreventionPoliciesParams, opts ...ClientOption) (*QueryPreventionPoliciesOK, error)

	QueryPreventionPolicyMembers(params *QueryPreventionPolicyMembersParams, opts ...ClientOption) (*QueryPreventionPolicyMembersOK, error)

	SetPreventionPoliciesPrecedence(params *SetPreventionPoliciesPrecedenceParams, opts ...ClientOption) (*SetPreventionPoliciesPrecedenceOK, error)

	UpdatePreventionPolicies(params *UpdatePreventionPoliciesParams, opts ...ClientOption) (*UpdatePreventionPoliciesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CreatePreventionPolicies creates prevention policies by specifying details about the policy to create
*/
func (a *Client) CreatePreventionPolicies(params *CreatePreventionPoliciesParams, opts ...ClientOption) (*CreatePreventionPoliciesCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreatePreventionPoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createPreventionPolicies",
		Method:             "POST",
		PathPattern:        "/policy/entities/prevention/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreatePreventionPoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreatePreventionPoliciesCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createPreventionPolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeletePreventionPolicies deletes a set of prevention policies by specifying their i ds
*/
func (a *Client) DeletePreventionPolicies(params *DeletePreventionPoliciesParams, opts ...ClientOption) (*DeletePreventionPoliciesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeletePreventionPoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deletePreventionPolicies",
		Method:             "DELETE",
		PathPattern:        "/policy/entities/prevention/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeletePreventionPoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeletePreventionPoliciesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deletePreventionPolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetPreventionPolicies retrieves a set of prevention policies by specifying their i ds
*/
func (a *Client) GetPreventionPolicies(params *GetPreventionPoliciesParams, opts ...ClientOption) (*GetPreventionPoliciesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetPreventionPoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getPreventionPolicies",
		Method:             "GET",
		PathPattern:        "/policy/entities/prevention/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetPreventionPoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetPreventionPoliciesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getPreventionPolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PerformPreventionPoliciesAction performs the specified action on the prevention policies specified in the request
*/
func (a *Client) PerformPreventionPoliciesAction(params *PerformPreventionPoliciesActionParams, opts ...ClientOption) (*PerformPreventionPoliciesActionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformPreventionPoliciesActionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performPreventionPoliciesAction",
		Method:             "POST",
		PathPattern:        "/policy/entities/prevention-actions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformPreventionPoliciesActionReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformPreventionPoliciesActionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for performPreventionPoliciesAction: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryCombinedPreventionPolicies searches for prevention policies in your environment by providing an f q l filter and paging details returns a set of prevention policies which match the filter criteria
*/
func (a *Client) QueryCombinedPreventionPolicies(params *QueryCombinedPreventionPoliciesParams, opts ...ClientOption) (*QueryCombinedPreventionPoliciesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryCombinedPreventionPoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryCombinedPreventionPolicies",
		Method:             "GET",
		PathPattern:        "/policy/combined/prevention/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryCombinedPreventionPoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryCombinedPreventionPoliciesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryCombinedPreventionPolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryCombinedPreventionPolicyMembers searches for members of a prevention policy in your environment by providing an f q l filter and paging details returns a set of host details which match the filter criteria
*/
func (a *Client) QueryCombinedPreventionPolicyMembers(params *QueryCombinedPreventionPolicyMembersParams, opts ...ClientOption) (*QueryCombinedPreventionPolicyMembersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryCombinedPreventionPolicyMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryCombinedPreventionPolicyMembers",
		Method:             "GET",
		PathPattern:        "/policy/combined/prevention-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryCombinedPreventionPolicyMembersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryCombinedPreventionPolicyMembersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryCombinedPreventionPolicyMembers: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryPreventionPolicies searches for prevention policies in your environment by providing an f q l filter and paging details returns a set of prevention policy i ds which match the filter criteria
*/
func (a *Client) QueryPreventionPolicies(params *QueryPreventionPoliciesParams, opts ...ClientOption) (*QueryPreventionPoliciesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryPreventionPoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryPreventionPolicies",
		Method:             "GET",
		PathPattern:        "/policy/queries/prevention/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryPreventionPoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryPreventionPoliciesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryPreventionPolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryPreventionPolicyMembers searches for members of a prevention policy in your environment by providing an f q l filter and paging details returns a set of agent i ds which match the filter criteria
*/
func (a *Client) QueryPreventionPolicyMembers(params *QueryPreventionPolicyMembersParams, opts ...ClientOption) (*QueryPreventionPolicyMembersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryPreventionPolicyMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryPreventionPolicyMembers",
		Method:             "GET",
		PathPattern:        "/policy/queries/prevention-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryPreventionPolicyMembersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryPreventionPolicyMembersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryPreventionPolicyMembers: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SetPreventionPoliciesPrecedence sets the precedence of prevention policies based on the order of i ds specified in the request the first ID specified will have the highest precedence and the last ID specified will have the lowest you must specify all non default policies for a platform when updating precedence
*/
func (a *Client) SetPreventionPoliciesPrecedence(params *SetPreventionPoliciesPrecedenceParams, opts ...ClientOption) (*SetPreventionPoliciesPrecedenceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSetPreventionPoliciesPrecedenceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "setPreventionPoliciesPrecedence",
		Method:             "POST",
		PathPattern:        "/policy/entities/prevention-precedence/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SetPreventionPoliciesPrecedenceReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SetPreventionPoliciesPrecedenceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for setPreventionPoliciesPrecedence: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdatePreventionPolicies updates prevention policies by specifying the ID of the policy and details to update
*/
func (a *Client) UpdatePreventionPolicies(params *UpdatePreventionPoliciesParams, opts ...ClientOption) (*UpdatePreventionPoliciesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdatePreventionPoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updatePreventionPolicies",
		Method:             "PATCH",
		PathPattern:        "/policy/entities/prevention/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdatePreventionPoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdatePreventionPoliciesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updatePreventionPolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
