// Code generated by go-swagger; DO NOT EDIT.

package prevention_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryCombinedPreventionPolicyMembersReader is a Reader for the QueryCombinedPreventionPolicyMembers structure.
type QueryCombinedPreventionPolicyMembersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryCombinedPreventionPolicyMembersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryCombinedPreventionPolicyMembersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryCombinedPreventionPolicyMembersBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryCombinedPreventionPolicyMembersForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewQueryCombinedPreventionPolicyMembersNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryCombinedPreventionPolicyMembersTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryCombinedPreventionPolicyMembersInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /policy/combined/prevention-members/v1] queryCombinedPreventionPolicyMembers", response, response.Code())
	}
}

// NewQueryCombinedPreventionPolicyMembersOK creates a QueryCombinedPreventionPolicyMembersOK with default headers values
func NewQueryCombinedPreventionPolicyMembersOK() *QueryCombinedPreventionPolicyMembersOK {
	return &QueryCombinedPreventionPolicyMembersOK{}
}

/*
QueryCombinedPreventionPolicyMembersOK describes a response with status code 200, with default header values.

OK
*/
type QueryCombinedPreventionPolicyMembersOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.BasePolicyMembersRespV1
}

// IsSuccess returns true when this query combined prevention policy members o k response has a 2xx status code
func (o *QueryCombinedPreventionPolicyMembersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query combined prevention policy members o k response has a 3xx status code
func (o *QueryCombinedPreventionPolicyMembersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined prevention policy members o k response has a 4xx status code
func (o *QueryCombinedPreventionPolicyMembersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined prevention policy members o k response has a 5xx status code
func (o *QueryCombinedPreventionPolicyMembersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined prevention policy members o k response a status code equal to that given
func (o *QueryCombinedPreventionPolicyMembersOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query combined prevention policy members o k response
func (o *QueryCombinedPreventionPolicyMembersOK) Code() int {
	return 200
}

func (o *QueryCombinedPreventionPolicyMembersOK) Error() string {
	return fmt.Sprintf("[GET /policy/combined/prevention-members/v1][%d] queryCombinedPreventionPolicyMembersOK  %+v", 200, o.Payload)
}

func (o *QueryCombinedPreventionPolicyMembersOK) String() string {
	return fmt.Sprintf("[GET /policy/combined/prevention-members/v1][%d] queryCombinedPreventionPolicyMembersOK  %+v", 200, o.Payload)
}

func (o *QueryCombinedPreventionPolicyMembersOK) GetPayload() *models.BasePolicyMembersRespV1 {
	return o.Payload
}

func (o *QueryCombinedPreventionPolicyMembersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.BasePolicyMembersRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedPreventionPolicyMembersBadRequest creates a QueryCombinedPreventionPolicyMembersBadRequest with default headers values
func NewQueryCombinedPreventionPolicyMembersBadRequest() *QueryCombinedPreventionPolicyMembersBadRequest {
	return &QueryCombinedPreventionPolicyMembersBadRequest{}
}

/*
QueryCombinedPreventionPolicyMembersBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryCombinedPreventionPolicyMembersBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.BasePolicyMembersRespV1
}

// IsSuccess returns true when this query combined prevention policy members bad request response has a 2xx status code
func (o *QueryCombinedPreventionPolicyMembersBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined prevention policy members bad request response has a 3xx status code
func (o *QueryCombinedPreventionPolicyMembersBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined prevention policy members bad request response has a 4xx status code
func (o *QueryCombinedPreventionPolicyMembersBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined prevention policy members bad request response has a 5xx status code
func (o *QueryCombinedPreventionPolicyMembersBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined prevention policy members bad request response a status code equal to that given
func (o *QueryCombinedPreventionPolicyMembersBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query combined prevention policy members bad request response
func (o *QueryCombinedPreventionPolicyMembersBadRequest) Code() int {
	return 400
}

func (o *QueryCombinedPreventionPolicyMembersBadRequest) Error() string {
	return fmt.Sprintf("[GET /policy/combined/prevention-members/v1][%d] queryCombinedPreventionPolicyMembersBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedPreventionPolicyMembersBadRequest) String() string {
	return fmt.Sprintf("[GET /policy/combined/prevention-members/v1][%d] queryCombinedPreventionPolicyMembersBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedPreventionPolicyMembersBadRequest) GetPayload() *models.BasePolicyMembersRespV1 {
	return o.Payload
}

func (o *QueryCombinedPreventionPolicyMembersBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.BasePolicyMembersRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedPreventionPolicyMembersForbidden creates a QueryCombinedPreventionPolicyMembersForbidden with default headers values
func NewQueryCombinedPreventionPolicyMembersForbidden() *QueryCombinedPreventionPolicyMembersForbidden {
	return &QueryCombinedPreventionPolicyMembersForbidden{}
}

/*
QueryCombinedPreventionPolicyMembersForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryCombinedPreventionPolicyMembersForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query combined prevention policy members forbidden response has a 2xx status code
func (o *QueryCombinedPreventionPolicyMembersForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined prevention policy members forbidden response has a 3xx status code
func (o *QueryCombinedPreventionPolicyMembersForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined prevention policy members forbidden response has a 4xx status code
func (o *QueryCombinedPreventionPolicyMembersForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined prevention policy members forbidden response has a 5xx status code
func (o *QueryCombinedPreventionPolicyMembersForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined prevention policy members forbidden response a status code equal to that given
func (o *QueryCombinedPreventionPolicyMembersForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query combined prevention policy members forbidden response
func (o *QueryCombinedPreventionPolicyMembersForbidden) Code() int {
	return 403
}

func (o *QueryCombinedPreventionPolicyMembersForbidden) Error() string {
	return fmt.Sprintf("[GET /policy/combined/prevention-members/v1][%d] queryCombinedPreventionPolicyMembersForbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedPreventionPolicyMembersForbidden) String() string {
	return fmt.Sprintf("[GET /policy/combined/prevention-members/v1][%d] queryCombinedPreventionPolicyMembersForbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedPreventionPolicyMembersForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryCombinedPreventionPolicyMembersForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedPreventionPolicyMembersNotFound creates a QueryCombinedPreventionPolicyMembersNotFound with default headers values
func NewQueryCombinedPreventionPolicyMembersNotFound() *QueryCombinedPreventionPolicyMembersNotFound {
	return &QueryCombinedPreventionPolicyMembersNotFound{}
}

/*
QueryCombinedPreventionPolicyMembersNotFound describes a response with status code 404, with default header values.

Not Found
*/
type QueryCombinedPreventionPolicyMembersNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.BasePolicyMembersRespV1
}

// IsSuccess returns true when this query combined prevention policy members not found response has a 2xx status code
func (o *QueryCombinedPreventionPolicyMembersNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined prevention policy members not found response has a 3xx status code
func (o *QueryCombinedPreventionPolicyMembersNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined prevention policy members not found response has a 4xx status code
func (o *QueryCombinedPreventionPolicyMembersNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined prevention policy members not found response has a 5xx status code
func (o *QueryCombinedPreventionPolicyMembersNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined prevention policy members not found response a status code equal to that given
func (o *QueryCombinedPreventionPolicyMembersNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the query combined prevention policy members not found response
func (o *QueryCombinedPreventionPolicyMembersNotFound) Code() int {
	return 404
}

func (o *QueryCombinedPreventionPolicyMembersNotFound) Error() string {
	return fmt.Sprintf("[GET /policy/combined/prevention-members/v1][%d] queryCombinedPreventionPolicyMembersNotFound  %+v", 404, o.Payload)
}

func (o *QueryCombinedPreventionPolicyMembersNotFound) String() string {
	return fmt.Sprintf("[GET /policy/combined/prevention-members/v1][%d] queryCombinedPreventionPolicyMembersNotFound  %+v", 404, o.Payload)
}

func (o *QueryCombinedPreventionPolicyMembersNotFound) GetPayload() *models.BasePolicyMembersRespV1 {
	return o.Payload
}

func (o *QueryCombinedPreventionPolicyMembersNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.BasePolicyMembersRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedPreventionPolicyMembersTooManyRequests creates a QueryCombinedPreventionPolicyMembersTooManyRequests with default headers values
func NewQueryCombinedPreventionPolicyMembersTooManyRequests() *QueryCombinedPreventionPolicyMembersTooManyRequests {
	return &QueryCombinedPreventionPolicyMembersTooManyRequests{}
}

/*
QueryCombinedPreventionPolicyMembersTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryCombinedPreventionPolicyMembersTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query combined prevention policy members too many requests response has a 2xx status code
func (o *QueryCombinedPreventionPolicyMembersTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined prevention policy members too many requests response has a 3xx status code
func (o *QueryCombinedPreventionPolicyMembersTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined prevention policy members too many requests response has a 4xx status code
func (o *QueryCombinedPreventionPolicyMembersTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined prevention policy members too many requests response has a 5xx status code
func (o *QueryCombinedPreventionPolicyMembersTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined prevention policy members too many requests response a status code equal to that given
func (o *QueryCombinedPreventionPolicyMembersTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query combined prevention policy members too many requests response
func (o *QueryCombinedPreventionPolicyMembersTooManyRequests) Code() int {
	return 429
}

func (o *QueryCombinedPreventionPolicyMembersTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/combined/prevention-members/v1][%d] queryCombinedPreventionPolicyMembersTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedPreventionPolicyMembersTooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/combined/prevention-members/v1][%d] queryCombinedPreventionPolicyMembersTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedPreventionPolicyMembersTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryCombinedPreventionPolicyMembersTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedPreventionPolicyMembersInternalServerError creates a QueryCombinedPreventionPolicyMembersInternalServerError with default headers values
func NewQueryCombinedPreventionPolicyMembersInternalServerError() *QueryCombinedPreventionPolicyMembersInternalServerError {
	return &QueryCombinedPreventionPolicyMembersInternalServerError{}
}

/*
QueryCombinedPreventionPolicyMembersInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryCombinedPreventionPolicyMembersInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.BasePolicyMembersRespV1
}

// IsSuccess returns true when this query combined prevention policy members internal server error response has a 2xx status code
func (o *QueryCombinedPreventionPolicyMembersInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined prevention policy members internal server error response has a 3xx status code
func (o *QueryCombinedPreventionPolicyMembersInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined prevention policy members internal server error response has a 4xx status code
func (o *QueryCombinedPreventionPolicyMembersInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined prevention policy members internal server error response has a 5xx status code
func (o *QueryCombinedPreventionPolicyMembersInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query combined prevention policy members internal server error response a status code equal to that given
func (o *QueryCombinedPreventionPolicyMembersInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query combined prevention policy members internal server error response
func (o *QueryCombinedPreventionPolicyMembersInternalServerError) Code() int {
	return 500
}

func (o *QueryCombinedPreventionPolicyMembersInternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/combined/prevention-members/v1][%d] queryCombinedPreventionPolicyMembersInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedPreventionPolicyMembersInternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/combined/prevention-members/v1][%d] queryCombinedPreventionPolicyMembersInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedPreventionPolicyMembersInternalServerError) GetPayload() *models.BasePolicyMembersRespV1 {
	return o.Payload
}

func (o *QueryCombinedPreventionPolicyMembersInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.BasePolicyMembersRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
