// Code generated by go-swagger; DO NOT EDIT.

package prevention_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryPreventionPolicyMembersParams creates a new QueryPreventionPolicyMembersParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryPreventionPolicyMembersParams() *QueryPreventionPolicyMembersParams {
	return &QueryPreventionPolicyMembersParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryPreventionPolicyMembersParamsWithTimeout creates a new QueryPreventionPolicyMembersParams object
// with the ability to set a timeout on a request.
func NewQueryPreventionPolicyMembersParamsWithTimeout(timeout time.Duration) *QueryPreventionPolicyMembersParams {
	return &QueryPreventionPolicyMembersParams{
		timeout: timeout,
	}
}

// NewQueryPreventionPolicyMembersParamsWithContext creates a new QueryPreventionPolicyMembersParams object
// with the ability to set a context for a request.
func NewQueryPreventionPolicyMembersParamsWithContext(ctx context.Context) *QueryPreventionPolicyMembersParams {
	return &QueryPreventionPolicyMembersParams{
		Context: ctx,
	}
}

// NewQueryPreventionPolicyMembersParamsWithHTTPClient creates a new QueryPreventionPolicyMembersParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryPreventionPolicyMembersParamsWithHTTPClient(client *http.Client) *QueryPreventionPolicyMembersParams {
	return &QueryPreventionPolicyMembersParams{
		HTTPClient: client,
	}
}

/*
QueryPreventionPolicyMembersParams contains all the parameters to send to the API endpoint

	for the query prevention policy members operation.

	Typically these are written to a http.Request.
*/
type QueryPreventionPolicyMembersParams struct {

	/* Filter.

	   The filter expression that should be used to limit the results
	*/
	Filter *string

	/* ID.

	   The ID of the Prevention Policy to search for members of
	*/
	ID *string

	/* Limit.

	   The maximum records to return. [1-5000]
	*/
	Limit *int64

	/* Offset.

	   The offset to start retrieving records from
	*/
	Offset *int64

	/* Sort.

	   The property to sort by
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query prevention policy members params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryPreventionPolicyMembersParams) WithDefaults() *QueryPreventionPolicyMembersParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query prevention policy members params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryPreventionPolicyMembersParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) WithTimeout(timeout time.Duration) *QueryPreventionPolicyMembersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) WithContext(ctx context.Context) *QueryPreventionPolicyMembersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) WithHTTPClient(client *http.Client) *QueryPreventionPolicyMembersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) WithFilter(filter *string) *QueryPreventionPolicyMembersParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithID adds the id to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) WithID(id *string) *QueryPreventionPolicyMembersParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) SetID(id *string) {
	o.ID = id
}

// WithLimit adds the limit to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) WithLimit(limit *int64) *QueryPreventionPolicyMembersParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) WithOffset(offset *int64) *QueryPreventionPolicyMembersParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) WithSort(sort *string) *QueryPreventionPolicyMembersParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query prevention policy members params
func (o *QueryPreventionPolicyMembersParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryPreventionPolicyMembersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.ID != nil {

		// query param id
		var qrID string

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := qrID
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
