// Code generated by go-swagger; DO NOT EDIT.

package prevention_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryPreventionPolicyMembersReader is a Reader for the QueryPreventionPolicyMembers structure.
type QueryPreventionPolicyMembersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryPreventionPolicyMembersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryPreventionPolicyMembersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryPreventionPolicyMembersBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryPreventionPolicyMembersForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewQueryPreventionPolicyMembersNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryPreventionPolicyMembersTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryPreventionPolicyMembersInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /policy/queries/prevention-members/v1] queryPreventionPolicyMembers", response, response.Code())
	}
}

// NewQueryPreventionPolicyMembersOK creates a QueryPreventionPolicyMembersOK with default headers values
func NewQueryPreventionPolicyMembersOK() *QueryPreventionPolicyMembersOK {
	return &QueryPreventionPolicyMembersOK{}
}

/*
QueryPreventionPolicyMembersOK describes a response with status code 200, with default header values.

OK
*/
type QueryPreventionPolicyMembersOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query prevention policy members o k response has a 2xx status code
func (o *QueryPreventionPolicyMembersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query prevention policy members o k response has a 3xx status code
func (o *QueryPreventionPolicyMembersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query prevention policy members o k response has a 4xx status code
func (o *QueryPreventionPolicyMembersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query prevention policy members o k response has a 5xx status code
func (o *QueryPreventionPolicyMembersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query prevention policy members o k response a status code equal to that given
func (o *QueryPreventionPolicyMembersOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query prevention policy members o k response
func (o *QueryPreventionPolicyMembersOK) Code() int {
	return 200
}

func (o *QueryPreventionPolicyMembersOK) Error() string {
	return fmt.Sprintf("[GET /policy/queries/prevention-members/v1][%d] queryPreventionPolicyMembersOK  %+v", 200, o.Payload)
}

func (o *QueryPreventionPolicyMembersOK) String() string {
	return fmt.Sprintf("[GET /policy/queries/prevention-members/v1][%d] queryPreventionPolicyMembersOK  %+v", 200, o.Payload)
}

func (o *QueryPreventionPolicyMembersOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryPreventionPolicyMembersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryPreventionPolicyMembersBadRequest creates a QueryPreventionPolicyMembersBadRequest with default headers values
func NewQueryPreventionPolicyMembersBadRequest() *QueryPreventionPolicyMembersBadRequest {
	return &QueryPreventionPolicyMembersBadRequest{}
}

/*
QueryPreventionPolicyMembersBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryPreventionPolicyMembersBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query prevention policy members bad request response has a 2xx status code
func (o *QueryPreventionPolicyMembersBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query prevention policy members bad request response has a 3xx status code
func (o *QueryPreventionPolicyMembersBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query prevention policy members bad request response has a 4xx status code
func (o *QueryPreventionPolicyMembersBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query prevention policy members bad request response has a 5xx status code
func (o *QueryPreventionPolicyMembersBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query prevention policy members bad request response a status code equal to that given
func (o *QueryPreventionPolicyMembersBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query prevention policy members bad request response
func (o *QueryPreventionPolicyMembersBadRequest) Code() int {
	return 400
}

func (o *QueryPreventionPolicyMembersBadRequest) Error() string {
	return fmt.Sprintf("[GET /policy/queries/prevention-members/v1][%d] queryPreventionPolicyMembersBadRequest  %+v", 400, o.Payload)
}

func (o *QueryPreventionPolicyMembersBadRequest) String() string {
	return fmt.Sprintf("[GET /policy/queries/prevention-members/v1][%d] queryPreventionPolicyMembersBadRequest  %+v", 400, o.Payload)
}

func (o *QueryPreventionPolicyMembersBadRequest) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryPreventionPolicyMembersBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryPreventionPolicyMembersForbidden creates a QueryPreventionPolicyMembersForbidden with default headers values
func NewQueryPreventionPolicyMembersForbidden() *QueryPreventionPolicyMembersForbidden {
	return &QueryPreventionPolicyMembersForbidden{}
}

/*
QueryPreventionPolicyMembersForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryPreventionPolicyMembersForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query prevention policy members forbidden response has a 2xx status code
func (o *QueryPreventionPolicyMembersForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query prevention policy members forbidden response has a 3xx status code
func (o *QueryPreventionPolicyMembersForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query prevention policy members forbidden response has a 4xx status code
func (o *QueryPreventionPolicyMembersForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query prevention policy members forbidden response has a 5xx status code
func (o *QueryPreventionPolicyMembersForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query prevention policy members forbidden response a status code equal to that given
func (o *QueryPreventionPolicyMembersForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query prevention policy members forbidden response
func (o *QueryPreventionPolicyMembersForbidden) Code() int {
	return 403
}

func (o *QueryPreventionPolicyMembersForbidden) Error() string {
	return fmt.Sprintf("[GET /policy/queries/prevention-members/v1][%d] queryPreventionPolicyMembersForbidden  %+v", 403, o.Payload)
}

func (o *QueryPreventionPolicyMembersForbidden) String() string {
	return fmt.Sprintf("[GET /policy/queries/prevention-members/v1][%d] queryPreventionPolicyMembersForbidden  %+v", 403, o.Payload)
}

func (o *QueryPreventionPolicyMembersForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryPreventionPolicyMembersForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryPreventionPolicyMembersNotFound creates a QueryPreventionPolicyMembersNotFound with default headers values
func NewQueryPreventionPolicyMembersNotFound() *QueryPreventionPolicyMembersNotFound {
	return &QueryPreventionPolicyMembersNotFound{}
}

/*
QueryPreventionPolicyMembersNotFound describes a response with status code 404, with default header values.

Not Found
*/
type QueryPreventionPolicyMembersNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query prevention policy members not found response has a 2xx status code
func (o *QueryPreventionPolicyMembersNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query prevention policy members not found response has a 3xx status code
func (o *QueryPreventionPolicyMembersNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query prevention policy members not found response has a 4xx status code
func (o *QueryPreventionPolicyMembersNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this query prevention policy members not found response has a 5xx status code
func (o *QueryPreventionPolicyMembersNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this query prevention policy members not found response a status code equal to that given
func (o *QueryPreventionPolicyMembersNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the query prevention policy members not found response
func (o *QueryPreventionPolicyMembersNotFound) Code() int {
	return 404
}

func (o *QueryPreventionPolicyMembersNotFound) Error() string {
	return fmt.Sprintf("[GET /policy/queries/prevention-members/v1][%d] queryPreventionPolicyMembersNotFound  %+v", 404, o.Payload)
}

func (o *QueryPreventionPolicyMembersNotFound) String() string {
	return fmt.Sprintf("[GET /policy/queries/prevention-members/v1][%d] queryPreventionPolicyMembersNotFound  %+v", 404, o.Payload)
}

func (o *QueryPreventionPolicyMembersNotFound) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryPreventionPolicyMembersNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryPreventionPolicyMembersTooManyRequests creates a QueryPreventionPolicyMembersTooManyRequests with default headers values
func NewQueryPreventionPolicyMembersTooManyRequests() *QueryPreventionPolicyMembersTooManyRequests {
	return &QueryPreventionPolicyMembersTooManyRequests{}
}

/*
QueryPreventionPolicyMembersTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryPreventionPolicyMembersTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query prevention policy members too many requests response has a 2xx status code
func (o *QueryPreventionPolicyMembersTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query prevention policy members too many requests response has a 3xx status code
func (o *QueryPreventionPolicyMembersTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query prevention policy members too many requests response has a 4xx status code
func (o *QueryPreventionPolicyMembersTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query prevention policy members too many requests response has a 5xx status code
func (o *QueryPreventionPolicyMembersTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query prevention policy members too many requests response a status code equal to that given
func (o *QueryPreventionPolicyMembersTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query prevention policy members too many requests response
func (o *QueryPreventionPolicyMembersTooManyRequests) Code() int {
	return 429
}

func (o *QueryPreventionPolicyMembersTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/queries/prevention-members/v1][%d] queryPreventionPolicyMembersTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryPreventionPolicyMembersTooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/queries/prevention-members/v1][%d] queryPreventionPolicyMembersTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryPreventionPolicyMembersTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryPreventionPolicyMembersTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryPreventionPolicyMembersInternalServerError creates a QueryPreventionPolicyMembersInternalServerError with default headers values
func NewQueryPreventionPolicyMembersInternalServerError() *QueryPreventionPolicyMembersInternalServerError {
	return &QueryPreventionPolicyMembersInternalServerError{}
}

/*
QueryPreventionPolicyMembersInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryPreventionPolicyMembersInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query prevention policy members internal server error response has a 2xx status code
func (o *QueryPreventionPolicyMembersInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query prevention policy members internal server error response has a 3xx status code
func (o *QueryPreventionPolicyMembersInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query prevention policy members internal server error response has a 4xx status code
func (o *QueryPreventionPolicyMembersInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query prevention policy members internal server error response has a 5xx status code
func (o *QueryPreventionPolicyMembersInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query prevention policy members internal server error response a status code equal to that given
func (o *QueryPreventionPolicyMembersInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query prevention policy members internal server error response
func (o *QueryPreventionPolicyMembersInternalServerError) Code() int {
	return 500
}

func (o *QueryPreventionPolicyMembersInternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/queries/prevention-members/v1][%d] queryPreventionPolicyMembersInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryPreventionPolicyMembersInternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/queries/prevention-members/v1][%d] queryPreventionPolicyMembersInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryPreventionPolicyMembersInternalServerError) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryPreventionPolicyMembersInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
