// Code generated by go-swagger; DO NOT EDIT.

package quarantine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewActionUpdateCountParams creates a new ActionUpdateCountParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewActionUpdateCountParams() *ActionUpdateCountParams {
	return &ActionUpdateCountParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewActionUpdateCountParamsWithTimeout creates a new ActionUpdateCountParams object
// with the ability to set a timeout on a request.
func NewActionUpdateCountParamsWithTimeout(timeout time.Duration) *ActionUpdateCountParams {
	return &ActionUpdateCountParams{
		timeout: timeout,
	}
}

// NewActionUpdateCountParamsWithContext creates a new ActionUpdateCountParams object
// with the ability to set a context for a request.
func NewActionUpdateCountParamsWithContext(ctx context.Context) *ActionUpdateCountParams {
	return &ActionUpdateCountParams{
		Context: ctx,
	}
}

// NewActionUpdateCountParamsWithHTTPClient creates a new ActionUpdateCountParams object
// with the ability to set a custom HTTPClient for a request.
func NewActionUpdateCountParamsWithHTTPClient(client *http.Client) *ActionUpdateCountParams {
	return &ActionUpdateCountParams{
		HTTPClient: client,
	}
}

/*
ActionUpdateCountParams contains all the parameters to send to the API endpoint

	for the action update count operation.

	Typically these are written to a http.Request.
*/
type ActionUpdateCountParams struct {

	/* Filter.

	   FQL specifying filter parameters.
	*/
	Filter string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the action update count params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActionUpdateCountParams) WithDefaults() *ActionUpdateCountParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the action update count params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActionUpdateCountParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the action update count params
func (o *ActionUpdateCountParams) WithTimeout(timeout time.Duration) *ActionUpdateCountParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the action update count params
func (o *ActionUpdateCountParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the action update count params
func (o *ActionUpdateCountParams) WithContext(ctx context.Context) *ActionUpdateCountParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the action update count params
func (o *ActionUpdateCountParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the action update count params
func (o *ActionUpdateCountParams) WithHTTPClient(client *http.Client) *ActionUpdateCountParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the action update count params
func (o *ActionUpdateCountParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the action update count params
func (o *ActionUpdateCountParams) WithFilter(filter string) *ActionUpdateCountParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the action update count params
func (o *ActionUpdateCountParams) SetFilter(filter string) {
	o.Filter = filter
}

// WriteToRequest writes these params to a swagger request
func (o *ActionUpdateCountParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param filter
	qrFilter := o.Filter
	qFilter := qrFilter
	if qFilter != "" {

		if err := r.SetQueryParam("filter", qFilter); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
