// Code generated by go-swagger; DO NOT EDIT.

package quarantine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetAggregateFilesReader is a Reader for the GetAggregateFiles structure.
type GetAggregateFilesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAggregateFilesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAggregateFilesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetAggregateFilesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetAggregateFilesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /quarantine/aggregates/quarantined-files/GET/v1] GetAggregateFiles", response, response.Code())
	}
}

// NewGetAggregateFilesOK creates a GetAggregateFilesOK with default headers values
func NewGetAggregateFilesOK() *GetAggregateFilesOK {
	return &GetAggregateFilesOK{}
}

/*
GetAggregateFilesOK describes a response with status code 200, with default header values.

OK
*/
type GetAggregateFilesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaAggregatesResponse
}

// IsSuccess returns true when this get aggregate files o k response has a 2xx status code
func (o *GetAggregateFilesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get aggregate files o k response has a 3xx status code
func (o *GetAggregateFilesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get aggregate files o k response has a 4xx status code
func (o *GetAggregateFilesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get aggregate files o k response has a 5xx status code
func (o *GetAggregateFilesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get aggregate files o k response a status code equal to that given
func (o *GetAggregateFilesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get aggregate files o k response
func (o *GetAggregateFilesOK) Code() int {
	return 200
}

func (o *GetAggregateFilesOK) Error() string {
	return fmt.Sprintf("[POST /quarantine/aggregates/quarantined-files/GET/v1][%d] getAggregateFilesOK  %+v", 200, o.Payload)
}

func (o *GetAggregateFilesOK) String() string {
	return fmt.Sprintf("[POST /quarantine/aggregates/quarantined-files/GET/v1][%d] getAggregateFilesOK  %+v", 200, o.Payload)
}

func (o *GetAggregateFilesOK) GetPayload() *models.MsaAggregatesResponse {
	return o.Payload
}

func (o *GetAggregateFilesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaAggregatesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAggregateFilesForbidden creates a GetAggregateFilesForbidden with default headers values
func NewGetAggregateFilesForbidden() *GetAggregateFilesForbidden {
	return &GetAggregateFilesForbidden{}
}

/*
GetAggregateFilesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetAggregateFilesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get aggregate files forbidden response has a 2xx status code
func (o *GetAggregateFilesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get aggregate files forbidden response has a 3xx status code
func (o *GetAggregateFilesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get aggregate files forbidden response has a 4xx status code
func (o *GetAggregateFilesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get aggregate files forbidden response has a 5xx status code
func (o *GetAggregateFilesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get aggregate files forbidden response a status code equal to that given
func (o *GetAggregateFilesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get aggregate files forbidden response
func (o *GetAggregateFilesForbidden) Code() int {
	return 403
}

func (o *GetAggregateFilesForbidden) Error() string {
	return fmt.Sprintf("[POST /quarantine/aggregates/quarantined-files/GET/v1][%d] getAggregateFilesForbidden  %+v", 403, o.Payload)
}

func (o *GetAggregateFilesForbidden) String() string {
	return fmt.Sprintf("[POST /quarantine/aggregates/quarantined-files/GET/v1][%d] getAggregateFilesForbidden  %+v", 403, o.Payload)
}

func (o *GetAggregateFilesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAggregateFilesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAggregateFilesTooManyRequests creates a GetAggregateFilesTooManyRequests with default headers values
func NewGetAggregateFilesTooManyRequests() *GetAggregateFilesTooManyRequests {
	return &GetAggregateFilesTooManyRequests{}
}

/*
GetAggregateFilesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetAggregateFilesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get aggregate files too many requests response has a 2xx status code
func (o *GetAggregateFilesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get aggregate files too many requests response has a 3xx status code
func (o *GetAggregateFilesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get aggregate files too many requests response has a 4xx status code
func (o *GetAggregateFilesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get aggregate files too many requests response has a 5xx status code
func (o *GetAggregateFilesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get aggregate files too many requests response a status code equal to that given
func (o *GetAggregateFilesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get aggregate files too many requests response
func (o *GetAggregateFilesTooManyRequests) Code() int {
	return 429
}

func (o *GetAggregateFilesTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /quarantine/aggregates/quarantined-files/GET/v1][%d] getAggregateFilesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAggregateFilesTooManyRequests) String() string {
	return fmt.Sprintf("[POST /quarantine/aggregates/quarantined-files/GET/v1][%d] getAggregateFilesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAggregateFilesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAggregateFilesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
