// Code generated by go-swagger; DO NOT EDIT.

package quarantine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetQuarantineFilesReader is a Reader for the GetQuarantineFiles structure.
type GetQuarantineFilesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetQuarantineFilesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetQuarantineFilesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetQuarantineFilesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetQuarantineFilesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /quarantine/entities/quarantined-files/GET/v1] GetQuarantineFiles", response, response.Code())
	}
}

// NewGetQuarantineFilesOK creates a GetQuarantineFilesOK with default headers values
func NewGetQuarantineFilesOK() *GetQuarantineFilesOK {
	return &GetQuarantineFilesOK{}
}

/*
GetQuarantineFilesOK describes a response with status code 200, with default header values.

OK
*/
type GetQuarantineFilesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainMsaQfResponse
}

// IsSuccess returns true when this get quarantine files o k response has a 2xx status code
func (o *GetQuarantineFilesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get quarantine files o k response has a 3xx status code
func (o *GetQuarantineFilesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get quarantine files o k response has a 4xx status code
func (o *GetQuarantineFilesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get quarantine files o k response has a 5xx status code
func (o *GetQuarantineFilesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get quarantine files o k response a status code equal to that given
func (o *GetQuarantineFilesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get quarantine files o k response
func (o *GetQuarantineFilesOK) Code() int {
	return 200
}

func (o *GetQuarantineFilesOK) Error() string {
	return fmt.Sprintf("[POST /quarantine/entities/quarantined-files/GET/v1][%d] getQuarantineFilesOK  %+v", 200, o.Payload)
}

func (o *GetQuarantineFilesOK) String() string {
	return fmt.Sprintf("[POST /quarantine/entities/quarantined-files/GET/v1][%d] getQuarantineFilesOK  %+v", 200, o.Payload)
}

func (o *GetQuarantineFilesOK) GetPayload() *models.DomainMsaQfResponse {
	return o.Payload
}

func (o *GetQuarantineFilesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainMsaQfResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetQuarantineFilesForbidden creates a GetQuarantineFilesForbidden with default headers values
func NewGetQuarantineFilesForbidden() *GetQuarantineFilesForbidden {
	return &GetQuarantineFilesForbidden{}
}

/*
GetQuarantineFilesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetQuarantineFilesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get quarantine files forbidden response has a 2xx status code
func (o *GetQuarantineFilesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get quarantine files forbidden response has a 3xx status code
func (o *GetQuarantineFilesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get quarantine files forbidden response has a 4xx status code
func (o *GetQuarantineFilesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get quarantine files forbidden response has a 5xx status code
func (o *GetQuarantineFilesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get quarantine files forbidden response a status code equal to that given
func (o *GetQuarantineFilesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get quarantine files forbidden response
func (o *GetQuarantineFilesForbidden) Code() int {
	return 403
}

func (o *GetQuarantineFilesForbidden) Error() string {
	return fmt.Sprintf("[POST /quarantine/entities/quarantined-files/GET/v1][%d] getQuarantineFilesForbidden  %+v", 403, o.Payload)
}

func (o *GetQuarantineFilesForbidden) String() string {
	return fmt.Sprintf("[POST /quarantine/entities/quarantined-files/GET/v1][%d] getQuarantineFilesForbidden  %+v", 403, o.Payload)
}

func (o *GetQuarantineFilesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetQuarantineFilesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetQuarantineFilesTooManyRequests creates a GetQuarantineFilesTooManyRequests with default headers values
func NewGetQuarantineFilesTooManyRequests() *GetQuarantineFilesTooManyRequests {
	return &GetQuarantineFilesTooManyRequests{}
}

/*
GetQuarantineFilesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetQuarantineFilesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get quarantine files too many requests response has a 2xx status code
func (o *GetQuarantineFilesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get quarantine files too many requests response has a 3xx status code
func (o *GetQuarantineFilesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get quarantine files too many requests response has a 4xx status code
func (o *GetQuarantineFilesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get quarantine files too many requests response has a 5xx status code
func (o *GetQuarantineFilesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get quarantine files too many requests response a status code equal to that given
func (o *GetQuarantineFilesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get quarantine files too many requests response
func (o *GetQuarantineFilesTooManyRequests) Code() int {
	return 429
}

func (o *GetQuarantineFilesTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /quarantine/entities/quarantined-files/GET/v1][%d] getQuarantineFilesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetQuarantineFilesTooManyRequests) String() string {
	return fmt.Sprintf("[POST /quarantine/entities/quarantined-files/GET/v1][%d] getQuarantineFilesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetQuarantineFilesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetQuarantineFilesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
