// Code generated by go-swagger; DO NOT EDIT.

package quarantine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new quarantine API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for quarantine API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ActionUpdateCount(params *ActionUpdateCountParams, opts ...ClientOption) (*ActionUpdateCountOK, error)

	GetAggregateFiles(params *GetAggregateFilesParams, opts ...ClientOption) (*GetAggregateFilesOK, error)

	GetQuarantineFiles(params *GetQuarantineFilesParams, opts ...ClientOption) (*GetQuarantineFilesOK, error)

	QueryQuarantineFiles(params *QueryQuarantineFilesParams, opts ...ClientOption) (*QueryQuarantineFilesOK, error)

	UpdateQfByQuery(params *UpdateQfByQueryParams, opts ...ClientOption) (*UpdateQfByQueryOK, error)

	UpdateQuarantinedDetectsByIds(params *UpdateQuarantinedDetectsByIdsParams, opts ...ClientOption) (*UpdateQuarantinedDetectsByIdsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ActionUpdateCount returns count of potentially affected quarantined files for each action
*/
func (a *Client) ActionUpdateCount(params *ActionUpdateCountParams, opts ...ClientOption) (*ActionUpdateCountOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActionUpdateCountParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ActionUpdateCount",
		Method:             "GET",
		PathPattern:        "/quarantine/aggregates/action-update-count/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActionUpdateCountReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActionUpdateCountOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ActionUpdateCount: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAggregateFiles gets quarantine file aggregates as specified via json in request body
*/
func (a *Client) GetAggregateFiles(params *GetAggregateFilesParams, opts ...ClientOption) (*GetAggregateFilesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAggregateFilesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAggregateFiles",
		Method:             "POST",
		PathPattern:        "/quarantine/aggregates/quarantined-files/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetAggregateFilesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAggregateFilesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAggregateFiles: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetQuarantineFiles gets quarantine file metadata for specified ids
*/
func (a *Client) GetQuarantineFiles(params *GetQuarantineFilesParams, opts ...ClientOption) (*GetQuarantineFilesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetQuarantineFilesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetQuarantineFiles",
		Method:             "POST",
		PathPattern:        "/quarantine/entities/quarantined-files/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetQuarantineFilesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetQuarantineFilesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetQuarantineFiles: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryQuarantineFiles gets quarantine file ids that match the provided filter criteria
*/
func (a *Client) QueryQuarantineFiles(params *QueryQuarantineFilesParams, opts ...ClientOption) (*QueryQuarantineFilesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryQuarantineFilesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryQuarantineFiles",
		Method:             "GET",
		PathPattern:        "/quarantine/queries/quarantined-files/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryQuarantineFilesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryQuarantineFilesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryQuarantineFiles: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateQfByQuery applies quarantine file actions by query
*/
func (a *Client) UpdateQfByQuery(params *UpdateQfByQueryParams, opts ...ClientOption) (*UpdateQfByQueryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateQfByQueryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateQfByQuery",
		Method:             "PATCH",
		PathPattern:        "/quarantine/queries/quarantined-files/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateQfByQueryReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateQfByQueryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for UpdateQfByQuery: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateQuarantinedDetectsByIds applies action by quarantine file ids
*/
func (a *Client) UpdateQuarantinedDetectsByIds(params *UpdateQuarantinedDetectsByIdsParams, opts ...ClientOption) (*UpdateQuarantinedDetectsByIdsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateQuarantinedDetectsByIdsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateQuarantinedDetectsByIds",
		Method:             "PATCH",
		PathPattern:        "/quarantine/entities/quarantined-files/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateQuarantinedDetectsByIdsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateQuarantinedDetectsByIdsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for UpdateQuarantinedDetectsByIds: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
