// Code generated by go-swagger; DO NOT EDIT.

package quarantine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryQuarantineFilesParams creates a new QueryQuarantineFilesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryQuarantineFilesParams() *QueryQuarantineFilesParams {
	return &QueryQuarantineFilesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryQuarantineFilesParamsWithTimeout creates a new QueryQuarantineFilesParams object
// with the ability to set a timeout on a request.
func NewQueryQuarantineFilesParamsWithTimeout(timeout time.Duration) *QueryQuarantineFilesParams {
	return &QueryQuarantineFilesParams{
		timeout: timeout,
	}
}

// NewQueryQuarantineFilesParamsWithContext creates a new QueryQuarantineFilesParams object
// with the ability to set a context for a request.
func NewQueryQuarantineFilesParamsWithContext(ctx context.Context) *QueryQuarantineFilesParams {
	return &QueryQuarantineFilesParams{
		Context: ctx,
	}
}

// NewQueryQuarantineFilesParamsWithHTTPClient creates a new QueryQuarantineFilesParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryQuarantineFilesParamsWithHTTPClient(client *http.Client) *QueryQuarantineFilesParams {
	return &QueryQuarantineFilesParams{
		HTTPClient: client,
	}
}

/*
QueryQuarantineFilesParams contains all the parameters to send to the API endpoint

	for the query quarantine files operation.

	Typically these are written to a http.Request.
*/
type QueryQuarantineFilesParams struct {

	/* Filter.

	   FQL query specifying the filter parameters. Special value '*' means to not filter on anything. Filter term criteria: status, adversary_id, device.device_id, device.country, device.hostname, behaviors.behavior_id, behaviors.ioc_type, behaviors.ioc_value, behaviors.username, behaviors.tree_root_hash. Filter range criteria:, max_severity, max_confidence, first_behavior, last_behavior.
	*/
	Filter *string

	/* Limit.

	   Number of ids to return.
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return ids.
	*/
	Offset *string

	/* Q.

	   Match phrase_prefix query criteria; included fields: _all (all filter string fields), sha256, state, paths.path, paths.state, hostname, username, date_updated, date_created.
	*/
	Q *string

	/* Sort.

	   Possible order by fields: hostname, username, date_updated, date_created, paths.path, state, paths.state. Ex: 'date_created|asc'.
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query quarantine files params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryQuarantineFilesParams) WithDefaults() *QueryQuarantineFilesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query quarantine files params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryQuarantineFilesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query quarantine files params
func (o *QueryQuarantineFilesParams) WithTimeout(timeout time.Duration) *QueryQuarantineFilesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query quarantine files params
func (o *QueryQuarantineFilesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query quarantine files params
func (o *QueryQuarantineFilesParams) WithContext(ctx context.Context) *QueryQuarantineFilesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query quarantine files params
func (o *QueryQuarantineFilesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query quarantine files params
func (o *QueryQuarantineFilesParams) WithHTTPClient(client *http.Client) *QueryQuarantineFilesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query quarantine files params
func (o *QueryQuarantineFilesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query quarantine files params
func (o *QueryQuarantineFilesParams) WithFilter(filter *string) *QueryQuarantineFilesParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query quarantine files params
func (o *QueryQuarantineFilesParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query quarantine files params
func (o *QueryQuarantineFilesParams) WithLimit(limit *int64) *QueryQuarantineFilesParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query quarantine files params
func (o *QueryQuarantineFilesParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query quarantine files params
func (o *QueryQuarantineFilesParams) WithOffset(offset *string) *QueryQuarantineFilesParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query quarantine files params
func (o *QueryQuarantineFilesParams) SetOffset(offset *string) {
	o.Offset = offset
}

// WithQ adds the q to the query quarantine files params
func (o *QueryQuarantineFilesParams) WithQ(q *string) *QueryQuarantineFilesParams {
	o.SetQ(q)
	return o
}

// SetQ adds the q to the query quarantine files params
func (o *QueryQuarantineFilesParams) SetQ(q *string) {
	o.Q = q
}

// WithSort adds the sort to the query quarantine files params
func (o *QueryQuarantineFilesParams) WithSort(sort *string) *QueryQuarantineFilesParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query quarantine files params
func (o *QueryQuarantineFilesParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryQuarantineFilesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Q != nil {

		// query param q
		var qrQ string

		if o.Q != nil {
			qrQ = *o.Q
		}
		qQ := qrQ
		if qQ != "" {

			if err := r.SetQueryParam("q", qQ); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
