// Code generated by go-swagger; DO NOT EDIT.

package quarantine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateQuarantinedDetectsByIdsReader is a Reader for the UpdateQuarantinedDetectsByIds structure.
type UpdateQuarantinedDetectsByIdsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateQuarantinedDetectsByIdsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateQuarantinedDetectsByIdsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewUpdateQuarantinedDetectsByIdsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateQuarantinedDetectsByIdsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /quarantine/entities/quarantined-files/v1] UpdateQuarantinedDetectsByIds", response, response.Code())
	}
}

// NewUpdateQuarantinedDetectsByIdsOK creates a UpdateQuarantinedDetectsByIdsOK with default headers values
func NewUpdateQuarantinedDetectsByIdsOK() *UpdateQuarantinedDetectsByIdsOK {
	return &UpdateQuarantinedDetectsByIdsOK{}
}

/*
UpdateQuarantinedDetectsByIdsOK describes a response with status code 200, with default header values.

OK
*/
type UpdateQuarantinedDetectsByIdsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update quarantined detects by ids o k response has a 2xx status code
func (o *UpdateQuarantinedDetectsByIdsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update quarantined detects by ids o k response has a 3xx status code
func (o *UpdateQuarantinedDetectsByIdsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update quarantined detects by ids o k response has a 4xx status code
func (o *UpdateQuarantinedDetectsByIdsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update quarantined detects by ids o k response has a 5xx status code
func (o *UpdateQuarantinedDetectsByIdsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update quarantined detects by ids o k response a status code equal to that given
func (o *UpdateQuarantinedDetectsByIdsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update quarantined detects by ids o k response
func (o *UpdateQuarantinedDetectsByIdsOK) Code() int {
	return 200
}

func (o *UpdateQuarantinedDetectsByIdsOK) Error() string {
	return fmt.Sprintf("[PATCH /quarantine/entities/quarantined-files/v1][%d] updateQuarantinedDetectsByIdsOK  %+v", 200, o.Payload)
}

func (o *UpdateQuarantinedDetectsByIdsOK) String() string {
	return fmt.Sprintf("[PATCH /quarantine/entities/quarantined-files/v1][%d] updateQuarantinedDetectsByIdsOK  %+v", 200, o.Payload)
}

func (o *UpdateQuarantinedDetectsByIdsOK) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateQuarantinedDetectsByIdsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateQuarantinedDetectsByIdsForbidden creates a UpdateQuarantinedDetectsByIdsForbidden with default headers values
func NewUpdateQuarantinedDetectsByIdsForbidden() *UpdateQuarantinedDetectsByIdsForbidden {
	return &UpdateQuarantinedDetectsByIdsForbidden{}
}

/*
UpdateQuarantinedDetectsByIdsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateQuarantinedDetectsByIdsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update quarantined detects by ids forbidden response has a 2xx status code
func (o *UpdateQuarantinedDetectsByIdsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update quarantined detects by ids forbidden response has a 3xx status code
func (o *UpdateQuarantinedDetectsByIdsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update quarantined detects by ids forbidden response has a 4xx status code
func (o *UpdateQuarantinedDetectsByIdsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update quarantined detects by ids forbidden response has a 5xx status code
func (o *UpdateQuarantinedDetectsByIdsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update quarantined detects by ids forbidden response a status code equal to that given
func (o *UpdateQuarantinedDetectsByIdsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update quarantined detects by ids forbidden response
func (o *UpdateQuarantinedDetectsByIdsForbidden) Code() int {
	return 403
}

func (o *UpdateQuarantinedDetectsByIdsForbidden) Error() string {
	return fmt.Sprintf("[PATCH /quarantine/entities/quarantined-files/v1][%d] updateQuarantinedDetectsByIdsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateQuarantinedDetectsByIdsForbidden) String() string {
	return fmt.Sprintf("[PATCH /quarantine/entities/quarantined-files/v1][%d] updateQuarantinedDetectsByIdsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateQuarantinedDetectsByIdsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateQuarantinedDetectsByIdsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateQuarantinedDetectsByIdsTooManyRequests creates a UpdateQuarantinedDetectsByIdsTooManyRequests with default headers values
func NewUpdateQuarantinedDetectsByIdsTooManyRequests() *UpdateQuarantinedDetectsByIdsTooManyRequests {
	return &UpdateQuarantinedDetectsByIdsTooManyRequests{}
}

/*
UpdateQuarantinedDetectsByIdsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateQuarantinedDetectsByIdsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update quarantined detects by ids too many requests response has a 2xx status code
func (o *UpdateQuarantinedDetectsByIdsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update quarantined detects by ids too many requests response has a 3xx status code
func (o *UpdateQuarantinedDetectsByIdsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update quarantined detects by ids too many requests response has a 4xx status code
func (o *UpdateQuarantinedDetectsByIdsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update quarantined detects by ids too many requests response has a 5xx status code
func (o *UpdateQuarantinedDetectsByIdsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update quarantined detects by ids too many requests response a status code equal to that given
func (o *UpdateQuarantinedDetectsByIdsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update quarantined detects by ids too many requests response
func (o *UpdateQuarantinedDetectsByIdsTooManyRequests) Code() int {
	return 429
}

func (o *UpdateQuarantinedDetectsByIdsTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /quarantine/entities/quarantined-files/v1][%d] updateQuarantinedDetectsByIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateQuarantinedDetectsByIdsTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /quarantine/entities/quarantined-files/v1][%d] updateQuarantinedDetectsByIdsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateQuarantinedDetectsByIdsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateQuarantinedDetectsByIdsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
