// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// BatchCmdReader is a Reader for the BatchCmd structure.
type BatchCmdReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BatchCmdReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewBatchCmdCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewBatchCmdBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewBatchCmdForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewBatchCmdTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewBatchCmdInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /real-time-response/combined/batch-command/v1] BatchCmd", response, response.Code())
	}
}

// NewBatchCmdCreated creates a BatchCmdCreated with default headers values
func NewBatchCmdCreated() *BatchCmdCreated {
	return &BatchCmdCreated{}
}

/*
BatchCmdCreated describes a response with status code 201, with default header values.

Created
*/
type BatchCmdCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainMultiCommandExecuteResponseWrapper
}

// IsSuccess returns true when this batch cmd created response has a 2xx status code
func (o *BatchCmdCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this batch cmd created response has a 3xx status code
func (o *BatchCmdCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch cmd created response has a 4xx status code
func (o *BatchCmdCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this batch cmd created response has a 5xx status code
func (o *BatchCmdCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this batch cmd created response a status code equal to that given
func (o *BatchCmdCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the batch cmd created response
func (o *BatchCmdCreated) Code() int {
	return 201
}

func (o *BatchCmdCreated) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-command/v1][%d] batchCmdCreated  %+v", 201, o.Payload)
}

func (o *BatchCmdCreated) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-command/v1][%d] batchCmdCreated  %+v", 201, o.Payload)
}

func (o *BatchCmdCreated) GetPayload() *models.DomainMultiCommandExecuteResponseWrapper {
	return o.Payload
}

func (o *BatchCmdCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainMultiCommandExecuteResponseWrapper)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchCmdBadRequest creates a BatchCmdBadRequest with default headers values
func NewBatchCmdBadRequest() *BatchCmdBadRequest {
	return &BatchCmdBadRequest{}
}

/*
BatchCmdBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type BatchCmdBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this batch cmd bad request response has a 2xx status code
func (o *BatchCmdBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch cmd bad request response has a 3xx status code
func (o *BatchCmdBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch cmd bad request response has a 4xx status code
func (o *BatchCmdBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch cmd bad request response has a 5xx status code
func (o *BatchCmdBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this batch cmd bad request response a status code equal to that given
func (o *BatchCmdBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the batch cmd bad request response
func (o *BatchCmdBadRequest) Code() int {
	return 400
}

func (o *BatchCmdBadRequest) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-command/v1][%d] batchCmdBadRequest  %+v", 400, o.Payload)
}

func (o *BatchCmdBadRequest) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-command/v1][%d] batchCmdBadRequest  %+v", 400, o.Payload)
}

func (o *BatchCmdBadRequest) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *BatchCmdBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchCmdForbidden creates a BatchCmdForbidden with default headers values
func NewBatchCmdForbidden() *BatchCmdForbidden {
	return &BatchCmdForbidden{}
}

/*
BatchCmdForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type BatchCmdForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this batch cmd forbidden response has a 2xx status code
func (o *BatchCmdForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch cmd forbidden response has a 3xx status code
func (o *BatchCmdForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch cmd forbidden response has a 4xx status code
func (o *BatchCmdForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch cmd forbidden response has a 5xx status code
func (o *BatchCmdForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this batch cmd forbidden response a status code equal to that given
func (o *BatchCmdForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the batch cmd forbidden response
func (o *BatchCmdForbidden) Code() int {
	return 403
}

func (o *BatchCmdForbidden) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-command/v1][%d] batchCmdForbidden  %+v", 403, o.Payload)
}

func (o *BatchCmdForbidden) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-command/v1][%d] batchCmdForbidden  %+v", 403, o.Payload)
}

func (o *BatchCmdForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *BatchCmdForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchCmdTooManyRequests creates a BatchCmdTooManyRequests with default headers values
func NewBatchCmdTooManyRequests() *BatchCmdTooManyRequests {
	return &BatchCmdTooManyRequests{}
}

/*
BatchCmdTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type BatchCmdTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this batch cmd too many requests response has a 2xx status code
func (o *BatchCmdTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch cmd too many requests response has a 3xx status code
func (o *BatchCmdTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch cmd too many requests response has a 4xx status code
func (o *BatchCmdTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch cmd too many requests response has a 5xx status code
func (o *BatchCmdTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this batch cmd too many requests response a status code equal to that given
func (o *BatchCmdTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the batch cmd too many requests response
func (o *BatchCmdTooManyRequests) Code() int {
	return 429
}

func (o *BatchCmdTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-command/v1][%d] batchCmdTooManyRequests  %+v", 429, o.Payload)
}

func (o *BatchCmdTooManyRequests) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-command/v1][%d] batchCmdTooManyRequests  %+v", 429, o.Payload)
}

func (o *BatchCmdTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *BatchCmdTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchCmdInternalServerError creates a BatchCmdInternalServerError with default headers values
func NewBatchCmdInternalServerError() *BatchCmdInternalServerError {
	return &BatchCmdInternalServerError{}
}

/*
BatchCmdInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type BatchCmdInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this batch cmd internal server error response has a 2xx status code
func (o *BatchCmdInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch cmd internal server error response has a 3xx status code
func (o *BatchCmdInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch cmd internal server error response has a 4xx status code
func (o *BatchCmdInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this batch cmd internal server error response has a 5xx status code
func (o *BatchCmdInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this batch cmd internal server error response a status code equal to that given
func (o *BatchCmdInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the batch cmd internal server error response
func (o *BatchCmdInternalServerError) Code() int {
	return 500
}

func (o *BatchCmdInternalServerError) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-command/v1][%d] batchCmdInternalServerError  %+v", 500, o.Payload)
}

func (o *BatchCmdInternalServerError) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-command/v1][%d] batchCmdInternalServerError  %+v", 500, o.Payload)
}

func (o *BatchCmdInternalServerError) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *BatchCmdInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
