// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewBatchGetCmdStatusParams creates a new BatchGetCmdStatusParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBatchGetCmdStatusParams() *BatchGetCmdStatusParams {
	return &BatchGetCmdStatusParams{
		requestTimeout: cr.DefaultTimeout,
	}
}

// NewBatchGetCmdStatusParamsWithTimeout creates a new BatchGetCmdStatusParams object
// with the ability to set a timeout on a request.
func NewBatchGetCmdStatusParamsWithTimeout(timeout time.Duration) *BatchGetCmdStatusParams {
	return &BatchGetCmdStatusParams{
		requestTimeout: timeout,
	}
}

// NewBatchGetCmdStatusParamsWithContext creates a new BatchGetCmdStatusParams object
// with the ability to set a context for a request.
func NewBatchGetCmdStatusParamsWithContext(ctx context.Context) *BatchGetCmdStatusParams {
	return &BatchGetCmdStatusParams{
		Context: ctx,
	}
}

// NewBatchGetCmdStatusParamsWithHTTPClient creates a new BatchGetCmdStatusParams object
// with the ability to set a custom HTTPClient for a request.
func NewBatchGetCmdStatusParamsWithHTTPClient(client *http.Client) *BatchGetCmdStatusParams {
	return &BatchGetCmdStatusParams{
		HTTPClient: client,
	}
}

/*
BatchGetCmdStatusParams contains all the parameters to send to the API endpoint

	for the batch get cmd status operation.

	Typically these are written to a http.Request.
*/
type BatchGetCmdStatusParams struct {

	/* BatchGetCmdReqID.

	   Batch Get Command Request ID received from `/real-time-response/combined/get-command/v1`
	*/
	BatchGetCmdReqID string

	/* Timeout.

	   Timeout for how long to wait for the request in seconds, default timeout is 30 seconds. Maximum is 5 minutes.

	   Default: 30
	*/
	Timeout *int64

	/* TimeoutDuration.

	   Timeout duration for how long to wait for the request in duration syntax. Example, `10s`. Valid units: `ns, us, ms, s, m, h`. Maximum is 5 minutes.

	   Default: "30s"
	*/
	TimeoutDuration *string

	requestTimeout time.Duration
	Context        context.Context
	HTTPClient     *http.Client
}

// WithDefaults hydrates default values in the batch get cmd status params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BatchGetCmdStatusParams) WithDefaults() *BatchGetCmdStatusParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the batch get cmd status params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BatchGetCmdStatusParams) SetDefaults() {
	var (
		timeoutDefault = int64(30)

		timeoutDurationDefault = string("30s")
	)

	val := BatchGetCmdStatusParams{
		Timeout:         &timeoutDefault,
		TimeoutDuration: &timeoutDurationDefault,
	}

	val.requestTimeout = o.requestTimeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithRequestTimeout adds the timeout to the batch get cmd status params
func (o *BatchGetCmdStatusParams) WithRequestTimeout(timeout time.Duration) *BatchGetCmdStatusParams {
	o.SetRequestTimeout(timeout)
	return o
}

// SetRequestTimeout adds the timeout to the batch get cmd status params
func (o *BatchGetCmdStatusParams) SetRequestTimeout(timeout time.Duration) {
	o.requestTimeout = timeout
}

// WithContext adds the context to the batch get cmd status params
func (o *BatchGetCmdStatusParams) WithContext(ctx context.Context) *BatchGetCmdStatusParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the batch get cmd status params
func (o *BatchGetCmdStatusParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the batch get cmd status params
func (o *BatchGetCmdStatusParams) WithHTTPClient(client *http.Client) *BatchGetCmdStatusParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the batch get cmd status params
func (o *BatchGetCmdStatusParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBatchGetCmdReqID adds the batchGetCmdReqID to the batch get cmd status params
func (o *BatchGetCmdStatusParams) WithBatchGetCmdReqID(batchGetCmdReqID string) *BatchGetCmdStatusParams {
	o.SetBatchGetCmdReqID(batchGetCmdReqID)
	return o
}

// SetBatchGetCmdReqID adds the batchGetCmdReqId to the batch get cmd status params
func (o *BatchGetCmdStatusParams) SetBatchGetCmdReqID(batchGetCmdReqID string) {
	o.BatchGetCmdReqID = batchGetCmdReqID
}

// WithTimeout adds the timeout to the batch get cmd status params
func (o *BatchGetCmdStatusParams) WithTimeout(timeout *int64) *BatchGetCmdStatusParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the batch get cmd status params
func (o *BatchGetCmdStatusParams) SetTimeout(timeout *int64) {
	o.Timeout = timeout
}

// WithTimeoutDuration adds the timeoutDuration to the batch get cmd status params
func (o *BatchGetCmdStatusParams) WithTimeoutDuration(timeoutDuration *string) *BatchGetCmdStatusParams {
	o.SetTimeoutDuration(timeoutDuration)
	return o
}

// SetTimeoutDuration adds the timeoutDuration to the batch get cmd status params
func (o *BatchGetCmdStatusParams) SetTimeoutDuration(timeoutDuration *string) {
	o.TimeoutDuration = timeoutDuration
}

// WriteToRequest writes these params to a swagger request
func (o *BatchGetCmdStatusParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.requestTimeout); err != nil {
		return err
	}
	var res []error

	// query param batch_get_cmd_req_id
	qrBatchGetCmdReqID := o.BatchGetCmdReqID
	qBatchGetCmdReqID := qrBatchGetCmdReqID
	if qBatchGetCmdReqID != "" {

		if err := r.SetQueryParam("batch_get_cmd_req_id", qBatchGetCmdReqID); err != nil {
			return err
		}
	}

	if o.Timeout != nil {

		// query param timeout
		var qrTimeout int64

		if o.Timeout != nil {
			qrTimeout = *o.Timeout
		}
		qTimeout := swag.FormatInt64(qrTimeout)
		if qTimeout != "" {

			if err := r.SetQueryParam("timeout", qTimeout); err != nil {
				return err
			}
		}
	}

	if o.TimeoutDuration != nil {

		// query param timeout_duration
		var qrTimeoutDuration string

		if o.TimeoutDuration != nil {
			qrTimeoutDuration = *o.TimeoutDuration
		}
		qTimeoutDuration := qrTimeoutDuration
		if qTimeoutDuration != "" {

			if err := r.SetQueryParam("timeout_duration", qTimeoutDuration); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
