// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// BatchInitSessionsReader is a Reader for the BatchInitSessions structure.
type BatchInitSessionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BatchInitSessionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewBatchInitSessionsCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewBatchInitSessionsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewBatchInitSessionsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewBatchInitSessionsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewBatchInitSessionsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /real-time-response/combined/batch-init-session/v1] BatchInitSessions", response, response.Code())
	}
}

// NewBatchInitSessionsCreated creates a BatchInitSessionsCreated with default headers values
func NewBatchInitSessionsCreated() *BatchInitSessionsCreated {
	return &BatchInitSessionsCreated{}
}

/*
BatchInitSessionsCreated describes a response with status code 201, with default header values.

Created
*/
type BatchInitSessionsCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainBatchInitSessionResponse
}

// IsSuccess returns true when this batch init sessions created response has a 2xx status code
func (o *BatchInitSessionsCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this batch init sessions created response has a 3xx status code
func (o *BatchInitSessionsCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch init sessions created response has a 4xx status code
func (o *BatchInitSessionsCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this batch init sessions created response has a 5xx status code
func (o *BatchInitSessionsCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this batch init sessions created response a status code equal to that given
func (o *BatchInitSessionsCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the batch init sessions created response
func (o *BatchInitSessionsCreated) Code() int {
	return 201
}

func (o *BatchInitSessionsCreated) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-init-session/v1][%d] batchInitSessionsCreated  %+v", 201, o.Payload)
}

func (o *BatchInitSessionsCreated) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-init-session/v1][%d] batchInitSessionsCreated  %+v", 201, o.Payload)
}

func (o *BatchInitSessionsCreated) GetPayload() *models.DomainBatchInitSessionResponse {
	return o.Payload
}

func (o *BatchInitSessionsCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainBatchInitSessionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchInitSessionsBadRequest creates a BatchInitSessionsBadRequest with default headers values
func NewBatchInitSessionsBadRequest() *BatchInitSessionsBadRequest {
	return &BatchInitSessionsBadRequest{}
}

/*
BatchInitSessionsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type BatchInitSessionsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this batch init sessions bad request response has a 2xx status code
func (o *BatchInitSessionsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch init sessions bad request response has a 3xx status code
func (o *BatchInitSessionsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch init sessions bad request response has a 4xx status code
func (o *BatchInitSessionsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch init sessions bad request response has a 5xx status code
func (o *BatchInitSessionsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this batch init sessions bad request response a status code equal to that given
func (o *BatchInitSessionsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the batch init sessions bad request response
func (o *BatchInitSessionsBadRequest) Code() int {
	return 400
}

func (o *BatchInitSessionsBadRequest) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-init-session/v1][%d] batchInitSessionsBadRequest  %+v", 400, o.Payload)
}

func (o *BatchInitSessionsBadRequest) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-init-session/v1][%d] batchInitSessionsBadRequest  %+v", 400, o.Payload)
}

func (o *BatchInitSessionsBadRequest) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *BatchInitSessionsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchInitSessionsForbidden creates a BatchInitSessionsForbidden with default headers values
func NewBatchInitSessionsForbidden() *BatchInitSessionsForbidden {
	return &BatchInitSessionsForbidden{}
}

/*
BatchInitSessionsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type BatchInitSessionsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this batch init sessions forbidden response has a 2xx status code
func (o *BatchInitSessionsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch init sessions forbidden response has a 3xx status code
func (o *BatchInitSessionsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch init sessions forbidden response has a 4xx status code
func (o *BatchInitSessionsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch init sessions forbidden response has a 5xx status code
func (o *BatchInitSessionsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this batch init sessions forbidden response a status code equal to that given
func (o *BatchInitSessionsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the batch init sessions forbidden response
func (o *BatchInitSessionsForbidden) Code() int {
	return 403
}

func (o *BatchInitSessionsForbidden) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-init-session/v1][%d] batchInitSessionsForbidden  %+v", 403, o.Payload)
}

func (o *BatchInitSessionsForbidden) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-init-session/v1][%d] batchInitSessionsForbidden  %+v", 403, o.Payload)
}

func (o *BatchInitSessionsForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *BatchInitSessionsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchInitSessionsTooManyRequests creates a BatchInitSessionsTooManyRequests with default headers values
func NewBatchInitSessionsTooManyRequests() *BatchInitSessionsTooManyRequests {
	return &BatchInitSessionsTooManyRequests{}
}

/*
BatchInitSessionsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type BatchInitSessionsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this batch init sessions too many requests response has a 2xx status code
func (o *BatchInitSessionsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch init sessions too many requests response has a 3xx status code
func (o *BatchInitSessionsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch init sessions too many requests response has a 4xx status code
func (o *BatchInitSessionsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch init sessions too many requests response has a 5xx status code
func (o *BatchInitSessionsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this batch init sessions too many requests response a status code equal to that given
func (o *BatchInitSessionsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the batch init sessions too many requests response
func (o *BatchInitSessionsTooManyRequests) Code() int {
	return 429
}

func (o *BatchInitSessionsTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-init-session/v1][%d] batchInitSessionsTooManyRequests  %+v", 429, o.Payload)
}

func (o *BatchInitSessionsTooManyRequests) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-init-session/v1][%d] batchInitSessionsTooManyRequests  %+v", 429, o.Payload)
}

func (o *BatchInitSessionsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *BatchInitSessionsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchInitSessionsInternalServerError creates a BatchInitSessionsInternalServerError with default headers values
func NewBatchInitSessionsInternalServerError() *BatchInitSessionsInternalServerError {
	return &BatchInitSessionsInternalServerError{}
}

/*
BatchInitSessionsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type BatchInitSessionsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this batch init sessions internal server error response has a 2xx status code
func (o *BatchInitSessionsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch init sessions internal server error response has a 3xx status code
func (o *BatchInitSessionsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch init sessions internal server error response has a 4xx status code
func (o *BatchInitSessionsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this batch init sessions internal server error response has a 5xx status code
func (o *BatchInitSessionsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this batch init sessions internal server error response a status code equal to that given
func (o *BatchInitSessionsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the batch init sessions internal server error response
func (o *BatchInitSessionsInternalServerError) Code() int {
	return 500
}

func (o *BatchInitSessionsInternalServerError) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-init-session/v1][%d] batchInitSessionsInternalServerError  %+v", 500, o.Payload)
}

func (o *BatchInitSessionsInternalServerError) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-init-session/v1][%d] batchInitSessionsInternalServerError  %+v", 500, o.Payload)
}

func (o *BatchInitSessionsInternalServerError) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *BatchInitSessionsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
