// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// BatchRefreshSessionsReader is a Reader for the BatchRefreshSessions structure.
type BatchRefreshSessionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BatchRefreshSessionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewBatchRefreshSessionsCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewBatchRefreshSessionsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewBatchRefreshSessionsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewBatchRefreshSessionsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewBatchRefreshSessionsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /real-time-response/combined/batch-refresh-session/v1] BatchRefreshSessions", response, response.Code())
	}
}

// NewBatchRefreshSessionsCreated creates a BatchRefreshSessionsCreated with default headers values
func NewBatchRefreshSessionsCreated() *BatchRefreshSessionsCreated {
	return &BatchRefreshSessionsCreated{}
}

/*
BatchRefreshSessionsCreated describes a response with status code 201, with default header values.

Created
*/
type BatchRefreshSessionsCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainBatchRefreshSessionResponse
}

// IsSuccess returns true when this batch refresh sessions created response has a 2xx status code
func (o *BatchRefreshSessionsCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this batch refresh sessions created response has a 3xx status code
func (o *BatchRefreshSessionsCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch refresh sessions created response has a 4xx status code
func (o *BatchRefreshSessionsCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this batch refresh sessions created response has a 5xx status code
func (o *BatchRefreshSessionsCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this batch refresh sessions created response a status code equal to that given
func (o *BatchRefreshSessionsCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the batch refresh sessions created response
func (o *BatchRefreshSessionsCreated) Code() int {
	return 201
}

func (o *BatchRefreshSessionsCreated) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-refresh-session/v1][%d] batchRefreshSessionsCreated  %+v", 201, o.Payload)
}

func (o *BatchRefreshSessionsCreated) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-refresh-session/v1][%d] batchRefreshSessionsCreated  %+v", 201, o.Payload)
}

func (o *BatchRefreshSessionsCreated) GetPayload() *models.DomainBatchRefreshSessionResponse {
	return o.Payload
}

func (o *BatchRefreshSessionsCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainBatchRefreshSessionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchRefreshSessionsBadRequest creates a BatchRefreshSessionsBadRequest with default headers values
func NewBatchRefreshSessionsBadRequest() *BatchRefreshSessionsBadRequest {
	return &BatchRefreshSessionsBadRequest{}
}

/*
BatchRefreshSessionsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type BatchRefreshSessionsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this batch refresh sessions bad request response has a 2xx status code
func (o *BatchRefreshSessionsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch refresh sessions bad request response has a 3xx status code
func (o *BatchRefreshSessionsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch refresh sessions bad request response has a 4xx status code
func (o *BatchRefreshSessionsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch refresh sessions bad request response has a 5xx status code
func (o *BatchRefreshSessionsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this batch refresh sessions bad request response a status code equal to that given
func (o *BatchRefreshSessionsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the batch refresh sessions bad request response
func (o *BatchRefreshSessionsBadRequest) Code() int {
	return 400
}

func (o *BatchRefreshSessionsBadRequest) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-refresh-session/v1][%d] batchRefreshSessionsBadRequest  %+v", 400, o.Payload)
}

func (o *BatchRefreshSessionsBadRequest) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-refresh-session/v1][%d] batchRefreshSessionsBadRequest  %+v", 400, o.Payload)
}

func (o *BatchRefreshSessionsBadRequest) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *BatchRefreshSessionsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchRefreshSessionsForbidden creates a BatchRefreshSessionsForbidden with default headers values
func NewBatchRefreshSessionsForbidden() *BatchRefreshSessionsForbidden {
	return &BatchRefreshSessionsForbidden{}
}

/*
BatchRefreshSessionsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type BatchRefreshSessionsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this batch refresh sessions forbidden response has a 2xx status code
func (o *BatchRefreshSessionsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch refresh sessions forbidden response has a 3xx status code
func (o *BatchRefreshSessionsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch refresh sessions forbidden response has a 4xx status code
func (o *BatchRefreshSessionsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch refresh sessions forbidden response has a 5xx status code
func (o *BatchRefreshSessionsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this batch refresh sessions forbidden response a status code equal to that given
func (o *BatchRefreshSessionsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the batch refresh sessions forbidden response
func (o *BatchRefreshSessionsForbidden) Code() int {
	return 403
}

func (o *BatchRefreshSessionsForbidden) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-refresh-session/v1][%d] batchRefreshSessionsForbidden  %+v", 403, o.Payload)
}

func (o *BatchRefreshSessionsForbidden) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-refresh-session/v1][%d] batchRefreshSessionsForbidden  %+v", 403, o.Payload)
}

func (o *BatchRefreshSessionsForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *BatchRefreshSessionsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchRefreshSessionsTooManyRequests creates a BatchRefreshSessionsTooManyRequests with default headers values
func NewBatchRefreshSessionsTooManyRequests() *BatchRefreshSessionsTooManyRequests {
	return &BatchRefreshSessionsTooManyRequests{}
}

/*
BatchRefreshSessionsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type BatchRefreshSessionsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this batch refresh sessions too many requests response has a 2xx status code
func (o *BatchRefreshSessionsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch refresh sessions too many requests response has a 3xx status code
func (o *BatchRefreshSessionsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch refresh sessions too many requests response has a 4xx status code
func (o *BatchRefreshSessionsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch refresh sessions too many requests response has a 5xx status code
func (o *BatchRefreshSessionsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this batch refresh sessions too many requests response a status code equal to that given
func (o *BatchRefreshSessionsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the batch refresh sessions too many requests response
func (o *BatchRefreshSessionsTooManyRequests) Code() int {
	return 429
}

func (o *BatchRefreshSessionsTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-refresh-session/v1][%d] batchRefreshSessionsTooManyRequests  %+v", 429, o.Payload)
}

func (o *BatchRefreshSessionsTooManyRequests) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-refresh-session/v1][%d] batchRefreshSessionsTooManyRequests  %+v", 429, o.Payload)
}

func (o *BatchRefreshSessionsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *BatchRefreshSessionsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchRefreshSessionsInternalServerError creates a BatchRefreshSessionsInternalServerError with default headers values
func NewBatchRefreshSessionsInternalServerError() *BatchRefreshSessionsInternalServerError {
	return &BatchRefreshSessionsInternalServerError{}
}

/*
BatchRefreshSessionsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type BatchRefreshSessionsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this batch refresh sessions internal server error response has a 2xx status code
func (o *BatchRefreshSessionsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch refresh sessions internal server error response has a 3xx status code
func (o *BatchRefreshSessionsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch refresh sessions internal server error response has a 4xx status code
func (o *BatchRefreshSessionsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this batch refresh sessions internal server error response has a 5xx status code
func (o *BatchRefreshSessionsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this batch refresh sessions internal server error response a status code equal to that given
func (o *BatchRefreshSessionsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the batch refresh sessions internal server error response
func (o *BatchRefreshSessionsInternalServerError) Code() int {
	return 500
}

func (o *BatchRefreshSessionsInternalServerError) Error() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-refresh-session/v1][%d] batchRefreshSessionsInternalServerError  %+v", 500, o.Payload)
}

func (o *BatchRefreshSessionsInternalServerError) String() string {
	return fmt.Sprintf("[POST /real-time-response/combined/batch-refresh-session/v1][%d] batchRefreshSessionsInternalServerError  %+v", 500, o.Payload)
}

func (o *BatchRefreshSessionsInternalServerError) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *BatchRefreshSessionsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
