// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewRTRCheckActiveResponderCommandStatusParams creates a new RTRCheckActiveResponderCommandStatusParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRTRCheckActiveResponderCommandStatusParams() *RTRCheckActiveResponderCommandStatusParams {
	return &RTRCheckActiveResponderCommandStatusParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRTRCheckActiveResponderCommandStatusParamsWithTimeout creates a new RTRCheckActiveResponderCommandStatusParams object
// with the ability to set a timeout on a request.
func NewRTRCheckActiveResponderCommandStatusParamsWithTimeout(timeout time.Duration) *RTRCheckActiveResponderCommandStatusParams {
	return &RTRCheckActiveResponderCommandStatusParams{
		timeout: timeout,
	}
}

// NewRTRCheckActiveResponderCommandStatusParamsWithContext creates a new RTRCheckActiveResponderCommandStatusParams object
// with the ability to set a context for a request.
func NewRTRCheckActiveResponderCommandStatusParamsWithContext(ctx context.Context) *RTRCheckActiveResponderCommandStatusParams {
	return &RTRCheckActiveResponderCommandStatusParams{
		Context: ctx,
	}
}

// NewRTRCheckActiveResponderCommandStatusParamsWithHTTPClient creates a new RTRCheckActiveResponderCommandStatusParams object
// with the ability to set a custom HTTPClient for a request.
func NewRTRCheckActiveResponderCommandStatusParamsWithHTTPClient(client *http.Client) *RTRCheckActiveResponderCommandStatusParams {
	return &RTRCheckActiveResponderCommandStatusParams{
		HTTPClient: client,
	}
}

/*
RTRCheckActiveResponderCommandStatusParams contains all the parameters to send to the API endpoint

	for the r t r check active responder command status operation.

	Typically these are written to a http.Request.
*/
type RTRCheckActiveResponderCommandStatusParams struct {

	/* CloudRequestID.

	   Cloud Request ID of the executed command to query
	*/
	CloudRequestID string

	/* SequenceID.

	   Sequence ID that we want to retrieve. Command responses are chunked across sequences
	*/
	SequenceID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the r t r check active responder command status params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRCheckActiveResponderCommandStatusParams) WithDefaults() *RTRCheckActiveResponderCommandStatusParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the r t r check active responder command status params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRCheckActiveResponderCommandStatusParams) SetDefaults() {
	var (
		sequenceIDDefault = int64(0)
	)

	val := RTRCheckActiveResponderCommandStatusParams{
		SequenceID: sequenceIDDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the r t r check active responder command status params
func (o *RTRCheckActiveResponderCommandStatusParams) WithTimeout(timeout time.Duration) *RTRCheckActiveResponderCommandStatusParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the r t r check active responder command status params
func (o *RTRCheckActiveResponderCommandStatusParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the r t r check active responder command status params
func (o *RTRCheckActiveResponderCommandStatusParams) WithContext(ctx context.Context) *RTRCheckActiveResponderCommandStatusParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the r t r check active responder command status params
func (o *RTRCheckActiveResponderCommandStatusParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the r t r check active responder command status params
func (o *RTRCheckActiveResponderCommandStatusParams) WithHTTPClient(client *http.Client) *RTRCheckActiveResponderCommandStatusParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the r t r check active responder command status params
func (o *RTRCheckActiveResponderCommandStatusParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCloudRequestID adds the cloudRequestID to the r t r check active responder command status params
func (o *RTRCheckActiveResponderCommandStatusParams) WithCloudRequestID(cloudRequestID string) *RTRCheckActiveResponderCommandStatusParams {
	o.SetCloudRequestID(cloudRequestID)
	return o
}

// SetCloudRequestID adds the cloudRequestId to the r t r check active responder command status params
func (o *RTRCheckActiveResponderCommandStatusParams) SetCloudRequestID(cloudRequestID string) {
	o.CloudRequestID = cloudRequestID
}

// WithSequenceID adds the sequenceID to the r t r check active responder command status params
func (o *RTRCheckActiveResponderCommandStatusParams) WithSequenceID(sequenceID int64) *RTRCheckActiveResponderCommandStatusParams {
	o.SetSequenceID(sequenceID)
	return o
}

// SetSequenceID adds the sequenceId to the r t r check active responder command status params
func (o *RTRCheckActiveResponderCommandStatusParams) SetSequenceID(sequenceID int64) {
	o.SequenceID = sequenceID
}

// WriteToRequest writes these params to a swagger request
func (o *RTRCheckActiveResponderCommandStatusParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param cloud_request_id
	qrCloudRequestID := o.CloudRequestID
	qCloudRequestID := qrCloudRequestID
	if qCloudRequestID != "" {

		if err := r.SetQueryParam("cloud_request_id", qCloudRequestID); err != nil {
			return err
		}
	}

	// query param sequence_id
	qrSequenceID := o.SequenceID
	qSequenceID := swag.FormatInt64(qrSequenceID)
	if qSequenceID != "" {

		if err := r.SetQueryParam("sequence_id", qSequenceID); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
