// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// RTRCheckActiveResponderCommandStatusReader is a Reader for the RTRCheckActiveResponderCommandStatus structure.
type RTRCheckActiveResponderCommandStatusReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RTRCheckActiveResponderCommandStatusReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRTRCheckActiveResponderCommandStatusOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewRTRCheckActiveResponderCommandStatusUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRTRCheckActiveResponderCommandStatusForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewRTRCheckActiveResponderCommandStatusTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /real-time-response/entities/active-responder-command/v1] RTR-CheckActiveResponderCommandStatus", response, response.Code())
	}
}

// NewRTRCheckActiveResponderCommandStatusOK creates a RTRCheckActiveResponderCommandStatusOK with default headers values
func NewRTRCheckActiveResponderCommandStatusOK() *RTRCheckActiveResponderCommandStatusOK {
	return &RTRCheckActiveResponderCommandStatusOK{}
}

/*
RTRCheckActiveResponderCommandStatusOK describes a response with status code 200, with default header values.

success
*/
type RTRCheckActiveResponderCommandStatusOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainStatusResponseWrapper
}

// IsSuccess returns true when this r t r check active responder command status o k response has a 2xx status code
func (o *RTRCheckActiveResponderCommandStatusOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this r t r check active responder command status o k response has a 3xx status code
func (o *RTRCheckActiveResponderCommandStatusOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r check active responder command status o k response has a 4xx status code
func (o *RTRCheckActiveResponderCommandStatusOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this r t r check active responder command status o k response has a 5xx status code
func (o *RTRCheckActiveResponderCommandStatusOK) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r check active responder command status o k response a status code equal to that given
func (o *RTRCheckActiveResponderCommandStatusOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the r t r check active responder command status o k response
func (o *RTRCheckActiveResponderCommandStatusOK) Code() int {
	return 200
}

func (o *RTRCheckActiveResponderCommandStatusOK) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/active-responder-command/v1][%d] rTRCheckActiveResponderCommandStatusOK  %+v", 200, o.Payload)
}

func (o *RTRCheckActiveResponderCommandStatusOK) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/active-responder-command/v1][%d] rTRCheckActiveResponderCommandStatusOK  %+v", 200, o.Payload)
}

func (o *RTRCheckActiveResponderCommandStatusOK) GetPayload() *models.DomainStatusResponseWrapper {
	return o.Payload
}

func (o *RTRCheckActiveResponderCommandStatusOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainStatusResponseWrapper)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRCheckActiveResponderCommandStatusUnauthorized creates a RTRCheckActiveResponderCommandStatusUnauthorized with default headers values
func NewRTRCheckActiveResponderCommandStatusUnauthorized() *RTRCheckActiveResponderCommandStatusUnauthorized {
	return &RTRCheckActiveResponderCommandStatusUnauthorized{}
}

/*
RTRCheckActiveResponderCommandStatusUnauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type RTRCheckActiveResponderCommandStatusUnauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this r t r check active responder command status unauthorized response has a 2xx status code
func (o *RTRCheckActiveResponderCommandStatusUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r check active responder command status unauthorized response has a 3xx status code
func (o *RTRCheckActiveResponderCommandStatusUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r check active responder command status unauthorized response has a 4xx status code
func (o *RTRCheckActiveResponderCommandStatusUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r check active responder command status unauthorized response has a 5xx status code
func (o *RTRCheckActiveResponderCommandStatusUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r check active responder command status unauthorized response a status code equal to that given
func (o *RTRCheckActiveResponderCommandStatusUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the r t r check active responder command status unauthorized response
func (o *RTRCheckActiveResponderCommandStatusUnauthorized) Code() int {
	return 401
}

func (o *RTRCheckActiveResponderCommandStatusUnauthorized) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/active-responder-command/v1][%d] rTRCheckActiveResponderCommandStatusUnauthorized  %+v", 401, o.Payload)
}

func (o *RTRCheckActiveResponderCommandStatusUnauthorized) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/active-responder-command/v1][%d] rTRCheckActiveResponderCommandStatusUnauthorized  %+v", 401, o.Payload)
}

func (o *RTRCheckActiveResponderCommandStatusUnauthorized) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *RTRCheckActiveResponderCommandStatusUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRCheckActiveResponderCommandStatusForbidden creates a RTRCheckActiveResponderCommandStatusForbidden with default headers values
func NewRTRCheckActiveResponderCommandStatusForbidden() *RTRCheckActiveResponderCommandStatusForbidden {
	return &RTRCheckActiveResponderCommandStatusForbidden{}
}

/*
RTRCheckActiveResponderCommandStatusForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RTRCheckActiveResponderCommandStatusForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r check active responder command status forbidden response has a 2xx status code
func (o *RTRCheckActiveResponderCommandStatusForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r check active responder command status forbidden response has a 3xx status code
func (o *RTRCheckActiveResponderCommandStatusForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r check active responder command status forbidden response has a 4xx status code
func (o *RTRCheckActiveResponderCommandStatusForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r check active responder command status forbidden response has a 5xx status code
func (o *RTRCheckActiveResponderCommandStatusForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r check active responder command status forbidden response a status code equal to that given
func (o *RTRCheckActiveResponderCommandStatusForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the r t r check active responder command status forbidden response
func (o *RTRCheckActiveResponderCommandStatusForbidden) Code() int {
	return 403
}

func (o *RTRCheckActiveResponderCommandStatusForbidden) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/active-responder-command/v1][%d] rTRCheckActiveResponderCommandStatusForbidden  %+v", 403, o.Payload)
}

func (o *RTRCheckActiveResponderCommandStatusForbidden) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/active-responder-command/v1][%d] rTRCheckActiveResponderCommandStatusForbidden  %+v", 403, o.Payload)
}

func (o *RTRCheckActiveResponderCommandStatusForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRCheckActiveResponderCommandStatusForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRCheckActiveResponderCommandStatusTooManyRequests creates a RTRCheckActiveResponderCommandStatusTooManyRequests with default headers values
func NewRTRCheckActiveResponderCommandStatusTooManyRequests() *RTRCheckActiveResponderCommandStatusTooManyRequests {
	return &RTRCheckActiveResponderCommandStatusTooManyRequests{}
}

/*
RTRCheckActiveResponderCommandStatusTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type RTRCheckActiveResponderCommandStatusTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r check active responder command status too many requests response has a 2xx status code
func (o *RTRCheckActiveResponderCommandStatusTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r check active responder command status too many requests response has a 3xx status code
func (o *RTRCheckActiveResponderCommandStatusTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r check active responder command status too many requests response has a 4xx status code
func (o *RTRCheckActiveResponderCommandStatusTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r check active responder command status too many requests response has a 5xx status code
func (o *RTRCheckActiveResponderCommandStatusTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r check active responder command status too many requests response a status code equal to that given
func (o *RTRCheckActiveResponderCommandStatusTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the r t r check active responder command status too many requests response
func (o *RTRCheckActiveResponderCommandStatusTooManyRequests) Code() int {
	return 429
}

func (o *RTRCheckActiveResponderCommandStatusTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/active-responder-command/v1][%d] rTRCheckActiveResponderCommandStatusTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRCheckActiveResponderCommandStatusTooManyRequests) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/active-responder-command/v1][%d] rTRCheckActiveResponderCommandStatusTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRCheckActiveResponderCommandStatusTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRCheckActiveResponderCommandStatusTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
