// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewRTRDeleteFileParams creates a new RTRDeleteFileParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRTRDeleteFileParams() *RTRDeleteFileParams {
	return &RTRDeleteFileParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRTRDeleteFileParamsWithTimeout creates a new RTRDeleteFileParams object
// with the ability to set a timeout on a request.
func NewRTRDeleteFileParamsWithTimeout(timeout time.Duration) *RTRDeleteFileParams {
	return &RTRDeleteFileParams{
		timeout: timeout,
	}
}

// NewRTRDeleteFileParamsWithContext creates a new RTRDeleteFileParams object
// with the ability to set a context for a request.
func NewRTRDeleteFileParamsWithContext(ctx context.Context) *RTRDeleteFileParams {
	return &RTRDeleteFileParams{
		Context: ctx,
	}
}

// NewRTRDeleteFileParamsWithHTTPClient creates a new RTRDeleteFileParams object
// with the ability to set a custom HTTPClient for a request.
func NewRTRDeleteFileParamsWithHTTPClient(client *http.Client) *RTRDeleteFileParams {
	return &RTRDeleteFileParams{
		HTTPClient: client,
	}
}

/*
RTRDeleteFileParams contains all the parameters to send to the API endpoint

	for the r t r delete file operation.

	Typically these are written to a http.Request.
*/
type RTRDeleteFileParams struct {

	/* Ids.

	   RTR Session file id
	*/
	Ids string

	/* SessionID.

	   RTR Session id
	*/
	SessionID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the r t r delete file params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRDeleteFileParams) WithDefaults() *RTRDeleteFileParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the r t r delete file params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRDeleteFileParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the r t r delete file params
func (o *RTRDeleteFileParams) WithTimeout(timeout time.Duration) *RTRDeleteFileParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the r t r delete file params
func (o *RTRDeleteFileParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the r t r delete file params
func (o *RTRDeleteFileParams) WithContext(ctx context.Context) *RTRDeleteFileParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the r t r delete file params
func (o *RTRDeleteFileParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the r t r delete file params
func (o *RTRDeleteFileParams) WithHTTPClient(client *http.Client) *RTRDeleteFileParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the r t r delete file params
func (o *RTRDeleteFileParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the r t r delete file params
func (o *RTRDeleteFileParams) WithIds(ids string) *RTRDeleteFileParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the r t r delete file params
func (o *RTRDeleteFileParams) SetIds(ids string) {
	o.Ids = ids
}

// WithSessionID adds the sessionID to the r t r delete file params
func (o *RTRDeleteFileParams) WithSessionID(sessionID string) *RTRDeleteFileParams {
	o.SetSessionID(sessionID)
	return o
}

// SetSessionID adds the sessionId to the r t r delete file params
func (o *RTRDeleteFileParams) SetSessionID(sessionID string) {
	o.SessionID = sessionID
}

// WriteToRequest writes these params to a swagger request
func (o *RTRDeleteFileParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param ids
	qrIds := o.Ids
	qIds := qrIds
	if qIds != "" {

		if err := r.SetQueryParam("ids", qIds); err != nil {
			return err
		}
	}

	// query param session_id
	qrSessionID := o.SessionID
	qSessionID := qrSessionID
	if qSessionID != "" {

		if err := r.SetQueryParam("session_id", qSessionID); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
