// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewRTRDeleteFileV2Params creates a new RTRDeleteFileV2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRTRDeleteFileV2Params() *RTRDeleteFileV2Params {
	return &RTRDeleteFileV2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewRTRDeleteFileV2ParamsWithTimeout creates a new RTRDeleteFileV2Params object
// with the ability to set a timeout on a request.
func NewRTRDeleteFileV2ParamsWithTimeout(timeout time.Duration) *RTRDeleteFileV2Params {
	return &RTRDeleteFileV2Params{
		timeout: timeout,
	}
}

// NewRTRDeleteFileV2ParamsWithContext creates a new RTRDeleteFileV2Params object
// with the ability to set a context for a request.
func NewRTRDeleteFileV2ParamsWithContext(ctx context.Context) *RTRDeleteFileV2Params {
	return &RTRDeleteFileV2Params{
		Context: ctx,
	}
}

// NewRTRDeleteFileV2ParamsWithHTTPClient creates a new RTRDeleteFileV2Params object
// with the ability to set a custom HTTPClient for a request.
func NewRTRDeleteFileV2ParamsWithHTTPClient(client *http.Client) *RTRDeleteFileV2Params {
	return &RTRDeleteFileV2Params{
		HTTPClient: client,
	}
}

/*
RTRDeleteFileV2Params contains all the parameters to send to the API endpoint

	for the r t r delete file v2 operation.

	Typically these are written to a http.Request.
*/
type RTRDeleteFileV2Params struct {

	/* Ids.

	   RTR Session file id
	*/
	Ids string

	/* SessionID.

	   RTR Session id
	*/
	SessionID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the r t r delete file v2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRDeleteFileV2Params) WithDefaults() *RTRDeleteFileV2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the r t r delete file v2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRDeleteFileV2Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the r t r delete file v2 params
func (o *RTRDeleteFileV2Params) WithTimeout(timeout time.Duration) *RTRDeleteFileV2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the r t r delete file v2 params
func (o *RTRDeleteFileV2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the r t r delete file v2 params
func (o *RTRDeleteFileV2Params) WithContext(ctx context.Context) *RTRDeleteFileV2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the r t r delete file v2 params
func (o *RTRDeleteFileV2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the r t r delete file v2 params
func (o *RTRDeleteFileV2Params) WithHTTPClient(client *http.Client) *RTRDeleteFileV2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the r t r delete file v2 params
func (o *RTRDeleteFileV2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the r t r delete file v2 params
func (o *RTRDeleteFileV2Params) WithIds(ids string) *RTRDeleteFileV2Params {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the r t r delete file v2 params
func (o *RTRDeleteFileV2Params) SetIds(ids string) {
	o.Ids = ids
}

// WithSessionID adds the sessionID to the r t r delete file v2 params
func (o *RTRDeleteFileV2Params) WithSessionID(sessionID string) *RTRDeleteFileV2Params {
	o.SetSessionID(sessionID)
	return o
}

// SetSessionID adds the sessionId to the r t r delete file v2 params
func (o *RTRDeleteFileV2Params) SetSessionID(sessionID string) {
	o.SessionID = sessionID
}

// WriteToRequest writes these params to a swagger request
func (o *RTRDeleteFileV2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param ids
	qrIds := o.Ids
	qIds := qrIds
	if qIds != "" {

		if err := r.SetQueryParam("ids", qIds); err != nil {
			return err
		}
	}

	// query param session_id
	qrSessionID := o.SessionID
	qSessionID := qrSessionID
	if qSessionID != "" {

		if err := r.SetQueryParam("session_id", qSessionID); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
