// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// RTRExecuteActiveResponderCommandReader is a Reader for the RTRExecuteActiveResponderCommand structure.
type RTRExecuteActiveResponderCommandReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RTRExecuteActiveResponderCommandReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewRTRExecuteActiveResponderCommandCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRTRExecuteActiveResponderCommandBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRTRExecuteActiveResponderCommandForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewRTRExecuteActiveResponderCommandTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /real-time-response/entities/active-responder-command/v1] RTR-ExecuteActiveResponderCommand", response, response.Code())
	}
}

// NewRTRExecuteActiveResponderCommandCreated creates a RTRExecuteActiveResponderCommandCreated with default headers values
func NewRTRExecuteActiveResponderCommandCreated() *RTRExecuteActiveResponderCommandCreated {
	return &RTRExecuteActiveResponderCommandCreated{}
}

/*
RTRExecuteActiveResponderCommandCreated describes a response with status code 201, with default header values.

Created
*/
type RTRExecuteActiveResponderCommandCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainCommandExecuteResponseWrapper
}

// IsSuccess returns true when this r t r execute active responder command created response has a 2xx status code
func (o *RTRExecuteActiveResponderCommandCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this r t r execute active responder command created response has a 3xx status code
func (o *RTRExecuteActiveResponderCommandCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r execute active responder command created response has a 4xx status code
func (o *RTRExecuteActiveResponderCommandCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this r t r execute active responder command created response has a 5xx status code
func (o *RTRExecuteActiveResponderCommandCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r execute active responder command created response a status code equal to that given
func (o *RTRExecuteActiveResponderCommandCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the r t r execute active responder command created response
func (o *RTRExecuteActiveResponderCommandCreated) Code() int {
	return 201
}

func (o *RTRExecuteActiveResponderCommandCreated) Error() string {
	return fmt.Sprintf("[POST /real-time-response/entities/active-responder-command/v1][%d] rTRExecuteActiveResponderCommandCreated  %+v", 201, o.Payload)
}

func (o *RTRExecuteActiveResponderCommandCreated) String() string {
	return fmt.Sprintf("[POST /real-time-response/entities/active-responder-command/v1][%d] rTRExecuteActiveResponderCommandCreated  %+v", 201, o.Payload)
}

func (o *RTRExecuteActiveResponderCommandCreated) GetPayload() *models.DomainCommandExecuteResponseWrapper {
	return o.Payload
}

func (o *RTRExecuteActiveResponderCommandCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainCommandExecuteResponseWrapper)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRExecuteActiveResponderCommandBadRequest creates a RTRExecuteActiveResponderCommandBadRequest with default headers values
func NewRTRExecuteActiveResponderCommandBadRequest() *RTRExecuteActiveResponderCommandBadRequest {
	return &RTRExecuteActiveResponderCommandBadRequest{}
}

/*
RTRExecuteActiveResponderCommandBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type RTRExecuteActiveResponderCommandBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this r t r execute active responder command bad request response has a 2xx status code
func (o *RTRExecuteActiveResponderCommandBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r execute active responder command bad request response has a 3xx status code
func (o *RTRExecuteActiveResponderCommandBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r execute active responder command bad request response has a 4xx status code
func (o *RTRExecuteActiveResponderCommandBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r execute active responder command bad request response has a 5xx status code
func (o *RTRExecuteActiveResponderCommandBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r execute active responder command bad request response a status code equal to that given
func (o *RTRExecuteActiveResponderCommandBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the r t r execute active responder command bad request response
func (o *RTRExecuteActiveResponderCommandBadRequest) Code() int {
	return 400
}

func (o *RTRExecuteActiveResponderCommandBadRequest) Error() string {
	return fmt.Sprintf("[POST /real-time-response/entities/active-responder-command/v1][%d] rTRExecuteActiveResponderCommandBadRequest  %+v", 400, o.Payload)
}

func (o *RTRExecuteActiveResponderCommandBadRequest) String() string {
	return fmt.Sprintf("[POST /real-time-response/entities/active-responder-command/v1][%d] rTRExecuteActiveResponderCommandBadRequest  %+v", 400, o.Payload)
}

func (o *RTRExecuteActiveResponderCommandBadRequest) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *RTRExecuteActiveResponderCommandBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRExecuteActiveResponderCommandForbidden creates a RTRExecuteActiveResponderCommandForbidden with default headers values
func NewRTRExecuteActiveResponderCommandForbidden() *RTRExecuteActiveResponderCommandForbidden {
	return &RTRExecuteActiveResponderCommandForbidden{}
}

/*
RTRExecuteActiveResponderCommandForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RTRExecuteActiveResponderCommandForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r execute active responder command forbidden response has a 2xx status code
func (o *RTRExecuteActiveResponderCommandForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r execute active responder command forbidden response has a 3xx status code
func (o *RTRExecuteActiveResponderCommandForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r execute active responder command forbidden response has a 4xx status code
func (o *RTRExecuteActiveResponderCommandForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r execute active responder command forbidden response has a 5xx status code
func (o *RTRExecuteActiveResponderCommandForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r execute active responder command forbidden response a status code equal to that given
func (o *RTRExecuteActiveResponderCommandForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the r t r execute active responder command forbidden response
func (o *RTRExecuteActiveResponderCommandForbidden) Code() int {
	return 403
}

func (o *RTRExecuteActiveResponderCommandForbidden) Error() string {
	return fmt.Sprintf("[POST /real-time-response/entities/active-responder-command/v1][%d] rTRExecuteActiveResponderCommandForbidden  %+v", 403, o.Payload)
}

func (o *RTRExecuteActiveResponderCommandForbidden) String() string {
	return fmt.Sprintf("[POST /real-time-response/entities/active-responder-command/v1][%d] rTRExecuteActiveResponderCommandForbidden  %+v", 403, o.Payload)
}

func (o *RTRExecuteActiveResponderCommandForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRExecuteActiveResponderCommandForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRExecuteActiveResponderCommandTooManyRequests creates a RTRExecuteActiveResponderCommandTooManyRequests with default headers values
func NewRTRExecuteActiveResponderCommandTooManyRequests() *RTRExecuteActiveResponderCommandTooManyRequests {
	return &RTRExecuteActiveResponderCommandTooManyRequests{}
}

/*
RTRExecuteActiveResponderCommandTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type RTRExecuteActiveResponderCommandTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r execute active responder command too many requests response has a 2xx status code
func (o *RTRExecuteActiveResponderCommandTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r execute active responder command too many requests response has a 3xx status code
func (o *RTRExecuteActiveResponderCommandTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r execute active responder command too many requests response has a 4xx status code
func (o *RTRExecuteActiveResponderCommandTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r execute active responder command too many requests response has a 5xx status code
func (o *RTRExecuteActiveResponderCommandTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r execute active responder command too many requests response a status code equal to that given
func (o *RTRExecuteActiveResponderCommandTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the r t r execute active responder command too many requests response
func (o *RTRExecuteActiveResponderCommandTooManyRequests) Code() int {
	return 429
}

func (o *RTRExecuteActiveResponderCommandTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /real-time-response/entities/active-responder-command/v1][%d] rTRExecuteActiveResponderCommandTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRExecuteActiveResponderCommandTooManyRequests) String() string {
	return fmt.Sprintf("[POST /real-time-response/entities/active-responder-command/v1][%d] rTRExecuteActiveResponderCommandTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRExecuteActiveResponderCommandTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRExecuteActiveResponderCommandTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
