// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewRTRExecuteCommandParams creates a new RTRExecuteCommandParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRTRExecuteCommandParams() *RTRExecuteCommandParams {
	return &RTRExecuteCommandParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRTRExecuteCommandParamsWithTimeout creates a new RTRExecuteCommandParams object
// with the ability to set a timeout on a request.
func NewRTRExecuteCommandParamsWithTimeout(timeout time.Duration) *RTRExecuteCommandParams {
	return &RTRExecuteCommandParams{
		timeout: timeout,
	}
}

// NewRTRExecuteCommandParamsWithContext creates a new RTRExecuteCommandParams object
// with the ability to set a context for a request.
func NewRTRExecuteCommandParamsWithContext(ctx context.Context) *RTRExecuteCommandParams {
	return &RTRExecuteCommandParams{
		Context: ctx,
	}
}

// NewRTRExecuteCommandParamsWithHTTPClient creates a new RTRExecuteCommandParams object
// with the ability to set a custom HTTPClient for a request.
func NewRTRExecuteCommandParamsWithHTTPClient(client *http.Client) *RTRExecuteCommandParams {
	return &RTRExecuteCommandParams{
		HTTPClient: client,
	}
}

/*
RTRExecuteCommandParams contains all the parameters to send to the API endpoint

	for the r t r execute command operation.

	Typically these are written to a http.Request.
*/
type RTRExecuteCommandParams struct {

	/* Body.

	     Use this endpoint to run these [real time response commands](https://falcon.crowdstrike.com/support/documentation/11/getting-started-guide#rtr_commands):
	- `cat`
	- `cd`
	- `clear`
	- `env`
	- `eventlog`
	- `filehash`
	- `getsid`
	- `help`
	- `history`
	- `ipconfig`
	- `ls`
	- `mount`
	- `netstat`
	- `ps`
	- `reg query`

	Required values.  The rest of the fields are unused.
	**`base_command`** read-only command type we are going to execute, for example: `ls` or `cd`.  Refer to the RTR documentation for the full list of commands.
	**`command_string`** Full command string for the command. For example  `cd C:\some_directory`
	**`session_id`** RTR session ID to run the command on
	*/
	Body *models.DomainCommandExecuteRequest

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the r t r execute command params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRExecuteCommandParams) WithDefaults() *RTRExecuteCommandParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the r t r execute command params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRExecuteCommandParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the r t r execute command params
func (o *RTRExecuteCommandParams) WithTimeout(timeout time.Duration) *RTRExecuteCommandParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the r t r execute command params
func (o *RTRExecuteCommandParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the r t r execute command params
func (o *RTRExecuteCommandParams) WithContext(ctx context.Context) *RTRExecuteCommandParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the r t r execute command params
func (o *RTRExecuteCommandParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the r t r execute command params
func (o *RTRExecuteCommandParams) WithHTTPClient(client *http.Client) *RTRExecuteCommandParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the r t r execute command params
func (o *RTRExecuteCommandParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the r t r execute command params
func (o *RTRExecuteCommandParams) WithBody(body *models.DomainCommandExecuteRequest) *RTRExecuteCommandParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the r t r execute command params
func (o *RTRExecuteCommandParams) SetBody(body *models.DomainCommandExecuteRequest) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *RTRExecuteCommandParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
