// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// RTRExecuteCommandReader is a Reader for the RTRExecuteCommand structure.
type RTRExecuteCommandReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RTRExecuteCommandReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewRTRExecuteCommandCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRTRExecuteCommandBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRTRExecuteCommandForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewRTRExecuteCommandTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /real-time-response/entities/command/v1] RTR-ExecuteCommand", response, response.Code())
	}
}

// NewRTRExecuteCommandCreated creates a RTRExecuteCommandCreated with default headers values
func NewRTRExecuteCommandCreated() *RTRExecuteCommandCreated {
	return &RTRExecuteCommandCreated{}
}

/*
RTRExecuteCommandCreated describes a response with status code 201, with default header values.

Created
*/
type RTRExecuteCommandCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainCommandExecuteResponseWrapper
}

// IsSuccess returns true when this r t r execute command created response has a 2xx status code
func (o *RTRExecuteCommandCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this r t r execute command created response has a 3xx status code
func (o *RTRExecuteCommandCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r execute command created response has a 4xx status code
func (o *RTRExecuteCommandCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this r t r execute command created response has a 5xx status code
func (o *RTRExecuteCommandCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r execute command created response a status code equal to that given
func (o *RTRExecuteCommandCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the r t r execute command created response
func (o *RTRExecuteCommandCreated) Code() int {
	return 201
}

func (o *RTRExecuteCommandCreated) Error() string {
	return fmt.Sprintf("[POST /real-time-response/entities/command/v1][%d] rTRExecuteCommandCreated  %+v", 201, o.Payload)
}

func (o *RTRExecuteCommandCreated) String() string {
	return fmt.Sprintf("[POST /real-time-response/entities/command/v1][%d] rTRExecuteCommandCreated  %+v", 201, o.Payload)
}

func (o *RTRExecuteCommandCreated) GetPayload() *models.DomainCommandExecuteResponseWrapper {
	return o.Payload
}

func (o *RTRExecuteCommandCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainCommandExecuteResponseWrapper)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRExecuteCommandBadRequest creates a RTRExecuteCommandBadRequest with default headers values
func NewRTRExecuteCommandBadRequest() *RTRExecuteCommandBadRequest {
	return &RTRExecuteCommandBadRequest{}
}

/*
RTRExecuteCommandBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type RTRExecuteCommandBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this r t r execute command bad request response has a 2xx status code
func (o *RTRExecuteCommandBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r execute command bad request response has a 3xx status code
func (o *RTRExecuteCommandBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r execute command bad request response has a 4xx status code
func (o *RTRExecuteCommandBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r execute command bad request response has a 5xx status code
func (o *RTRExecuteCommandBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r execute command bad request response a status code equal to that given
func (o *RTRExecuteCommandBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the r t r execute command bad request response
func (o *RTRExecuteCommandBadRequest) Code() int {
	return 400
}

func (o *RTRExecuteCommandBadRequest) Error() string {
	return fmt.Sprintf("[POST /real-time-response/entities/command/v1][%d] rTRExecuteCommandBadRequest  %+v", 400, o.Payload)
}

func (o *RTRExecuteCommandBadRequest) String() string {
	return fmt.Sprintf("[POST /real-time-response/entities/command/v1][%d] rTRExecuteCommandBadRequest  %+v", 400, o.Payload)
}

func (o *RTRExecuteCommandBadRequest) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *RTRExecuteCommandBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRExecuteCommandForbidden creates a RTRExecuteCommandForbidden with default headers values
func NewRTRExecuteCommandForbidden() *RTRExecuteCommandForbidden {
	return &RTRExecuteCommandForbidden{}
}

/*
RTRExecuteCommandForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RTRExecuteCommandForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r execute command forbidden response has a 2xx status code
func (o *RTRExecuteCommandForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r execute command forbidden response has a 3xx status code
func (o *RTRExecuteCommandForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r execute command forbidden response has a 4xx status code
func (o *RTRExecuteCommandForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r execute command forbidden response has a 5xx status code
func (o *RTRExecuteCommandForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r execute command forbidden response a status code equal to that given
func (o *RTRExecuteCommandForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the r t r execute command forbidden response
func (o *RTRExecuteCommandForbidden) Code() int {
	return 403
}

func (o *RTRExecuteCommandForbidden) Error() string {
	return fmt.Sprintf("[POST /real-time-response/entities/command/v1][%d] rTRExecuteCommandForbidden  %+v", 403, o.Payload)
}

func (o *RTRExecuteCommandForbidden) String() string {
	return fmt.Sprintf("[POST /real-time-response/entities/command/v1][%d] rTRExecuteCommandForbidden  %+v", 403, o.Payload)
}

func (o *RTRExecuteCommandForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRExecuteCommandForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRExecuteCommandTooManyRequests creates a RTRExecuteCommandTooManyRequests with default headers values
func NewRTRExecuteCommandTooManyRequests() *RTRExecuteCommandTooManyRequests {
	return &RTRExecuteCommandTooManyRequests{}
}

/*
RTRExecuteCommandTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type RTRExecuteCommandTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r execute command too many requests response has a 2xx status code
func (o *RTRExecuteCommandTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r execute command too many requests response has a 3xx status code
func (o *RTRExecuteCommandTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r execute command too many requests response has a 4xx status code
func (o *RTRExecuteCommandTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r execute command too many requests response has a 5xx status code
func (o *RTRExecuteCommandTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r execute command too many requests response a status code equal to that given
func (o *RTRExecuteCommandTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the r t r execute command too many requests response
func (o *RTRExecuteCommandTooManyRequests) Code() int {
	return 429
}

func (o *RTRExecuteCommandTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /real-time-response/entities/command/v1][%d] rTRExecuteCommandTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRExecuteCommandTooManyRequests) String() string {
	return fmt.Sprintf("[POST /real-time-response/entities/command/v1][%d] rTRExecuteCommandTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRExecuteCommandTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRExecuteCommandTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
