// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewRTRGetExtractedFileContentsParams creates a new RTRGetExtractedFileContentsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRTRGetExtractedFileContentsParams() *RTRGetExtractedFileContentsParams {
	return &RTRGetExtractedFileContentsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRTRGetExtractedFileContentsParamsWithTimeout creates a new RTRGetExtractedFileContentsParams object
// with the ability to set a timeout on a request.
func NewRTRGetExtractedFileContentsParamsWithTimeout(timeout time.Duration) *RTRGetExtractedFileContentsParams {
	return &RTRGetExtractedFileContentsParams{
		timeout: timeout,
	}
}

// NewRTRGetExtractedFileContentsParamsWithContext creates a new RTRGetExtractedFileContentsParams object
// with the ability to set a context for a request.
func NewRTRGetExtractedFileContentsParamsWithContext(ctx context.Context) *RTRGetExtractedFileContentsParams {
	return &RTRGetExtractedFileContentsParams{
		Context: ctx,
	}
}

// NewRTRGetExtractedFileContentsParamsWithHTTPClient creates a new RTRGetExtractedFileContentsParams object
// with the ability to set a custom HTTPClient for a request.
func NewRTRGetExtractedFileContentsParamsWithHTTPClient(client *http.Client) *RTRGetExtractedFileContentsParams {
	return &RTRGetExtractedFileContentsParams{
		HTTPClient: client,
	}
}

/*
RTRGetExtractedFileContentsParams contains all the parameters to send to the API endpoint

	for the r t r get extracted file contents operation.

	Typically these are written to a http.Request.
*/
type RTRGetExtractedFileContentsParams struct {

	/* Filename.

	   Filename to use for the archive name and the file within the archive.
	*/
	Filename *string

	/* SessionID.

	   RTR Session id
	*/
	SessionID string

	/* Sha256.

	   Extracted SHA256 (e.g. 'efa256a96af3b556cd3fc9d8b1cf587d72807d7805ced441e8149fc279db422b')
	*/
	Sha256 string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the r t r get extracted file contents params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRGetExtractedFileContentsParams) WithDefaults() *RTRGetExtractedFileContentsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the r t r get extracted file contents params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRGetExtractedFileContentsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the r t r get extracted file contents params
func (o *RTRGetExtractedFileContentsParams) WithTimeout(timeout time.Duration) *RTRGetExtractedFileContentsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the r t r get extracted file contents params
func (o *RTRGetExtractedFileContentsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the r t r get extracted file contents params
func (o *RTRGetExtractedFileContentsParams) WithContext(ctx context.Context) *RTRGetExtractedFileContentsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the r t r get extracted file contents params
func (o *RTRGetExtractedFileContentsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the r t r get extracted file contents params
func (o *RTRGetExtractedFileContentsParams) WithHTTPClient(client *http.Client) *RTRGetExtractedFileContentsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the r t r get extracted file contents params
func (o *RTRGetExtractedFileContentsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilename adds the filename to the r t r get extracted file contents params
func (o *RTRGetExtractedFileContentsParams) WithFilename(filename *string) *RTRGetExtractedFileContentsParams {
	o.SetFilename(filename)
	return o
}

// SetFilename adds the filename to the r t r get extracted file contents params
func (o *RTRGetExtractedFileContentsParams) SetFilename(filename *string) {
	o.Filename = filename
}

// WithSessionID adds the sessionID to the r t r get extracted file contents params
func (o *RTRGetExtractedFileContentsParams) WithSessionID(sessionID string) *RTRGetExtractedFileContentsParams {
	o.SetSessionID(sessionID)
	return o
}

// SetSessionID adds the sessionId to the r t r get extracted file contents params
func (o *RTRGetExtractedFileContentsParams) SetSessionID(sessionID string) {
	o.SessionID = sessionID
}

// WithSha256 adds the sha256 to the r t r get extracted file contents params
func (o *RTRGetExtractedFileContentsParams) WithSha256(sha256 string) *RTRGetExtractedFileContentsParams {
	o.SetSha256(sha256)
	return o
}

// SetSha256 adds the sha256 to the r t r get extracted file contents params
func (o *RTRGetExtractedFileContentsParams) SetSha256(sha256 string) {
	o.Sha256 = sha256
}

// WriteToRequest writes these params to a swagger request
func (o *RTRGetExtractedFileContentsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filename != nil {

		// query param filename
		var qrFilename string

		if o.Filename != nil {
			qrFilename = *o.Filename
		}
		qFilename := qrFilename
		if qFilename != "" {

			if err := r.SetQueryParam("filename", qFilename); err != nil {
				return err
			}
		}
	}

	// query param session_id
	qrSessionID := o.SessionID
	qSessionID := qrSessionID
	if qSessionID != "" {

		if err := r.SetQueryParam("session_id", qSessionID); err != nil {
			return err
		}
	}

	// query param sha256
	qrSha256 := o.Sha256
	qSha256 := qrSha256
	if qSha256 != "" {

		if err := r.SetQueryParam("sha256", qSha256); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
