// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewRTRInitSessionParams creates a new RTRInitSessionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRTRInitSessionParams() *RTRInitSessionParams {
	return &RTRInitSessionParams{
		requestTimeout: cr.DefaultTimeout,
	}
}

// NewRTRInitSessionParamsWithTimeout creates a new RTRInitSessionParams object
// with the ability to set a timeout on a request.
func NewRTRInitSessionParamsWithTimeout(timeout time.Duration) *RTRInitSessionParams {
	return &RTRInitSessionParams{
		requestTimeout: timeout,
	}
}

// NewRTRInitSessionParamsWithContext creates a new RTRInitSessionParams object
// with the ability to set a context for a request.
func NewRTRInitSessionParamsWithContext(ctx context.Context) *RTRInitSessionParams {
	return &RTRInitSessionParams{
		Context: ctx,
	}
}

// NewRTRInitSessionParamsWithHTTPClient creates a new RTRInitSessionParams object
// with the ability to set a custom HTTPClient for a request.
func NewRTRInitSessionParamsWithHTTPClient(client *http.Client) *RTRInitSessionParams {
	return &RTRInitSessionParams{
		HTTPClient: client,
	}
}

/*
RTRInitSessionParams contains all the parameters to send to the API endpoint

	for the r t r init session operation.

	Typically these are written to a http.Request.
*/
type RTRInitSessionParams struct {

	/* Body.

	     **`device_id`** The host agent ID to initialize the RTR session on.  RTR will retrieve an existing session for the calling user on this host
	**`queue_offline`** If we should queue this session if the host is offline.  Any commands run against an offline-queued session will be queued up and executed when the host comes online.
	*/
	Body *models.DomainInitRequest

	/* Timeout.

	   Timeout for how long to wait for the request in seconds, default timeout is 30 seconds. Maximum is 5 minutes.

	   Default: 30
	*/
	Timeout *int64

	/* TimeoutDuration.

	   Timeout duration for how long to wait for the request in duration syntax. Example, `10s`. Valid units: `ns, us, ms, s, m, h`. Maximum is 5 minutes.

	   Default: "30s"
	*/
	TimeoutDuration *string

	requestTimeout time.Duration
	Context        context.Context
	HTTPClient     *http.Client
}

// WithDefaults hydrates default values in the r t r init session params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRInitSessionParams) WithDefaults() *RTRInitSessionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the r t r init session params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRInitSessionParams) SetDefaults() {
	var (
		timeoutDefault = int64(30)

		timeoutDurationDefault = string("30s")
	)

	val := RTRInitSessionParams{
		Timeout:         &timeoutDefault,
		TimeoutDuration: &timeoutDurationDefault,
	}

	val.requestTimeout = o.requestTimeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithRequestTimeout adds the timeout to the r t r init session params
func (o *RTRInitSessionParams) WithRequestTimeout(timeout time.Duration) *RTRInitSessionParams {
	o.SetRequestTimeout(timeout)
	return o
}

// SetRequestTimeout adds the timeout to the r t r init session params
func (o *RTRInitSessionParams) SetRequestTimeout(timeout time.Duration) {
	o.requestTimeout = timeout
}

// WithContext adds the context to the r t r init session params
func (o *RTRInitSessionParams) WithContext(ctx context.Context) *RTRInitSessionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the r t r init session params
func (o *RTRInitSessionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the r t r init session params
func (o *RTRInitSessionParams) WithHTTPClient(client *http.Client) *RTRInitSessionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the r t r init session params
func (o *RTRInitSessionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the r t r init session params
func (o *RTRInitSessionParams) WithBody(body *models.DomainInitRequest) *RTRInitSessionParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the r t r init session params
func (o *RTRInitSessionParams) SetBody(body *models.DomainInitRequest) {
	o.Body = body
}

// WithTimeout adds the timeout to the r t r init session params
func (o *RTRInitSessionParams) WithTimeout(timeout *int64) *RTRInitSessionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the r t r init session params
func (o *RTRInitSessionParams) SetTimeout(timeout *int64) {
	o.Timeout = timeout
}

// WithTimeoutDuration adds the timeoutDuration to the r t r init session params
func (o *RTRInitSessionParams) WithTimeoutDuration(timeoutDuration *string) *RTRInitSessionParams {
	o.SetTimeoutDuration(timeoutDuration)
	return o
}

// SetTimeoutDuration adds the timeoutDuration to the r t r init session params
func (o *RTRInitSessionParams) SetTimeoutDuration(timeoutDuration *string) {
	o.TimeoutDuration = timeoutDuration
}

// WriteToRequest writes these params to a swagger request
func (o *RTRInitSessionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.requestTimeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.Timeout != nil {

		// query param timeout
		var qrTimeout int64

		if o.Timeout != nil {
			qrTimeout = *o.Timeout
		}
		qTimeout := swag.FormatInt64(qrTimeout)
		if qTimeout != "" {

			if err := r.SetQueryParam("timeout", qTimeout); err != nil {
				return err
			}
		}
	}

	if o.TimeoutDuration != nil {

		// query param timeout_duration
		var qrTimeoutDuration string

		if o.TimeoutDuration != nil {
			qrTimeoutDuration = *o.TimeoutDuration
		}
		qTimeoutDuration := qrTimeoutDuration
		if qTimeoutDuration != "" {

			if err := r.SetQueryParam("timeout_duration", qTimeoutDuration); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
