// Code generated by go-swagger; DO NOT EDIT.

package real_time_response

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// RTRListAllSessionsReader is a Reader for the RTRListAllSessions structure.
type RTRListAllSessionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RTRListAllSessionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRTRListAllSessionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRTRListAllSessionsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRTRListAllSessionsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewRTRListAllSessionsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewRTRListAllSessionsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /real-time-response/queries/sessions/v1] RTR-ListAllSessions", response, response.Code())
	}
}

// NewRTRListAllSessionsOK creates a RTRListAllSessionsOK with default headers values
func NewRTRListAllSessionsOK() *RTRListAllSessionsOK {
	return &RTRListAllSessionsOK{}
}

/*
RTRListAllSessionsOK describes a response with status code 200, with default header values.

OK
*/
type RTRListAllSessionsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainListSessionsResponseMsa
}

// IsSuccess returns true when this r t r list all sessions o k response has a 2xx status code
func (o *RTRListAllSessionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this r t r list all sessions o k response has a 3xx status code
func (o *RTRListAllSessionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r list all sessions o k response has a 4xx status code
func (o *RTRListAllSessionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this r t r list all sessions o k response has a 5xx status code
func (o *RTRListAllSessionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r list all sessions o k response a status code equal to that given
func (o *RTRListAllSessionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the r t r list all sessions o k response
func (o *RTRListAllSessionsOK) Code() int {
	return 200
}

func (o *RTRListAllSessionsOK) Error() string {
	return fmt.Sprintf("[GET /real-time-response/queries/sessions/v1][%d] rTRListAllSessionsOK  %+v", 200, o.Payload)
}

func (o *RTRListAllSessionsOK) String() string {
	return fmt.Sprintf("[GET /real-time-response/queries/sessions/v1][%d] rTRListAllSessionsOK  %+v", 200, o.Payload)
}

func (o *RTRListAllSessionsOK) GetPayload() *models.DomainListSessionsResponseMsa {
	return o.Payload
}

func (o *RTRListAllSessionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainListSessionsResponseMsa)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRListAllSessionsBadRequest creates a RTRListAllSessionsBadRequest with default headers values
func NewRTRListAllSessionsBadRequest() *RTRListAllSessionsBadRequest {
	return &RTRListAllSessionsBadRequest{}
}

/*
RTRListAllSessionsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type RTRListAllSessionsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this r t r list all sessions bad request response has a 2xx status code
func (o *RTRListAllSessionsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r list all sessions bad request response has a 3xx status code
func (o *RTRListAllSessionsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r list all sessions bad request response has a 4xx status code
func (o *RTRListAllSessionsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r list all sessions bad request response has a 5xx status code
func (o *RTRListAllSessionsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r list all sessions bad request response a status code equal to that given
func (o *RTRListAllSessionsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the r t r list all sessions bad request response
func (o *RTRListAllSessionsBadRequest) Code() int {
	return 400
}

func (o *RTRListAllSessionsBadRequest) Error() string {
	return fmt.Sprintf("[GET /real-time-response/queries/sessions/v1][%d] rTRListAllSessionsBadRequest  %+v", 400, o.Payload)
}

func (o *RTRListAllSessionsBadRequest) String() string {
	return fmt.Sprintf("[GET /real-time-response/queries/sessions/v1][%d] rTRListAllSessionsBadRequest  %+v", 400, o.Payload)
}

func (o *RTRListAllSessionsBadRequest) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *RTRListAllSessionsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRListAllSessionsForbidden creates a RTRListAllSessionsForbidden with default headers values
func NewRTRListAllSessionsForbidden() *RTRListAllSessionsForbidden {
	return &RTRListAllSessionsForbidden{}
}

/*
RTRListAllSessionsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RTRListAllSessionsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r list all sessions forbidden response has a 2xx status code
func (o *RTRListAllSessionsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r list all sessions forbidden response has a 3xx status code
func (o *RTRListAllSessionsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r list all sessions forbidden response has a 4xx status code
func (o *RTRListAllSessionsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r list all sessions forbidden response has a 5xx status code
func (o *RTRListAllSessionsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r list all sessions forbidden response a status code equal to that given
func (o *RTRListAllSessionsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the r t r list all sessions forbidden response
func (o *RTRListAllSessionsForbidden) Code() int {
	return 403
}

func (o *RTRListAllSessionsForbidden) Error() string {
	return fmt.Sprintf("[GET /real-time-response/queries/sessions/v1][%d] rTRListAllSessionsForbidden  %+v", 403, o.Payload)
}

func (o *RTRListAllSessionsForbidden) String() string {
	return fmt.Sprintf("[GET /real-time-response/queries/sessions/v1][%d] rTRListAllSessionsForbidden  %+v", 403, o.Payload)
}

func (o *RTRListAllSessionsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRListAllSessionsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRListAllSessionsNotFound creates a RTRListAllSessionsNotFound with default headers values
func NewRTRListAllSessionsNotFound() *RTRListAllSessionsNotFound {
	return &RTRListAllSessionsNotFound{}
}

/*
RTRListAllSessionsNotFound describes a response with status code 404, with default header values.

Not Found
*/
type RTRListAllSessionsNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this r t r list all sessions not found response has a 2xx status code
func (o *RTRListAllSessionsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r list all sessions not found response has a 3xx status code
func (o *RTRListAllSessionsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r list all sessions not found response has a 4xx status code
func (o *RTRListAllSessionsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r list all sessions not found response has a 5xx status code
func (o *RTRListAllSessionsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r list all sessions not found response a status code equal to that given
func (o *RTRListAllSessionsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the r t r list all sessions not found response
func (o *RTRListAllSessionsNotFound) Code() int {
	return 404
}

func (o *RTRListAllSessionsNotFound) Error() string {
	return fmt.Sprintf("[GET /real-time-response/queries/sessions/v1][%d] rTRListAllSessionsNotFound  %+v", 404, o.Payload)
}

func (o *RTRListAllSessionsNotFound) String() string {
	return fmt.Sprintf("[GET /real-time-response/queries/sessions/v1][%d] rTRListAllSessionsNotFound  %+v", 404, o.Payload)
}

func (o *RTRListAllSessionsNotFound) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *RTRListAllSessionsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRListAllSessionsTooManyRequests creates a RTRListAllSessionsTooManyRequests with default headers values
func NewRTRListAllSessionsTooManyRequests() *RTRListAllSessionsTooManyRequests {
	return &RTRListAllSessionsTooManyRequests{}
}

/*
RTRListAllSessionsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type RTRListAllSessionsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r list all sessions too many requests response has a 2xx status code
func (o *RTRListAllSessionsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r list all sessions too many requests response has a 3xx status code
func (o *RTRListAllSessionsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r list all sessions too many requests response has a 4xx status code
func (o *RTRListAllSessionsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r list all sessions too many requests response has a 5xx status code
func (o *RTRListAllSessionsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r list all sessions too many requests response a status code equal to that given
func (o *RTRListAllSessionsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the r t r list all sessions too many requests response
func (o *RTRListAllSessionsTooManyRequests) Code() int {
	return 429
}

func (o *RTRListAllSessionsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /real-time-response/queries/sessions/v1][%d] rTRListAllSessionsTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRListAllSessionsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /real-time-response/queries/sessions/v1][%d] rTRListAllSessionsTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRListAllSessionsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRListAllSessionsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
